/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.refresh;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.sqltools.internal.refresh.ICatalogObjectListener2;

public class RefreshManager2 {
    private RefreshManager _delegate = RefreshManager.getInstance();
    private static RefreshManager2 instance = null;
    private HashMap listeners = new HashMap();
    private HashMap typeListeners = new HashMap();
    private ArrayList globalListeners = new ArrayList();

    private RefreshManager2() {
    }

    public static RefreshManager2 getInstance() {
        if (instance == null) {
            instance = new RefreshManager2();
        }
        return instance;
    }

    public void addListener(ICatalogObject interestedObject, ICatalogObjectListener2 listener) {
        if (interestedObject == null) {
            if (!this.globalListeners.contains(listener)) {
                this.globalListeners.add(listener);
            }
        } else if (this.listeners.containsKey(interestedObject)) {
            ArrayList listenerLinks = (ArrayList)this.listeners.get(interestedObject);
            if (!listenerLinks.contains(listener)) {
                listenerLinks.add(listener);
            }
        } else {
            ArrayList<ICatalogObjectListener2> listenerLinks = new ArrayList<ICatalogObjectListener2>();
            listenerLinks.add(listener);
            this.listeners.put(interestedObject, listenerLinks);
        }
    }

    public void addListener(Class type, ICatalogObjectListener2 listener) {
        if (type == null) {
            if (!this.globalListeners.contains(listener)) {
                this.globalListeners.add(listener);
            }
        } else if (this.typeListeners.containsKey(type)) {
            ArrayList listenerLinks = (ArrayList)this.typeListeners.get(type);
            if (!listenerLinks.contains(listener)) {
                listenerLinks.add(listener);
            }
        } else {
            ArrayList<ICatalogObjectListener2> listenerLinks = new ArrayList<ICatalogObjectListener2>();
            listenerLinks.add(listener);
            this.typeListeners.put(type, listenerLinks);
        }
    }

    public void removeListener(ICatalogObject interestedObject, ICatalogObjectListener2 listener) {
        ArrayList listenerLinks;
        if (interestedObject == null) {
            if (this.globalListeners.contains(listener)) {
                this.globalListeners.remove(listener);
            }
        } else if (this.listeners.containsKey(interestedObject) && (listenerLinks = (ArrayList)this.listeners.get(interestedObject)).contains(listener)) {
            listenerLinks.remove(listener);
        }
    }

    public void removeListener(Class type, ICatalogObjectListener2 listener) {
        ArrayList listenerLinks;
        if (type == null) {
            if (this.globalListeners.contains(listener)) {
                this.globalListeners.remove(listener);
            }
        } else if (this.typeListeners.containsKey(type) && (listenerLinks = (ArrayList)this.typeListeners.get(type)).contains(listener)) {
            listenerLinks.remove(listener);
        }
    }

    public void clearListener() {
        this.listeners.clear();
        this.typeListeners.clear();
        this.globalListeners.clear();
    }

    public void referesh(ICatalogObject object, String context) {
        this._delegate.referesh(object);
        for (int i = 0; i < this.globalListeners.size(); ++i) {
            ((ICatalogObjectListener2)this.globalListeners.get(i)).notifyChanged(object, 0, context);
        }
        Iterator it = this.typeListeners.keySet().iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            if (!clazz.isInstance(object)) continue;
            ArrayList listenerLinks = (ArrayList)this.typeListeners.get(object);
            for (int i = 0; i < listenerLinks.size(); ++i) {
                ICatalogObjectListener2 listener = (ICatalogObjectListener2)listenerLinks.get(i);
                listener.notifyChanged(object, 0, context);
            }
        }
        if (this.listeners.containsKey(object)) {
            ArrayList listenerLinks = (ArrayList)this.listeners.get(object);
            for (int i = 0; i < listenerLinks.size(); ++i) {
                ICatalogObjectListener2 listener = (ICatalogObjectListener2)listenerLinks.get(i);
                listener.notifyChanged(object, 0, context);
            }
        }
    }
}

