/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core.profile;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.DBHelper;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.ServerIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ConnectProfile;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.internal.core.profile.Messages;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

public class ProfileUtil {
    public static final String PROFILE_DB_VERSION_TYPE = "org.eclipse.datatools.connectivity.versionInfo";
    public static final String PROFILE_DB_VERSION = "server.version";
    public static final String PROFILE_DB_VENDOR_NAME = "server.name";
    public static final String DRIVER_DB_VERSION = "org.eclipse.datatools.connectivity.db.version";
    public static final String DRIVER_DB_VENDOR_NAME = "org.eclipse.datatools.connectivity.db.vendor";
    public static final String UID = "org.eclipse.datatools.connectivity.db.username";
    public static final String PWD = "org.eclipse.datatools.connectivity.db.password";
    public static final String DRIVERDEFINITIONID = "org.eclipse.datatools.connectivity.driverDefinitionID";
    public static final String DATABASENAME = "org.eclipse.datatools.connectivity.db.databaseName";
    public static final String URL = "org.eclipse.datatools.connectivity.db.URL";
    public static final String DRIVERCLASS = "org.eclipse.datatools.connectivity.db.driverClass";
    public static final String DRIVER_DATABASE_CATEGORY_ID = "org.eclipse.datatools.connectivity.db.driverCategory";
    public static final String DATABASE_CATEGORY_ID = "org.eclipse.datatools.connectivity.db.category";
    public static final String PROP_DB_CONN_PROPS = "org.eclipse.datatools.connectivity.db.connectionProperties";
    public static final int SQLMODEL_MODE_NONE = 0;
    public static final int SQLMODEL_MODE_ONLINE = 1;
    public static final int SQLMODEL_MODE_OFFLINE = 2;
    private static ArrayList _unknowVersionProfiles = new ArrayList();

    public static int getSQLModelMode(SQLObject object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof ICatalogObject) {
            return 1;
        }
        return 2;
    }

    public static int getSQLModelMode(String profileName) {
        try {
            IConnectionProfile profile = ProfileUtil.getProfile(profileName);
            if (!profile.isConnected()) {
                return 0;
            }
            IManagedConnection mc = profile.getManagedConnection(ConnectionInfo.class.getName());
            IConnection ic = mc.getConnection();
            if (ic == null) {
                return 0;
            }
            Object rawConn = ic.getRawConnection();
            if (rawConn instanceof ConnectionInfo) {
                ConnectionInfo ci = (ConnectionInfo)rawConn;
                if (ci.getSharedDatabase() == null) {
                    return 0;
                }
                if (ci.getSharedConnection() == null) {
                    return 2;
                }
                return 1;
            }
        }
        catch (NoSuchProfileException e) {
            EditorCorePlugin.getDefault().log(e);
        }
        return 0;
    }

    public static DatabaseDefinition getDatabaseDefinition(String profileName) {
        DatabaseVendorDefinitionId id = ProfileUtil.getDatabaseVendorDefinitionId(profileName);
        return ProfileUtil.getDatabaseDefinition(id);
    }

    public static DatabaseDefinition getDatabaseDefinition(DatabaseVendorDefinitionId id) {
        Iterator i;
        DatabaseDefinitionRegistry databaseDefinitionRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
        DatabaseDefinition definition = databaseDefinitionRegistry.getDefinition(id.getProductName(), id.getVersion());
        if (definition == null && (id = SQLToolsFacade.recognize(id.getProductName(), id.getVersion())) != null) {
            definition = databaseDefinitionRegistry.getDefinition(id.getProductName(), id.getVersion());
        }
        if (definition == null && (i = databaseDefinitionRegistry.getVersions(id.getProductName())) != null) {
            String version = "0";
            while (i.hasNext()) {
                String v = (String)i.next();
                if (v.compareTo(version) < 0) continue;
                version = v;
            }
            definition = databaseDefinitionRegistry.getDefinition(id.getProductName(), version);
        }
        return definition;
    }

    public static IConnectionProfile getProfile(String name) throws NoSuchProfileException {
        IConnectionProfile p = ProfileManager.getInstance().getProfileByName(name);
        if (p == null) {
            throw new NoSuchProfileException(name);
        }
        return p;
    }

    public static boolean profileExist(String name) {
        try {
            ProfileUtil.getProfile(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static DatabaseVendorDefinitionId getDatabaseVendorDefinitionId(String profileName) {
        return ProfileUtil.getDatabaseVendorDefinitionId(profileName, true, true);
    }

    public static DatabaseVendorDefinitionId getDatabaseVendorDefinitionId(IConnectionProfile profile) {
        return ProfileUtil.getDatabaseVendorDefinitionId(profile, true, true);
    }

    public static DatabaseVendorDefinitionId getDatabaseVendorDefinitionId(String profileName, boolean getCacheInfo, boolean normalize) {
        IConnectionProfile profile = null;
        try {
            profile = ProfileUtil.getProfile(profileName);
        }
        catch (NoSuchProfileException e) {
            // empty catch block
        }
        return ProfileUtil.getDatabaseVendorDefinitionId(profile, getCacheInfo, normalize);
    }

    public static DatabaseVendorDefinitionId getDatabaseVendorDefinitionId(IConnectionProfile profile, boolean getCacheInfo, boolean normalize) {
        DatabaseVendorDefinitionId vendorId = SQLDevToolsConfiguration.getDefaultInstance().getDatabaseVendorDefinitionId();
        if (profile != null) {
            String vendor = ProfileUtil.getVendorInProperties(profile);
            String version = ProfileUtil.getVersionInProperties(profile);
            if (getCacheInfo && vendor != null && version != null) {
                vendorId = new DatabaseVendorDefinitionId(vendor, version);
            } else {
                String driverID = profile.getBaseProperties().getProperty(DRIVERDEFINITIONID);
                if (driverID == null) {
                    if (profile.getCategory() == null || !DATABASE_CATEGORY_ID.equals(profile.getCategory().getId())) {
                        return null;
                    }
                    EditorCorePlugin.getDefault().log(NLS.bind((String)Messages.ProfileUtil_error_getdriver, (Object[])new Object[]{profile.getName()}));
                } else {
                    DriverInstance driver = DriverManager.getInstance().getDriverInstanceByID(driverID);
                    if (driver != null) {
                        vendor = driver.getProperty(DRIVER_DB_VENDOR_NAME);
                        version = driver.getProperty(DRIVER_DB_VERSION);
                        vendorId = new DatabaseVendorDefinitionId(vendor, version);
                    }
                }
            }
        }
        if (normalize) {
            return SQLToolsFacade.getDeclaredDatabaseVendorDefinitionId(vendorId);
        }
        return vendorId;
    }

    public static ServerIdentifier getServerIdentifier(DatabaseIdentifier databaseIdentifier) {
        ProfileManager pManager = ProfileManager.getInstance();
        IConnectionProfile connProfile1 = pManager.getProfileByName(databaseIdentifier.getProfileName());
        if (connProfile1 == null) {
            return null;
        }
        Properties profile1Props = connProfile1.getBaseProperties();
        String host = null;
        String port = null;
        String url = profile1Props.getProperty(URL);
        DBHelper helper = SQLToolsFacade.getDBHelper(databaseIdentifier);
        return helper.getServerIdentifier(host, port, url, ProfileUtil.getDatabaseVendorDefinitionId(databaseIdentifier.getProfileName()));
    }

    public static String getProductVersion(String profileName) {
        try {
            IConnectionProfile profile = ProfileUtil.getProfile(profileName);
            String version = ProfileUtil.getVersionInProperties(profile);
            if (version == null) {
                if (_unknowVersionProfiles.contains(profile)) {
                    return null;
                }
                profile.createConnection("org.eclipse.datatools.connectivity.connectionFactory.pingFactory");
                version = ProfileUtil.getVersionInProperties(profile);
                if (version == null) {
                    _unknowVersionProfiles.add(profile);
                }
            }
            return version;
        }
        catch (NoSuchProfileException e) {
            return null;
        }
    }

    private static String getVersionInProperties(IConnectionProfile profile) {
        Properties props = profile.getProperties(PROFILE_DB_VERSION_TYPE);
        if (props != null) {
            return props.getProperty(PROFILE_DB_VERSION);
        }
        return null;
    }

    private static String getVendorInProperties(IConnectionProfile profile) {
        Properties props = profile.getProperties(PROFILE_DB_VERSION_TYPE);
        if (props != null) {
            return props.getProperty(PROFILE_DB_VENDOR_NAME);
        }
        return null;
    }

    public static String getUserName(IConnectionProfile profile) {
        if (profile == null) {
            return null;
        }
        return profile.getBaseProperties().getProperty(UID);
    }

    public static String getPassword(IConnectionProfile profile) {
        if (profile == null) {
            return null;
        }
        return profile.getBaseProperties().getProperty(PWD);
    }

    public static String getConnectionProfileId(String profileName) throws NoSuchProfileException {
        try {
            IConnectionProfile profile = ProfileUtil.getProfile(profileName);
            return profile.getProviderId();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Database getDatabase(DatabaseIdentifier databaseIdentifier) {
        return ProfileUtil.getDatabase(databaseIdentifier, true);
    }

    public static Database getDatabase(DatabaseIdentifier databaseIdentifier, boolean connect) {
        try {
            Object rawConn;
            IConnectionProfile profile = ProfileUtil.getProfile(databaseIdentifier.getProfileName());
            IManagedConnection mc = profile.getManagedConnection(ConnectionInfo.class.getName());
            IConnection ic = mc.getConnection();
            if (ic == null) {
                return null;
            }
            if (!mc.isConnected()) {
                if (connect) {
                    profile.connect();
                } else {
                    return null;
                }
            }
            if ((rawConn = ic.getRawConnection()) instanceof ConnectionInfo) {
                ConnectionInfo ci = (ConnectionInfo)rawConn;
                return ci.getSharedDatabase();
            }
        }
        catch (NoSuchProfileException e) {
            EditorCorePlugin.getDefault().log(e);
        }
        return null;
    }

    public static Connection getReusableConnection(DatabaseIdentifier databaseIdentifier) throws SQLException, NoSuchProfileException {
        IConnectionProfile profile = ProfileUtil.getProfile(databaseIdentifier.getProfileName());
        if (!profile.isConnected()) {
            throw new SQLException(NLS.bind((String)Messages.ProfileUtil_error_not_connected, (Object[])new Object[]{databaseIdentifier.getProfileName()}));
        }
        IManagedConnection managedConn = profile.getManagedConnection("java.sql.Connection");
        if (managedConn == null || !managedConn.isConnected()) {
            throw new SQLException(NLS.bind((String)Messages.ProfileUtil_error_getReusableConnection, (Object[])new Object[]{databaseIdentifier.toString()}));
        }
        IConnection iconn = managedConn.getConnection();
        DBHelper helper = SQLToolsFacade.getDBHelper(databaseIdentifier);
        Connection conn = (Connection)iconn.getRawConnection();
        helper.switchDatabase(databaseIdentifier, conn);
        return conn;
    }

    public static Connection getOrCreateReusableConnection(DatabaseIdentifier databaseIdentifier) throws SQLException, NoSuchProfileException {
        IManagedConnection managedConn;
        IConnectionProfile profile = ProfileUtil.getProfile(databaseIdentifier.getProfileName());
        if (!profile.isConnected()) {
            ProfileUtil.connectProfile(databaseIdentifier.getProfileName());
        }
        if ((managedConn = profile.getManagedConnection("java.sql.Connection")) == null || !managedConn.isConnected()) {
            throw new SQLException(NLS.bind((String)Messages.ProfileUtil_error_getReusableConnection, (Object[])new Object[]{databaseIdentifier.toString()}));
        }
        IConnection iconn = managedConn.getConnection();
        DBHelper helper = SQLToolsFacade.getDBHelper(databaseIdentifier);
        Connection conn = (Connection)iconn.getRawConnection();
        helper.switchDatabase(databaseIdentifier, conn);
        return conn;
    }

    public static Connection createConnection(String profileName, String dbName) {
        try {
            Connection conn = ProfileUtil.createConnection(ProfileUtil.getProfile(profileName), dbName);
            return conn;
        }
        catch (NoSuchProfileException e) {
            EditorCorePlugin.getDefault().log(e);
            return null;
        }
    }

    public static Connection connectProfile(String profileName) {
        IStatus status;
        IConnectionProfile profile = null;
        Connection conn = null;
        try {
            profile = ProfileUtil.getProfile(profileName);
        }
        catch (NoSuchProfileException e1) {
            EditorCorePlugin.getDefault().log(e1);
            return null;
        }
        if (!profile.isConnected() && !(status = profile.connect()).isOK()) {
            return null;
        }
        try {
            conn = ProfileUtil.getReusableConnection(new DatabaseIdentifier(profileName));
        }
        catch (Exception e1) {
            EditorCorePlugin.getDefault().log(e1);
            return null;
        }
        return conn;
    }

    public static Connection createConnection(IConnectionProfile profile, String dbName) {
        if (!profile.isConnected()) {
            return ProfileUtil.connectProfile(profile.getName());
        }
        try {
            Connection conn = null;
            IConnection c = profile.createConnection("java.sql.Connection");
            if (c != null) {
                Object rawConn = c.getRawConnection();
                if (rawConn instanceof Connection) {
                    conn = (Connection)rawConn;
                } else if (rawConn instanceof ConnectionInfoImpl) {
                    conn = ((ConnectionInfoImpl)rawConn).getSharedConnection();
                } else {
                    throw new SQLException(NLS.bind((String)Messages.ProfileUtil_unkown_connection_type, (Object[])new Object[]{c.getClass().getName(), profile.getName()}));
                }
            }
            if (conn != null && dbName != null) {
                DatabaseIdentifier databaseIdentifier = new DatabaseIdentifier(profile.getName(), dbName);
                DBHelper helper = SQLToolsFacade.getDBHelper(databaseIdentifier);
                helper.switchDatabase(databaseIdentifier, conn);
            }
            return conn;
        }
        catch (Exception e) {
            EditorCorePlugin.getDefault().log(NLS.bind((String)Messages.ProfileUtil_error_create_connection, (Object[])new Object[]{profile.getName()}), e);
            return null;
        }
    }

    public static void closeConnection(String profileName, String dbName, Connection conn) {
        if (conn != null) {
            try {
                Connection sharedConn = ProfileUtil.getReusableConnection(new DatabaseIdentifier(profileName, dbName));
                if (conn != sharedConn) {
                    conn.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static List getDatabaseList(String profileName) {
        return ProfileUtil.getDatabaseList(profileName, true);
    }

    public static List getDatabaseList(String profileName, boolean connect) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ProfileUtil.getProfile(profileName);
            if (connect) {
                ProfileUtil.connectProfile(profileName);
            }
        }
        catch (NoSuchProfileException e1) {
            EditorCorePlugin.getDefault().log(e1);
            return list;
        }
        Database db = ProfileUtil.getDatabase(new DatabaseIdentifier(profileName, ""), connect);
        if (db != null) {
            EList catalogs = db.getCatalogs();
            if (catalogs != null && !catalogs.isEmpty()) {
                Iterator it = catalogs.iterator();
                while (it.hasNext()) {
                    Catalog cat = (Catalog)it.next();
                    if (cat.getName() == null || cat.getName().equals("")) continue;
                    list.add(cat.getName());
                }
            } else {
                list.add(db.getName());
            }
            if (list.isEmpty()) {
                list.add(db.getName());
            }
        }
        return list;
    }

    public static String[] getSupportedDatabaseProfiles() {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfiles();
        ArrayList<String> DBProfileNames = new ArrayList<String>();
        for (int i = 0; i < profiles.length; ++i) {
            SQLDevToolsConfiguration conf;
            if (!ProfileUtil.isDatabaseProfile(profiles[i]) || (conf = SQLToolsFacade.getConfigurationByProfileName(profiles[i].getName())) == null || conf.equals(SQLDevToolsConfiguration.getDefaultInstance())) continue;
            DBProfileNames.add(profiles[i].getName());
        }
        return DBProfileNames.toArray(new String[DBProfileNames.size()]);
    }

    public static String getProfileUserName(DatabaseIdentifier databaseIdentifier, boolean createConnection) {
        if (databaseIdentifier.getProfileName() == null) {
            return "";
        }
        IControlConnection con = null;
        try {
            con = createConnection ? EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(databaseIdentifier) : EditorCorePlugin.getControlConnectionManager().getControlConnection(databaseIdentifier);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (con != null) {
            try {
                String dbUsername = con.getDbUsername();
                if (dbUsername != null) {
                    return dbUsername;
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        try {
            IConnectionProfile profile = ProfileUtil.getProfile(databaseIdentifier.getProfileName());
            return profile.getBaseProperties().getProperty(UID);
        }
        catch (NoSuchProfileException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isSupportedProfile(IConnectionProfile profile) {
        Collection names = SQLToolsFacade.getAllAvailableDBDefinitionNames();
        DatabaseVendorDefinitionId vendorId = ProfileUtil.getDatabaseVendorDefinitionId(profile);
        if (names == null || vendorId == null) {
            return false;
        }
        if (vendorId.equals(SQLToolsFacade.getDefaultDatabaseVendorDefinitionId()) && !ProfileUtil.isDatabaseProfile(profile.getName())) {
            return false;
        }
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!vendorId.toString().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDatabaseProfile(IConnectionProfile connectionProfile) {
        return connectionProfile != null && connectionProfile.getCategory().getId().equalsIgnoreCase(DATABASE_CATEGORY_ID);
    }

    public static boolean isDatabaseProfile(ConnectProfile connectProfile) {
        IConnectionProfile connectionProfile = ProfileManager.getInstance().getProfileByName(connectProfile.getName());
        return ProfileUtil.isDatabaseProfile(connectionProfile);
    }

    public static boolean isDatabaseProfile(String profileName) {
        try {
            return ProfileUtil.isDatabaseProfile(ProfileUtil.getProfile(profileName));
        }
        catch (NoSuchProfileException e) {
            return false;
        }
    }

    public static String getProfileDatabaseName(String profileName) {
        IConnectionProfile connectionProfile = ProfileManager.getInstance().getProfileByName(profileName);
        if (ProfileUtil.isDatabaseProfile(connectionProfile) && connectionProfile != null && connectionProfile.getBaseProperties() != null) {
            String dbName = (String)connectionProfile.getBaseProperties().get(DATABASENAME);
            if (dbName == null || dbName.equals("")) {
                // empty if block
            }
            return dbName == null || dbName.equals("%") ? "" : dbName;
        }
        return "";
    }

    public static IConnectionProfile[] getProfiles() {
        ProfileManager pManager = ProfileManager.getInstance();
        IConnectionProfile[] allProfiles = pManager.getProfiles();
        ArrayList<IConnectionProfile> profileList = new ArrayList<IConnectionProfile>();
        Collection ids = SQLToolsFacade.getAllAvailableDBDefinitionIds();
        block0: for (int i = 0; i < allProfiles.length; ++i) {
            if (ProfileUtil.isDatabaseProfile(allProfiles[i])) {
                profileList.add(allProfiles[i]);
                continue;
            }
            DatabaseVendorDefinitionId vendorId = ProfileUtil.getDatabaseVendorDefinitionId(allProfiles[i].getName(), false, false);
            if (vendorId == null) continue;
            Iterator iter = ids.iterator();
            while (iter.hasNext()) {
                DatabaseVendorDefinitionId id = (DatabaseVendorDefinitionId)iter.next();
                if (!vendorId.equals(id)) continue;
                profileList.add(allProfiles[i]);
                continue block0;
            }
        }
        IConnectionProfile[] profiles = profileList.toArray(new IConnectionProfile[profileList.size()]);
        return profiles;
    }
}

