/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.identifier;

import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.sql.identifier.IIdentifierValidator;
import org.eclipse.datatools.sqltools.sql.identifier.ValidatorMessage;
import org.eclipse.datatools.sqltools.sql.internal.identifier.Messages;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;
import org.eclipse.osgi.util.NLS;

public class DefaultIdentifierValidator
implements IIdentifierValidator {
    public static final int MAXIMUM_ID_LENGTH = 30;
    private static IIdentifierValidator _instance = null;
    private int _level = 3;

    public static synchronized IIdentifierValidator getInstance() {
        if (_instance == null) {
            return new DefaultIdentifierValidator();
        }
        return _instance;
    }

    public ValidatorMessage isValid(String value, int identifierType, DatabaseIdentifier databaseIdentifier) {
        int oldLevel = this._level;
        this.setLevel(2);
        ValidatorMessage errorMsg = this.doValidCheck(value, identifierType, databaseIdentifier);
        this.setLevel(1);
        ValidatorMessage warnMsg = this.doValidCheck(value, identifierType, databaseIdentifier);
        this.setLevel(oldLevel);
        ValidatorMessage result = null;
        if (this._level == 3) {
            if (errorMsg != null && errorMsg.getType() == 2) {
                result = errorMsg;
            } else if (warnMsg != null && warnMsg.getType() == 1) {
                result = warnMsg;
            }
        } else if (this._level == 2) {
            if (errorMsg != null && errorMsg.getType() == 2) {
                result = errorMsg;
            }
        } else if (this._level == 1 && warnMsg != null && warnMsg.getType() == 1) {
            result = warnMsg;
        }
        return result;
    }

    public ValidatorMessage doValidCheck(String value, int identifierType, DatabaseIdentifier databaseIdentifier) {
        ValidatorMessage errorMsg = this.checkIdentiferLength(value);
        if (ValidatorMessage.hasError(errorMsg, this._level)) {
            return errorMsg;
        }
        boolean quotedIdentifier = SQLDevToolsUtil.isQuotedIdentifierOn(databaseIdentifier);
        if (quotedIdentifier) {
            if (identifierType != 0) {
                errorMsg = this.checkStartCharacterQuotedIdentifierOn(value, identifierType, databaseIdentifier);
            }
            if (ValidatorMessage.hasError(errorMsg, this._level)) {
                return errorMsg;
            }
            errorMsg = this.checkQuotedIdentifierOnOthers(value, identifierType, databaseIdentifier);
            if (ValidatorMessage.hasError(errorMsg, this._level)) {
                return errorMsg;
            }
        }
        if (this.supportsDelimitedIdentifier(identifierType) && quotedIdentifier && (SQLUtil.findQuotes((String)value) == 2 || value != null && value.startsWith("[") && value.endsWith("]"))) {
            errorMsg = this.checkDelimitedIdentifier(value);
            if (ValidatorMessage.hasError(errorMsg, this._level)) {
                return errorMsg;
            }
        } else {
            errorMsg = this.checkStartCharacter(value, identifierType, databaseIdentifier);
            if (ValidatorMessage.hasError(errorMsg, this._level)) {
                return errorMsg;
            }
            errorMsg = this.checkquotePermit(value);
            if (ValidatorMessage.hasError(errorMsg, this._level)) {
                return errorMsg;
            }
            errorMsg = this.checkIdentifierPart(value, identifierType, databaseIdentifier);
            if (ValidatorMessage.hasError(errorMsg, this._level)) {
                return errorMsg;
            }
            errorMsg = this.checkReservedwords(value, databaseIdentifier);
            if (ValidatorMessage.hasError(errorMsg, this._level)) {
                return errorMsg;
            }
            errorMsg = this.checkCustomization(value, identifierType, databaseIdentifier);
            if (ValidatorMessage.hasError(errorMsg, this._level)) {
                return errorMsg;
            }
        }
        return new ValidatorMessage(0, "");
    }

    protected boolean supportsDelimitedIdentifier(int identifierType) {
        return identifierType != 6 && identifierType != 11;
    }

    protected ValidatorMessage checkQuotedIdentifierOnOthers(String value, int identifierType, DatabaseIdentifier databaseIdentifier) {
        return null;
    }

    protected ValidatorMessage checkReservedwords(String value, DatabaseIdentifier databaseIdentifier) {
        int i;
        SQLDevToolsConfiguration conf = SQLToolsFacade.getConfiguration(null, databaseIdentifier);
        String[] reserved = conf.getSQLService().getSQLSyntax().getReservedwords();
        String[] types = conf.getSQLService().getSQLSyntax().getTypes();
        for (i = 0; i < reserved.length; ++i) {
            if (!value.equalsIgnoreCase(reserved[i])) continue;
            return new ValidatorMessage(2, Messages.IdentifierValidator_invalid_reservedword);
        }
        for (i = 0; i < types.length; ++i) {
            if (!value.equalsIgnoreCase(types[i])) continue;
            return new ValidatorMessage(2, Messages.IdentifierValidator_invalid_reservedword);
        }
        return null;
    }

    protected ValidatorMessage checkCustomization(String value, int identiferType, DatabaseIdentifier databaseIdentifier) {
        return null;
    }

    protected ValidatorMessage checkIdentiferLength(String value) {
        return null;
    }

    protected ValidatorMessage checkStartCharacter(String value, int identfierType, DatabaseIdentifier dbIdentifier) {
        String[] validStart = this.getValidStart(identfierType);
        StringBuffer result = new StringBuffer();
        if (validStart.length == 1) {
            result.append(validStart[0]);
        } else if (validStart.length > 1) {
            for (int i = 0; i < validStart.length - 1; ++i) {
                result.append(validStart[i] + ", ");
            }
            result.append(validStart[validStart.length - 1]);
        }
        if (!this.checkFirstEquals(value, validStart)) {
            switch (identfierType) {
                case 0: {
                    return new ValidatorMessage(2, Messages.IdentifierValidator_table_invalidstart);
                }
                case 6: {
                    return new ValidatorMessage(2, Messages.IdentifierValidator_localvariable_invalidstart);
                }
                case 11: {
                    return new ValidatorMessage(2, Messages.IdentifierValidator_parameter_invalidstart);
                }
            }
            return new ValidatorMessage(2, NLS.bind((String)Messages.IdentifierValidator_other_invalidstart, (Object[])new Object[]{result.toString()}));
        }
        return null;
    }

    protected ValidatorMessage checkStartCharacterQuotedIdentifierOn(String value, int identfierType, DatabaseIdentifier dbIdentifier) {
        return new ValidatorMessage(0, "");
    }

    protected String[] getValidStart(int identfierType) {
        String[] validStart = null;
        switch (identfierType) {
            case 0: {
                validStart = new String[]{"_", "#"};
                break;
            }
            case 6: {
                validStart = new String[]{"_", "@"};
                break;
            }
            case 11: {
                validStart = new String[]{"_", "@"};
                break;
            }
            default: {
                validStart = new String[]{"_"};
            }
        }
        return validStart;
    }

    private boolean checkFirstEquals(String value, String[] validStart) {
        boolean firstValid = false;
        if (Character.isLetter(value.charAt(0))) {
            firstValid = true;
        } else {
            for (int i = 0; i < validStart.length; ++i) {
                if (!value.startsWith(validStart[i])) continue;
                firstValid = true;
                break;
            }
        }
        return firstValid;
    }

    protected ValidatorMessage checkIdentifierPart(String value, int identifierType, DatabaseIdentifier dbIdentifier) {
        if (value.length() == 1) {
            return null;
        }
        for (int i = 1; i < value.length(); ++i) {
            if (this.isSQLIdentifierPart(value.charAt(i))) continue;
            return new ValidatorMessage(2, Messages.IdentifierValidator_invalid_part);
        }
        return null;
    }

    protected boolean isSQLIdentifierPart(char c) {
        if (!Character.isLetterOrDigit(c)) {
            String[] validPart = new String[]{"@", "#", "_"};
            for (int i = 0; i < validPart.length; ++i) {
                if (!String.valueOf(c).equals(validPart[i])) continue;
                return true;
            }
            return DefaultIdentifierValidator.isCurrencySymbol(c);
        }
        return true;
    }

    public static boolean isCurrencySymbol(char c) {
        String s = String.valueOf(c);
        if ("\u00a2".equals(s) || "\u00a3".equals(s) || "\u00a4".equals(s) || "\u00a5".equals(s) || "$".equals(s) || s.compareTo("\u20a0") >= 0 && s.compareTo("\u20cf") <= 0) {
            return true;
        }
        String[] currencySymbols = SQLUtil.getAvaiableCurrencySymbols();
        for (int i = 0; i < currencySymbols.length; ++i) {
            if (String.valueOf(c).indexOf(currencySymbols[i]) <= -1) continue;
            return true;
        }
        return false;
    }

    private ValidatorMessage checkquotePermit(String value) {
        if (value == null || "".equals(value.trim())) {
            return null;
        }
        int doublequoteNum = 0;
        for (int i = 0; i < value.length(); ++i) {
            if ("\"".equals(String.valueOf(value.charAt(i)))) {
                ++doublequoteNum;
            }
            if (doublequoteNum <= 0) continue;
            return new ValidatorMessage(2, Messages.IdentifierValidator_doublequotation_notpermit);
        }
        return null;
    }

    private ValidatorMessage checkDelimitedIdentifier(String value) {
        if (value == null || "".equals(value.trim())) {
            return new ValidatorMessage(0, "");
        }
        String[] values = SQLUtil.parseDatabaseObject((String)value);
        if (values == null || values.length == 0 || !SQLUtil.equalsIgnoreQuote((String)values[0], (String)value, (boolean)false)) {
            return new ValidatorMessage(2, Messages.IdentifierValidator_doublequotation_invalid);
        }
        return new ValidatorMessage(0, "");
    }

    public int getMaximumIdLength(int idType) {
        return 30;
    }

    public void setLevel(int level) {
        this._level = level;
    }
}

