/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IManagedConnectionListener;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.query.helper.DataTypeHelper;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.ConnectionException;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.IControlConnectionManager;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.dbitem.IDBItem;
import org.eclipse.datatools.sqltools.core.dbitem.IItemWithCode;
import org.eclipse.datatools.sqltools.core.internal.dbitem.SQLObjectItem;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.internal.core.ControlConnectionManager;
import org.eclipse.datatools.sqltools.internal.core.Messages;
import org.eclipse.datatools.sqltools.sql.reference.IDatatype;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.util.Assert;

public class AbstractControlConnection
implements IControlConnection {
    protected Set _skipConnections = new HashSet();
    protected DatabaseIdentifier _databaseIdentifier;
    protected String _dbUserName = null;
    private Map _procInfoCache = new HashMap();
    protected ControlConnectionManager _manager;
    private SQLToolsManagedConnectionListener _managedConnectionListener;

    public AbstractControlConnection(IControlConnectionManager manager, DatabaseIdentifier databaseIdentifier) {
        Assert.isTrue((boolean)(manager instanceof ControlConnectionManager));
        this._manager = (ControlConnectionManager)manager;
        this._databaseIdentifier = databaseIdentifier;
        try {
            IConnectionProfile profile = ProfileUtil.getProfile(databaseIdentifier.getProfileName());
            IManagedConnection managedConn = profile.getManagedConnection("java.sql.Connection");
            this._managedConnectionListener = new SQLToolsManagedConnectionListener();
            managedConn.addConnectionListener((IManagedConnectionListener)this._managedConnectionListener);
        }
        catch (Exception e) {
            EditorCorePlugin.getDefault().log(e);
        }
    }

    public IControlConnectionManager getManager() {
        return this._manager;
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        return this._databaseIdentifier;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void profileRenamed(String name) {
        IControlConnection controlConnection = (IControlConnection)this._manager._controlConnectionMap.get(this._databaseIdentifier);
        this._manager._controlConnectionMap.remove(this._databaseIdentifier);
        this._databaseIdentifier.setProfileName(name);
        this._manager._controlConnectionMap.put(this._databaseIdentifier, controlConnection);
        this._manager.fireRefreshed(this);
    }

    public String getDatabaseName() {
        return this._databaseIdentifier.getDBname();
    }

    public String getDbUsername() throws SQLException {
        if (this._dbUserName == null) {
            this._dbUserName = this.getReusableConnection().getMetaData().getUserName();
        }
        return this._dbUserName;
    }

    public boolean isTextHidden(DatabaseIdentifier databaseIdentifier, String dbObjectName, int dbObjectType) {
        return false;
    }

    public void fireChange() {
        this._manager.fireRefreshed(this);
    }

    protected void dispose() {
        try {
            IConnectionProfile profile = ProfileUtil.getProfile(this._databaseIdentifier.getProfileName());
            IManagedConnection managedConn = profile.getManagedConnection("java.sql.Connection");
            managedConn.removeConnectionListener((IManagedConnectionListener)this._managedConnectionListener);
        }
        catch (NoSuchProfileException e) {
        }
        catch (Exception e) {
            EditorCorePlugin.getDefault().log(e);
        }
    }

    public boolean okToDisconnect() {
        return true;
    }

    protected void aboutToDisconnect() {
    }

    public boolean disconnect() {
        return this.disconnect(false);
    }

    public boolean disconnect(boolean force) {
        this.dispose();
        this._manager.remove(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDDL(String[] src) throws SQLException {
        Connection con = this.getReusableConnection();
        Statement stmt = con.createStatement();
        try {
            for (int i = 0; i < src.length; ++i) {
                stmt.executeUpdate(src[i]);
            }
            this.refresh();
        }
        finally {
            stmt.close();
        }
    }

    public ProcIdentifier[] getAllProcs() throws SQLException {
        Database db = ProfileUtil.getDatabase(this._databaseIdentifier);
        ArrayList<ProcIdentifier> procs = new ArrayList<ProcIdentifier>();
        if (db != null) {
            EList schemas = db.getSchemas();
            Iterator i = schemas.iterator();
            while (i.hasNext()) {
                Schema schema = (Schema)i.next();
                EList tables = schema.getTables();
                Iterator iter = tables.iterator();
                while (iter.hasNext()) {
                    Table table = (Table)iter.next();
                    EList triggers = table.getTriggers();
                    Iterator itera = triggers.iterator();
                    while (itera.hasNext()) {
                        Trigger trigger = (Trigger)itera.next();
                        procs.add(SQLDevToolsUtil.getProcIdentifier(this._databaseIdentifier, (SQLObject)trigger));
                    }
                }
                EList routines = schema.getRoutines();
                Iterator iter2 = routines.iterator();
                while (iter2.hasNext()) {
                    Routine routine = (Routine)iter2.next();
                    procs.add(SQLDevToolsUtil.getProcIdentifier(this._databaseIdentifier, (SQLObject)routine));
                }
            }
            EList events = db.getEvents();
            Iterator iter = events.iterator();
            while (iter.hasNext()) {
                Event event = (Event)iter.next();
                procs.add(SQLDevToolsUtil.getProcIdentifier(this._databaseIdentifier, (SQLObject)event));
            }
        }
        return procs.toArray(new ProcIdentifier[procs.size()]);
    }

    public String getProcSource(ProcIdentifier proc) throws SQLException {
        IDBItem item = this.getDBItem(proc);
        if (item instanceof IItemWithCode) {
            return ((IItemWithCode)((Object)item)).getCode();
        }
        throw new SQLException(Messages.AbstractControlConnection_invalid_store_procedure_description);
    }

    public void saveRoutine(ProcIdentifier proc, String code) throws SQLException {
        IDBItem item = this.getDBItem(proc);
        if (!(item instanceof IItemWithCode)) {
            throw new SQLException(Messages.AbstractControlConnection_invalid_store_procedure_description);
        }
        ((IItemWithCode)((Object)item)).save(code);
        this._manager.fireRefreshed(this, proc);
    }

    public IDBItem getDBItem(ProcIdentifier procIdentifier) {
        IDBItem item = (IDBItem)this._procInfoCache.get(procIdentifier);
        if (item == null && (item = this.createDBItem(procIdentifier)) != null) {
            this._procInfoCache.put(procIdentifier, item);
        }
        return item;
    }

    protected ProcIdentifier findSPUDF(String owner, String name) {
        Iterator iter = this._procInfoCache.keySet().iterator();
        while (iter.hasNext()) {
            ProcIdentifier proc = (ProcIdentifier)iter.next();
            if (proc.getType() != 0 && proc.getType() != 1 || !proc.getOwnerName().equals(owner) || !proc.getProcName().equals(name)) continue;
            return proc;
        }
        return null;
    }

    protected Map getDBItemCache() {
        return this._procInfoCache;
    }

    protected IDBItem createDBItem(ProcIdentifier proc) {
        SQLObject obj = ModelUtil.findProceduralObject(proc);
        if (obj != null) {
            return new SQLObjectItem(proc, obj, this);
        }
        return null;
    }

    public void refresh() {
        Iterator iter = this._procInfoCache.values().iterator();
        while (iter.hasNext()) {
            IDBItem item = (IDBItem)iter.next();
            item.dispose();
        }
        this._procInfoCache.clear();
    }

    public void refresh(ProcIdentifier procIdentifier) {
        IDBItem item = (IDBItem)this._procInfoCache.get(procIdentifier);
        if (item != null) {
            item.dispose();
        }
        this._procInfoCache.remove(procIdentifier);
    }

    public String convertToInternalConnId(String externalId, String exteranlName) throws ConnectionException {
        return externalId;
    }

    public Connection createConnection(String[] connId) throws SQLException, CoreException, NoSuchProfileException {
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByProfileName(this.getDatabaseIdentifier().getProfileName());
        ConnectionService conService = f.getConnectionService();
        Connection con = conService.createConnection(this.getDatabaseIdentifier().getProfileName(), this.getDatabaseIdentifier().getDBname());
        if (connId != null && connId.length == 1) {
            connId[0] = "0";
        }
        return con;
    }

    public Connection getReusableConnection() {
        try {
            return ProfileUtil.getReusableConnection(this._databaseIdentifier);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void registerSkip(int connid) {
        Integer id = new Integer(connid);
        this._skipConnections.add(id);
    }

    public void unregisterSkip(int connid) {
        this._skipConnections.remove(new Integer(connid));
    }

    protected boolean shouldSkip(int connid) {
        return this._skipConnections.contains(new Integer(connid));
    }

    protected IDatatype getUserDataType(String typeName) throws SQLException {
        Database db = ProfileUtil.getDatabase(this._databaseIdentifier);
        String user = ProfileUtil.getProfileUserName(this._databaseIdentifier, false);
        DatabaseDefinition dbdef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db);
        Iterator i = db.getSchemas().iterator();
        while (i.hasNext()) {
            Schema schema = (Schema)i.next();
            if (!schema.getName().equals(user)) continue;
            EList tables = schema.getUserDefinedTypes();
            Iterator iter = tables.iterator();
            while (iter.hasNext()) {
                UserDefinedType type = (UserDefinedType)iter.next();
                if (!type.getName().equals(typeName)) continue;
                return ModelUtil.map(dbdef, (DataType)type, user);
            }
        }
        return null;
    }

    public boolean supportsDebugging() {
        return false;
    }

    public IDatatype getTypeByNameStr(String nameStr) throws Exception {
        Database db = ProfileUtil.getDatabase(this._databaseIdentifier);
        String user = ProfileUtil.getProfileUserName(this._databaseIdentifier, false);
        DatabaseDefinition dbdef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db);
        PredefinedDataType pretype = DataTypeHelper.getPredefinedDataTypeForNamedType((String)nameStr);
        if (pretype != null) {
            return ModelUtil.map(dbdef, (DataType)pretype, user);
        }
        return this.getUserDataType(nameStr);
    }

    public class SQLToolsManagedConnectionListener
    implements IManagedConnectionListener {
        public void opened(ConnectEvent event) {
        }

        public void modified(ConnectEvent event) {
        }

        public boolean okToClose(ConnectEvent event) {
            return AbstractControlConnection.this.okToDisconnect();
        }

        public void aboutToClose(ConnectEvent event) {
            AbstractControlConnection.this.aboutToDisconnect();
        }

        public void closed(ConnectEvent event) {
            AbstractControlConnection.this.disconnect(true);
        }
    }
}

