/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core.profile;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinition;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.Messages;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.osgi.util.NLS;

public class ProfileUtil {
    public static final String UID = "org.eclipse.datatools.connectivity.uid";
    public static final String PWD = "org.eclipse.datatools.connectivity.pwd";
    public static final String DRIVERDEFINITIONID = "org.eclipse.datatools.connectivity.driverDefinitionID";
    public static final String DATABASENAME = "org.eclipse.datatools.connectivity.db.databaseName";
    public static final String URL = "org.eclipse.datatools.connectivity.db.URL";
    public static final String DRIVERCLASS = "org.eclipse.datatools.connectivity.db.driverClass";

    public static DatabaseDefinition getDatabaseDefinition(String profileName) {
        DatabaseVendorDefinitionId id = ProfileUtil.getDatabaseVendorDefinitionId(profileName);
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(id.getProductName(), id.getVersion());
    }

    public static IConnectionProfile getProfile(String name) throws NoSuchProfileException {
        IConnectionProfile p = ProfileManager.getInstance().getProfileByName(name);
        if (p == null) {
            throw new NoSuchProfileException(name);
        }
        return p;
    }

    public static DatabaseVendorDefinitionId getDatabaseVendorDefinitionId(String profileName) {
        IConnectionProfile profile = null;
        try {
            profile = ProfileUtil.getProfile(profileName);
        }
        catch (NoSuchProfileException e) {
            EditorCorePlugin.getDefault().log(e);
        }
        if (profile != null) {
            String driverID = profile.getBaseProperties().getProperty(DRIVERDEFINITIONID);
            if (driverID == null) {
                EditorCorePlugin.getDefault().log(NLS.bind((String)Messages.ProfileUtil_error_getdriver, (Object[])new Object[]{profileName}));
            } else {
                DriverInstance driver = DriverManager.getInstance().getDriverInstanceByID(driverID);
                if (driver != null) {
                    String vendor = driver.getProperty("org.eclipse.datatools.connectivity.db.vendor");
                    String version = driver.getProperty("org.eclipse.datatools.connectivity.db.version");
                    return new DatabaseVendorDefinitionId(vendor, version);
                }
            }
        }
        return SQLDevToolsConfiguration.getDefaultInstance().getDatabaseVendorDefinitionId();
    }

    public static String getUserName(IConnectionProfile profile) {
        if (profile == null) {
            return null;
        }
        return profile.getBaseProperties().getProperty(UID);
    }

    public static String getPassword(IConnectionProfile profile) {
        if (profile == null) {
            return null;
        }
        return profile.getBaseProperties().getProperty(PWD);
    }

    public static String getConnectionProfileId(String profileName) throws NoSuchProfileException {
        try {
            IConnectionProfile profile = ProfileUtil.getProfile(profileName);
            return profile.getProviderId();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Database getDatabase(DatabaseIdentifier databaseIdentifier) {
        try {
            IManagedConnection mc;
            IConnection ic;
            Object rawConn;
            IConnectionProfile profile = ProfileUtil.getProfile(databaseIdentifier.getProfileName());
            if (!profile.isConnected()) {
                profile.connect();
            }
            if ((rawConn = (ic = (mc = profile.getManagedConnection(ConnectionInfo.class.getName())).getConnection()).getRawConnection()) instanceof ConnectionInfo) {
                ConnectionInfo ci = (ConnectionInfo)rawConn;
                String expectedDB = databaseIdentifier.getDBname();
                String realDB = ci.getDatabaseName();
                if (expectedDB != null && !expectedDB.equals(realDB)) {
                    EditorCorePlugin.getDefault().log(NLS.bind((String)Messages.ProfileUtil_error_wrong_database_name, (Object[])new Object[]{realDB, databaseIdentifier.getProfileName(), expectedDB}));
                }
                return ci.getSharedDatabase();
            }
        }
        catch (NoSuchProfileException e) {
            EditorCorePlugin.getDefault().log(e);
        }
        return null;
    }

    public static Connection getReusableConnection(DatabaseIdentifier databaseIdentifier) throws SQLException, NoSuchProfileException {
        IConnectionProfile profile = ProfileUtil.getProfile(databaseIdentifier.getProfileName());
        IManagedConnection managedConn = profile.getManagedConnection("java.sql.Connection");
        if (managedConn == null || !managedConn.isConnected()) {
            throw new SQLException(NLS.bind((String)Messages.ProfileUtil_error_getReusableConnection, (Object[])new Object[]{databaseIdentifier.toString()}));
        }
        IConnection iconn = managedConn.getConnection();
        return (Connection)iconn.getRawConnection();
    }

    public static Connection createConnection(String profileName, String dbName) {
        try {
            Connection conn = ProfileUtil.createConnection(ProfileUtil.getProfile(profileName), dbName);
            return conn;
        }
        catch (NoSuchProfileException e) {
            EditorCorePlugin.getDefault().log(e);
            return null;
        }
    }

    public static Connection createConnection(IConnectionProfile profile, String dbName) {
        try {
            Connection conn = null;
            IConnection c = profile.createConnection("java.sql.Connection");
            if (c != null) {
                Object rawConn = c.getRawConnection();
                if (rawConn instanceof Connection) {
                    conn = (Connection)rawConn;
                } else if (rawConn instanceof ConnectionInfoImpl) {
                    conn = ((ConnectionInfoImpl)rawConn).getSharedConnection();
                } else {
                    throw new SQLException(NLS.bind((String)Messages.ProfileUtil_unkown_connection_type, (Object[])new Object[]{c.getClass().getName(), profile.getName()}));
                }
            }
            return conn;
        }
        catch (Exception e) {
            EditorCorePlugin.getDefault().log(NLS.bind((String)Messages.ProfileUtil_error_create_connection, (Object[])new Object[]{profile.getName()}), e);
            return null;
        }
    }

    public static void closeConnection(String profileName, String dbName, Connection conn) {
        if (conn != null) {
            try {
                Connection sharedConn = ProfileUtil.getReusableConnection(new DatabaseIdentifier(profileName, dbName));
                if (conn != sharedConn) {
                    conn.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean isDatabaseProfile(IConnectionProfile connectionProfile) {
        if (connectionProfile != null) {
            connectionProfile.getCategory();
            if (connectionProfile.getCategory().getId().equalsIgnoreCase("org.eclipse.datatools.connectivity.db.category")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isDatabaseProfile(String profileName) {
        try {
            return ProfileUtil.isDatabaseProfile(ProfileUtil.getProfile(profileName));
        }
        catch (NoSuchProfileException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List getDatabaseList(String profileName) {
        ArrayList<Object> list;
        block14: {
            ResultSet rs;
            block13: {
                String dbname;
                list = new ArrayList<Object>();
                Connection conn = null;
                rs = null;
                IConnectionProfile profile = ProfileUtil.getProfile(profileName);
                IManagedConnection managedConn = profile.getManagedConnection("java.sql.Connection");
                if (!managedConn.isConnected()) {
                    profile.connect();
                }
                IConnection iconn = managedConn.getConnection();
                conn = (Connection)iconn.getRawConnection();
                rs = conn.getMetaData().getCatalogs();
                while (rs.next()) {
                    list.add(rs.getObject("TABLE_CAT"));
                }
                if (!list.isEmpty() || (dbname = profile.getBaseProperties().getProperty(DATABASENAME)) == null) break block13;
                list.add(dbname);
            }
            Object var9_9 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                break block14;
            }
            catch (SQLException e2) {
                EditorCorePlugin.getDefault().log(e2);
            }
            break block14;
            {
                catch (Exception e) {
                    EditorCorePlugin.getDefault().log(e);
                    Object var9_10 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        break block14;
                    }
                    catch (SQLException e2) {
                        EditorCorePlugin.getDefault().log(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    EditorCorePlugin.getDefault().log(e2);
                }
                throw throwable;
            }
        }
        return list;
    }

    public static String[] getSupportedDatabaseProfiles() {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfiles();
        ArrayList<String> DBProfileNames = new ArrayList<String>();
        for (int i = 0; i < profiles.length; ++i) {
            SQLDevToolsConfiguration conf;
            if (!ProfileUtil.isDatabaseProfile(profiles[i]) || (conf = SQLToolsFacade.getConfigurationByProfileName(profiles[i].getName())) == null || conf.equals(SQLDevToolsConfiguration.getDefaultInstance())) continue;
            DBProfileNames.add(profiles[i].getName());
        }
        return DBProfileNames.toArray(new String[DBProfileNames.size()]);
    }
}

