/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.internal.core.SQLDevToolsConfigRegistry;
import org.eclipse.datatools.sqltools.internal.core.SQLDevToolsConfigRegistryImpl;

public class SQLToolsFacade {
    private static SQLToolsFacade _instance = new SQLToolsFacade();

    private SQLToolsFacade() {
    }

    public static SQLToolsFacade getInstance() {
        return _instance;
    }

    private static SQLDevToolsConfigRegistry getRegistry() {
        return EditorCorePlugin.getDatabaseFactoryRegistry();
    }

    public static Collection getConfigurations() {
        Collection c = SQLToolsFacade.getRegistry().getConfigurations();
        return c;
    }

    public static Collection getSupportedDBDefinitionNames() {
        Collection c = SQLToolsFacade.getRegistry().getConfigurations();
        ArrayList<String> names = new ArrayList<String>();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            SQLDevToolsConfiguration factory = (SQLDevToolsConfiguration)iter.next();
            String vendor = factory.getDatabaseVendorDefinitionId().getProductName();
            String version = factory.getDatabaseVendorDefinitionId().getVersion();
            names.add(vendor + "_" + version);
        }
        return names;
    }

    public static SQLDevToolsConfiguration getConfigurationByDBDefName(String dbDefName) {
        return SQLToolsFacade.getConfigurationByVendorIdentifier(new DatabaseVendorDefinitionId(dbDefName));
    }

    public static SQLDevToolsConfiguration getConfigurationByVendorIdentifier(DatabaseVendorDefinitionId vendorId) {
        return SQLToolsFacade.getConfiguration(null, vendorId);
    }

    public static SQLDevToolsConfiguration getConfigurationByProfileName(String profileName) {
        return SQLToolsFacade.getConfigurationByVendorIdentifier(ProfileUtil.getDatabaseVendorDefinitionId(profileName));
    }

    public static SQLDevToolsConfiguration getConfiguration(DatabaseIdentifier databaseIdentifier, DatabaseVendorDefinitionId vendorId) {
        SQLDevToolsConfiguration f = null;
        if (databaseIdentifier != null) {
            f = SQLToolsFacade.getConfigurationByProfileName(databaseIdentifier.getProfileName());
        }
        if (f == null && vendorId != null) {
            f = SQLToolsFacade.getRegistry().getConfigurationByVendorIdentifier(vendorId);
        }
        if (f == null) {
            f = SQLToolsFacade.getDefaultConfiguration();
        }
        return f;
    }

    public static SQLDevToolsConfiguration getDefaultConfiguration() {
        return SQLDevToolsConfigRegistryImpl.getDefaultConfiguration();
    }
}

