/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.core.internal;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.datatools.sqltools.core.ConnectionException;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.IControlConnectionManager;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.dbitem.IDBItem;
import org.eclipse.datatools.sqltools.core.dbitem.IItemWithCode;
import org.eclipse.datatools.sqltools.debugger.core.ClientConInfo;
import org.eclipse.datatools.sqltools.debugger.core.IConnectionObserver;
import org.eclipse.datatools.sqltools.debugger.core.IDebuggerControlConnection;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerMessages;
import org.eclipse.datatools.sqltools.internal.core.AbstractControlConnection;
import org.eclipse.datatools.sqltools.internal.core.ControlConnectionManager;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractDebuggerControlConnection
extends AbstractControlConnection
implements IDebuggerControlConnection {
    protected Map _clientConnections = new TreeMap();
    protected Map _debuggerObservers = new TreeMap();

    public AbstractDebuggerControlConnection(ControlConnectionManager manager, DatabaseIdentifier databaseIdentifier) {
        super((IControlConnectionManager)manager, databaseIdentifier);
    }

    public ClientConInfo[] getClientConInfos() {
        return this._clientConnections.values().toArray(new ClientConInfo[this._clientConnections.size()]);
    }

    public ClientConInfo getClientConInfo(int connid) {
        return (ClientConInfo)this._clientConnections.get(new Integer(connid));
    }

    public void registerSkip(int connid) {
        Integer id = new Integer(connid);
        this._skipConnections.add(id);
        if (this._clientConnections.remove(id) != null) {
            this.fireChange();
        }
    }

    public boolean hasClientConnection() {
        return !this._clientConnections.isEmpty();
    }

    public boolean isAttached(int connid) {
        return this._debuggerObservers.containsKey(new Integer(connid));
    }

    public boolean hasDebuggee() {
        return !this._debuggerObservers.isEmpty();
    }

    public void registerDebuggee(int id, IConnectionObserver observer) throws ConnectionException {
        if (this._debuggerObservers.get(new Integer(id)) != null) {
            throw new ConnectionException(-1, NLS.bind((String)DebuggerMessages.AbstractControlConnection_connection_already_being_debugged, (Object[])new Object[]{String.valueOf(id)}));
        }
        this._debuggerObservers.put(new Integer(id), observer);
        this.fireChange();
    }

    public void unregisterDebuggee(int id) {
        if (this._debuggerObservers.remove(new Integer(id)) != null) {
            this.fireChange();
        }
    }

    public void requestDetach(String connId) {
        IConnectionObserver observer = this.getObservable(connId);
        if (observer != null) {
            observer.requestDisconnect(connId);
        }
    }

    protected IConnectionObserver getObservable(String connid) {
        return (IConnectionObserver)this._debuggerObservers.get(new Integer(connid));
    }

    public void fireChange() {
        this._manager.fireRefreshed((IControlConnection)this);
    }

    protected void dispose() {
        ArrayList set = new ArrayList(this._debuggerObservers.values());
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            IConnectionObserver observer = (IConnectionObserver)iter.next();
            observer.observableShutdown();
        }
    }

    public boolean okToDisconnect() {
        return !this.hasDebuggee();
    }

    public boolean disconnect() {
        return this.disconnect(false);
    }

    public boolean disconnect(boolean force) {
        if (this.hasDebuggee() && !force) {
            return false;
        }
        return super.disconnect(force);
    }

    public int[] getValidBreakpointLocations(ProcIdentifier proc, int[] lineNumbers) throws SQLException {
        IDBItem item = this.getDBItem(proc);
        if (item instanceof IItemWithCode) {
            int[] ret = new int[lineNumbers.length];
            IItemWithCode codeItem = (IItemWithCode)item;
            for (int i = 0; i < lineNumbers.length; ++i) {
                ret[i] = codeItem.getValidBreakpointLocation(lineNumbers[i]);
            }
            return ret;
        }
        return lineNumbers;
    }

    public void refreshExternalClients() {
    }

    public String readyToDebug() {
        return null;
    }

    public boolean supportsDebugging() {
        return true;
    }
}

