/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.core;

import org.eclipse.datatools.sqltools.debugger.core.IDebuggerControlConnection;

public class ClientConInfo {
    private String _connId;
    private String _database;
    private String _user;
    private Object _status = null;
    private IDebuggerControlConnection _parentControlConnection;

    public ClientConInfo(IDebuggerControlConnection control, String connid, String db, String user) {
        this._parentControlConnection = control;
        this._connId = connid;
        this._database = db;
        this._user = user;
    }

    public IDebuggerControlConnection getParentControlConnection() {
        return this._parentControlConnection;
    }

    public String getConnId() {
        return this._connId;
    }

    public String getDatabaseName() {
        return this._database;
    }

    public String getUser() {
        return this._user;
    }

    public boolean updateStatus(String db, String user, Object status) {
        boolean changed = false;
        if (!this.equals(db, this._database)) {
            changed = true;
            this._database = db;
        }
        if (!this.equals(user, this._user)) {
            changed = true;
            this._user = user;
        }
        if (this._status == null) {
            this._status = status;
            return changed || status != null;
        }
        if (!this._status.equals(status)) {
            this._status = status;
            changed = true;
        }
        return changed;
    }

    public Object getStatus() {
        return this._status;
    }

    private boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public boolean isAttached() {
        IDebuggerControlConnection parent = this.getParentControlConnection();
        if (parent != null) {
            return parent.isAttached(this.getConnId());
        }
        return false;
    }
}

