/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.db.derby.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionTracker;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.datatools.sqltools.routineeditor.result.CallableSQLResultRunnable;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.LaunchUI;
import org.eclipse.debug.core.ILaunchConfiguration;

public class DerbyCallableRunnable
extends CallableSQLResultRunnable {
    public DerbyCallableRunnable(Connection con, ILaunchConfiguration configuration, boolean closeCon, IConnectionTracker tracker, DatabaseIdentifier databaseIdentifier) throws CoreException, SQLException, NoSuchProfileException {
        super(con, configuration, closeCon, tracker, databaseIdentifier);
        this._sql = this.constructFinalCallSQLString(configuration);
    }

    private String constructFinalCallSQLString(ILaunchConfiguration configuration) throws CoreException, SQLException, NoSuchProfileException {
        if (LaunchHelper.isAdHocSQL((ILaunchConfiguration)configuration)) {
            return LaunchHelper.readLaunchSQLStatement((ILaunchConfiguration)configuration);
        }
        ProcIdentifier proc = LaunchHelper.readProcIdentifier((ILaunchConfiguration)configuration);
        if (proc == null) {
            return "";
        }
        boolean quoted_id = LaunchHelper.readQuotedIDConfig((ILaunchConfiguration)configuration, (ProcIdentifier)proc);
        switch (proc.getType()) {
            case 0: 
            case 1: {
                return this.constructCALLSPString(proc, LaunchHelper.readParameterList((ILaunchConfiguration)configuration), LaunchUI.getAllParameterDescriptors((ProcIdentifier)proc), quoted_id);
            }
        }
        return "";
    }

    private String constructCALLSPString(ProcIdentifier proc, List values, ParameterDescriptor[] pds, boolean quoted_id) {
        StringBuffer buffer = new StringBuffer(20);
        int type = proc == null ? 0 : proc.getType();
        SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByProfileName((String)proc.getDatabaseIdentifier().getProfileName());
        buffer.append(config.getExecutionService().getCallableStatementPrefix(proc.getType()));
        String procName = null;
        if (proc != null) {
            buffer.append(proc.getCallableString(quoted_id));
            procName = proc.getProcName();
        }
        if (pds != null && pds.length > 0) {
            if (type == 1 || type == 0) {
                buffer.append("(");
            }
            int j = 0;
            for (int i = 0; i < pds.length; ++i) {
                String name = pds[i].getName();
                if (name.equals(procName)) continue;
                if (j != 0) {
                    buffer.append(",?");
                } else {
                    buffer.append("?");
                }
                ++j;
            }
            if (type == 1 || type == 0) {
                buffer.append(")");
            }
        } else {
            buffer.append("()");
        }
        return buffer.toString();
    }
}

