/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.datatypes.BinaryStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataLinkDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.data.internal.ui.ExternalTableDataEditorExtension;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.IExternalTableDataEditor;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataEditor;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataEditorActionBarContributor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class DataUIPlugin
extends AbstractUIPlugin {
    private static DataUIPlugin plugin;
    private static final IPath ICONS_PATH;
    public static final String PLUGIN_ID = "org.eclipse.datatools.sqltools.data.ui";
    protected TableDataEditorActionBarContributor tableDataEditorContributor;
    protected List externalTableDataEditorExtensions;
    private static final String UTF_16_BE = "UTF-16BE";
    private static final String UTF_16_LE = "UTF-16LE";
    private static final String UTF_8 = "UTF-8";

    public DataUIPlugin() {
        plugin = this;
        this.listExternalTableDataEditorExtensions();
    }

    public static DataUIPlugin getDefault() {
        return plugin;
    }

    public TableDataEditorActionBarContributor getTableDataEditorContributor() {
        return this.tableDataEditorContributor;
    }

    public void setTableDataEditorContributor(TableDataEditorActionBarContributor tableDataEditorContributor) {
        this.tableDataEditorContributor = tableDataEditorContributor;
    }

    public void writeLog(int severity, int code, String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        this.getLog().log((IStatus)new Status(severity, this.getBundle().getSymbolicName(), code, message, exception));
    }

    public static boolean isGroupIDOK(EObject o) {
        if (o == null) {
            return false;
        }
        ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
        String groupID = containmentService.getGroupId(o);
        return groupID != null && groupID.startsWith("core.");
    }

    public static String getCharacterEncoding() {
        return ResourcesPlugin.getEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String parseEncoding(String filePath) {
        InputStreamReader reader;
        BufferedReader br;
        FileInputStream fileInstream;
        block50: {
            int qouteIndex;
            StringBuffer sub;
            block48: {
                int byteTwo;
                int byteOne;
                block46: {
                    block44: {
                        if (filePath == null || filePath.equals("")) {
                            return null;
                        }
                        fileInstream = null;
                        br = null;
                        reader = null;
                        fileInstream = new FileInputStream(filePath);
                        byteOne = fileInstream.read();
                        byteTwo = fileInstream.read();
                        if (byteOne != 254 || byteTwo != 255) break block44;
                        String string = UTF_16_BE;
                        Object var14_13 = null;
                        try {
                            if (br != null) {
                                br.close();
                            }
                            if (reader != null) {
                                reader.close();
                            }
                            if (fileInstream != null) {
                                fileInstream.close();
                            }
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        return string;
                    }
                    if (byteOne != 255 || byteTwo != 254) break block46;
                    String string = UTF_16_LE;
                    Object var14_14 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                        if (reader != null) {
                            reader.close();
                        }
                        if (fileInstream != null) {
                            fileInstream.close();
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    return string;
                }
                int byteThree = fileInstream.read();
                if (byteOne != 239 || byteTwo != 187 || byteThree != 191) break block48;
                String string = UTF_8;
                Object var14_15 = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                    if (fileInstream != null) {
                        fileInstream.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return string;
            }
            reader = new FileReader(filePath);
            br = new BufferedReader(reader);
            String text = br.readLine();
            int index = text.indexOf("encoding") + 8;
            if (index <= 7 || (sub = new StringBuffer(text.substring(index).trim())).charAt(0) != '=') break block50;
            sub.deleteCharAt(0);
            String st = sub.toString().trim();
            if (st.charAt(0) != '\"' || (qouteIndex = st.indexOf(34, 1)) <= -1) break block50;
            String string = st.substring(1, qouteIndex);
            Object var14_16 = null;
            try {
                if (br != null) {
                    br.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (fileInstream != null) {
                    fileInstream.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            return string;
        }
        String string = null;
        Object var14_17 = null;
        try {
            if (br != null) {
                br.close();
            }
            if (reader != null) {
                reader.close();
            }
            if (fileInstream != null) {
                fileInstream.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return string;
        catch (FileNotFoundException fne) {
            String string2 = null;
            Object var14_18 = null;
            try {
                if (br != null) {
                    br.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (fileInstream != null) {
                    fileInstream.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            return string2;
        }
        catch (IOException ioe) {
            String string3 = null;
            Object var14_19 = null;
            {
                catch (Throwable throwable) {
                    Object var14_20 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                        if (reader != null) {
                            reader.close();
                        }
                        if (fileInstream != null) {
                            fileInstream.close();
                        }
                    }
                    catch (IOException ex) {}
                    throw throwable;
                }
            }
            try {
                if (br != null) {
                    br.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (fileInstream != null) {
                    fileInstream.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            return string3;
        }
    }

    public static String getFileContentWithEncoding(String filePath) throws FileNotFoundException, IOException {
        if (filePath == null) {
            return null;
        }
        String encoding = DataUIPlugin.parseEncoding(filePath);
        File aFile = new File(filePath);
        if (aFile.canRead()) {
            String line;
            FileInputStream fis = new FileInputStream(aFile);
            InputStreamReader instream = null;
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            instream = encoding != null && !encoding.equals("") ? new InputStreamReader((InputStream)fis, encoding) : new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(instream);
            StringBuffer input = new StringBuffer();
            while ((line = br.readLine()) != null) {
                input.append(line).append('\n');
            }
            br.close();
            fis.close();
            return input.toString();
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        try {
            IPath path = ICONS_PATH.append(key + ".gif");
            URL imageURL = FileLocator.find((Bundle)this.getBundle(), (IPath)path, null);
            return ImageDescriptor.createFromURL((URL)imageURL);
        }
        catch (Exception e) {
            this.writeLog(4, 0, e.getMessage(), e);
            return null;
        }
    }

    public ImageDescriptor getPngImageDescriptor(String key) {
        try {
            IPath path = ICONS_PATH.append(key + ".png");
            URL imageURL = FileLocator.find((Bundle)this.getBundle(), (IPath)path, null);
            return ImageDescriptor.createFromURL((URL)imageURL);
        }
        catch (Exception e) {
            this.writeLog(4, 0, e.getMessage(), e);
            return null;
        }
    }

    protected void listExternalTableDataEditorExtensions() {
        this.externalTableDataEditorExtensions = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.datatools.sqltools.data.ui.externalTableDataEditor");
        IExtension[] extensions = extensionPoint.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            for (int j = 0; j < elements.length; ++j) {
                this.externalTableDataEditorExtensions.add(new ExternalTableDataEditorExtension(elements[j]));
            }
        }
    }

    public IExternalTableDataEditor newExternalTableDataCellEditor(TableDataEditor editor, int columnIndex) {
        if (editor == null || editor.getSqlTable() == null || editor.getSqlTable().getColumns() == null) {
            return null;
        }
        if (columnIndex > editor.getSqlTable().getColumns().size()) {
            return null;
        }
        Column sqlCol = (Column)editor.getSqlTable().getColumns().get(columnIndex);
        IExternalTableDataEditor externalEditor = null;
        try {
            Database db = sqlCol.getTable().getSchema().getCatalog() != null ? sqlCol.getTable().getSchema().getCatalog().getDatabase() : sqlCol.getTable().getSchema().getDatabase();
            DataType type = sqlCol.getDataType();
            String vendor = db.getVendor();
            String version = db.getVersion();
            String dataType = sqlCol.getDataType().getName();
            int length = -1;
            boolean lengthSupported = false;
            if (type instanceof DataLinkDataType) {
                lengthSupported = true;
                length = ((DataLinkDataType)type).getLength();
            }
            if (type instanceof BinaryStringDataType) {
                lengthSupported = true;
                length = ((BinaryStringDataType)type).getLength();
            }
            if (type instanceof CharacterStringDataType) {
                lengthSupported = true;
                length = ((CharacterStringDataType)type).getLength();
            }
            ExternalTableDataEditorExtension element = null;
            Iterator it = this.externalTableDataEditorExtensions.iterator();
            while (it.hasNext()) {
                ExternalTableDataEditorExtension curElement = (ExternalTableDataEditorExtension)it.next();
                boolean matches = curElement.matches(vendor, version, dataType, lengthSupported, length) && (element == null || curElement.getScore() > element.getScore());
                if (!matches) continue;
                element = curElement;
            }
            if (element != null) {
                externalEditor = element.createInstance();
            }
        }
        catch (CoreException ex) {
            this.writeLog(4, 0, ex.getMessage(), ex);
        }
        return externalEditor;
    }

    static {
        ICONS_PATH = new Path("icons");
    }
}

