/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.core.tableviewer;

public class DataSerializer {
    protected static final int[] NEEDS_QUOTE = new int[]{-7, 2004, 2005, 1, 12, -1, -2, -3, -4, 91, 92, 93};

    public static String serialize(Object val, int type) {
        if (val == null) {
            return null;
        }
        if (type == -6) {
            return val.toString();
        }
        if (type == 5) {
            return val.toString();
        }
        if (type == 4) {
            return val.toString();
        }
        if (type == -5) {
            return val.toString();
        }
        if (type == 7) {
            return val.toString();
        }
        if (type == 6) {
            return val.toString();
        }
        if (type == 8) {
            return val.toString();
        }
        if (type == 3) {
            return val.toString();
        }
        if (type == 2) {
            return val.toString();
        }
        if (type == -7) {
            return val.toString();
        }
        if (type == 1) {
            return val.toString();
        }
        if (type == 12) {
            return val.toString();
        }
        if (type == -1) {
            return val.toString();
        }
        if (type == -2) {
            return DataSerializer.serializeBytes((byte[])val);
        }
        if (type == -3) {
            return DataSerializer.serializeBytes((byte[])val);
        }
        if (type == -4) {
            return DataSerializer.serializeBytes((byte[])val);
        }
        if (type == 91) {
            return val.toString();
        }
        if (type == 92) {
            return val.toString();
        }
        if (type == 93) {
            return val.toString();
        }
        if (type == 2005) {
            return val.toString();
        }
        if (type == 2004) {
            return DataSerializer.serializeBytes((byte[])val);
        }
        if (type == 2003 || type == 2006 || type == 2002 || type == 2000 || type == 1111) {
            return val.toString();
        }
        return val.toString();
    }

    public static String write(Object val, int type, String stringDelim) {
        String s = DataSerializer.serialize(val, type);
        if (s != null && DataSerializer.needsQuote(type)) {
            s = stringDelim + DataSerializer.doubleStringDelim(s, stringDelim) + stringDelim;
        }
        return s;
    }

    protected static String serializeBytes(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            int n = bytes[i];
            if (n < 0) {
                n += 256;
            }
            sb.append(Integer.toString(n / 16, 16));
            sb.append(Integer.toString(n % 16, 16));
        }
        return "0x" + sb.toString();
    }

    public static boolean needsQuote(int type) {
        for (int i = 0; i < NEEDS_QUOTE.length; ++i) {
            if (NEEDS_QUOTE[i] != type) continue;
            return true;
        }
        return false;
    }

    public static String doubleStringDelim(String s, String delim) {
        if (delim == null || delim.length() == 0) {
            return s;
        }
        int i = s.indexOf(delim);
        if (i != -1) {
            StringBuffer sb = new StringBuffer(s);
            while (i != -1) {
                sb = sb.insert(i, delim);
                int j = i + 2 * delim.length();
                i = sb.toString().indexOf(delim, j);
            }
            return sb.toString();
        }
        return s;
    }
}

