/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.query.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class SQLQuerySourceFormat {
    public static final char STATEMENT_TERMINATOR_DEFAULT = ';';
    public static final char HOSTVARIABLE_PREFIX_DEFAULT = ':';
    public static final char PARAMETER_MARKER_DEFAULT = '?';
    public static final char DELIMITED_IDENTIFIER_QUOTE_DEFAULT = '\"';
    public static final int QUALIFY_IDENTIFIERS_IN_CONTEXT = 0;
    public static final int QUALIFY_IDENTIFIERS_WITH_SCHEMA_NAMES = 1;
    public static final int QUALIFY_IDENTIFIERS_WITH_TABLE_NAMES = 2;
    public static final int QUALIFY_IDENTIFIERS_NEVER = 3;
    public static final SQLQuerySourceFormat SQL_SOURCE_FORMAT_DEFAULT = new SQLQuerySourceFormat(false, ';', ':', '?', '\"', null, 0, true, true, true);
    private boolean thisInstanceIsFinal = false;
    private boolean preserveSourceFormat = false;
    private char statementTerminator = (char)59;
    private char hostVariablePrefix = (char)58;
    private char parameterMarker = (char)63;
    private char delimitedIdentifierQuote = (char)34;
    private String omitSchema = null;
    private int qualifyIdentifiers = 0;
    private boolean preserveComments = true;
    private boolean generateCommentsForStatementOnly = true;
    static /* synthetic */ Class class$0;

    protected SQLQuerySourceFormat(boolean preserveSourceFormat, char statementTerminator, char hostVariablePrefix, char parameterMarker, char delimitedIdentifierQuote, String omitSchema, int qualifyIdentifiers, boolean preserveComments, boolean generateCommentsForStatementOnly) {
        this(preserveSourceFormat, statementTerminator, hostVariablePrefix, parameterMarker, delimitedIdentifierQuote, omitSchema, qualifyIdentifiers, preserveComments, generateCommentsForStatementOnly, false);
    }

    private SQLQuerySourceFormat(boolean preserveSourceFormat, char statementTerminator, char hostVariablePrefix, char parameterMarker, char delimitedIdentifierQuote, String omitSchema, int qualifyIdentifiers, boolean preserveComments, boolean generateCommentsForStatementOnly, boolean finalInstance) {
        this.preserveSourceFormat = preserveSourceFormat;
        this.statementTerminator = statementTerminator;
        this.hostVariablePrefix = hostVariablePrefix;
        this.parameterMarker = parameterMarker;
        this.delimitedIdentifierQuote = delimitedIdentifierQuote;
        this.omitSchema = omitSchema;
        this.qualifyIdentifiers = qualifyIdentifiers;
        this.preserveComments = preserveComments;
        this.generateCommentsForStatementOnly = generateCommentsForStatementOnly;
        this.thisInstanceIsFinal = finalInstance;
    }

    private SQLQuerySourceFormat() {
    }

    public static SQLQuerySourceFormat copyDefaultFormat() {
        return SQLQuerySourceFormat.copySourceFormat(SQL_SOURCE_FORMAT_DEFAULT);
    }

    public static SQLQuerySourceFormat copySourceFormat(SQLQuerySourceFormat sourceFormat) {
        SQLQuerySourceFormat copy = new SQLQuerySourceFormat();
        SQLQuerySourceFormat.copyFields(sourceFormat, copy);
        return copy;
    }

    public static void copyFields(SQLQuerySourceFormat donor, SQLQuerySourceFormat recipient) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceFormat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!Modifier.isFinal(field.getModifiers()) && !field.getName().equals("thisInstanceIsFinal")) {
                try {
                    field.set(recipient, field.get(donor));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        recipient.thisInstanceIsFinal = false;
    }

    public void copyFields(SQLQuerySourceFormat sourceFormat) {
        SQLQuerySourceFormat.copyFields(sourceFormat, this);
    }

    private void checkThisForFinalInstance() throws UnsupportedOperationException {
        if (this.thisInstanceIsFinal) {
            throw new UnsupportedOperationException("This " + this.getClass().getName() + " is final! Property modifications illegal." + " Use " + this.getClass().getName() + "#copyDefaultFormat() to get a copy of this instance.");
        }
    }

    public char getDelimitedIdentifierQuote() {
        return this.delimitedIdentifierQuote;
    }

    public void setDelimitedIdentifierQuote(char delimitedIdentifierQuote) {
        this.checkThisForFinalInstance();
        this.delimitedIdentifierQuote = delimitedIdentifierQuote;
    }

    public char getHostVariablePrefix() {
        return this.hostVariablePrefix;
    }

    public void setHostVariablePrefix(char hostVariablePrefix) {
        this.checkThisForFinalInstance();
        this.hostVariablePrefix = hostVariablePrefix;
    }

    public char getParameterMarker() {
        return this.parameterMarker;
    }

    public void setParameterMarker(char parameterMarker) {
        this.parameterMarker = parameterMarker;
    }

    public String getOmitSchema() {
        return this.omitSchema;
    }

    public void setOmitSchema(String omitSchema) {
        this.checkThisForFinalInstance();
        this.omitSchema = omitSchema;
    }

    public boolean isPreserveSourceFormat() {
        return this.preserveSourceFormat;
    }

    public void setPreserveSourceFormat(boolean preserveSourceFormat) {
        this.checkThisForFinalInstance();
        this.preserveSourceFormat = preserveSourceFormat;
    }

    public char getStatementTerminator() {
        return this.statementTerminator;
    }

    public void setStatementTerminator(char statementTerminator) {
        this.checkThisForFinalInstance();
        this.statementTerminator = statementTerminator;
    }

    public int getQualifyIdentifiers() {
        return this.qualifyIdentifiers;
    }

    public void setQualifyIdentifiers(int qualifyIdentifiers) {
        this.qualifyIdentifiers = qualifyIdentifiers;
    }

    public boolean isPreserveComments() {
        return this.preserveComments;
    }

    public void setPreserveComments(boolean preserveComments) {
        this.preserveComments = preserveComments;
    }

    public boolean isGenerateCommentsForStatementOnly() {
        return this.generateCommentsForStatementOnly;
    }

    public void setGenerateCommentsForStatementOnly(boolean generateCommentsForStatementOnly) {
        this.generateCommentsForStatementOnly = generateCommentsForStatementOnly;
    }
}

