/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.query.helper;

import com.ibm.icu.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.datatools.modelbase.sql.query.ColumnName;
import org.eclipse.datatools.modelbase.sql.query.GroupingExpression;
import org.eclipse.datatools.modelbase.sql.query.GroupingSets;
import org.eclipse.datatools.modelbase.sql.query.GroupingSpecification;
import org.eclipse.datatools.modelbase.sql.query.OrderByOrdinal;
import org.eclipse.datatools.modelbase.sql.query.OrderByResultColumn;
import org.eclipse.datatools.modelbase.sql.query.OrderBySpecification;
import org.eclipse.datatools.modelbase.sql.query.OrderByValueExpression;
import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.QueryCombined;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryResultSpecification;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.QueryValues;
import org.eclipse.datatools.modelbase.sql.query.ResultColumn;
import org.eclipse.datatools.modelbase.sql.query.ResultTableAllColumns;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelFactory;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined;
import org.eclipse.datatools.modelbase.sql.query.SuperGroup;
import org.eclipse.datatools.modelbase.sql.query.TableCorrelation;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.TableJoined;
import org.eclipse.datatools.modelbase.sql.query.TableNested;
import org.eclipse.datatools.modelbase.sql.query.TableReference;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearchContent;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNested;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionVariable;
import org.eclipse.datatools.modelbase.sql.query.WithTableReference;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.modelbase.sql.query.helper.JoinHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.query.impl.SQLQueryModelFactoryImpl;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQueryLogger;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceInfo;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class StatementHelper {
    public static final char DELIMITED_IDENTIFIER_QUOTE = '\"';
    public static final int STATEMENT_TYPE_DELETE = 3;
    public static final int STATEMENT_TYPE_FULLSELECT = 4;
    public static final int STATEMENT_TYPE_INSERT = 1;
    public static final int STATEMENT_TYPE_SELECT = 0;
    public static final int STATEMENT_TYPE_UPDATE = 2;
    public static final int STATEMENT_TYPE_WITH = 5;
    private static List templates = new ArrayList();
    Database database;
    Hashtable nameList;
    static /* synthetic */ Class class$org$eclipse$datatools$modelbase$sql$query$util$SQLQuerySourceInfo;

    public StatementHelper() {
    }

    public StatementHelper(Database database) {
        this.nameList = new Hashtable();
        this.database = database;
    }

    public static int compareSQL(String sql1, String sql2) {
        return StatementHelper.compareSQL(sql1, sql2, '\"');
    }

    public static int compareSQL(String sql1, String sql2, char identifierDelimiterQt) {
        sql1 = StatementHelper.stripWhiteSpaceAndComments(sql1, identifierDelimiterQt);
        sql2 = StatementHelper.stripWhiteSpaceAndComments(sql2, identifierDelimiterQt);
        return sql1.compareTo(sql2);
    }

    public static String convertCatalogIdentifierToSQLFormat(String catalogIdentifier, char idDelimiterQuote) {
        String sqlIdentifier = catalogIdentifier;
        if (catalogIdentifier != null) {
            boolean startsWithNonAlpha;
            boolean containsDelimiters = catalogIdentifier.indexOf(idDelimiterQuote) > -1;
            boolean containsSpace = catalogIdentifier.indexOf(32) > -1;
            boolean containsDot = catalogIdentifier.indexOf(46) > -1;
            boolean isLowerOrMixedCase = !catalogIdentifier.toUpperCase().equals(catalogIdentifier);
            boolean bl = startsWithNonAlpha = catalogIdentifier.length() > 0 && !catalogIdentifier.substring(0, 1).matches("\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}");
            if (containsDelimiters || containsSpace || containsDot || startsWithNonAlpha || isLowerOrMixedCase) {
                String delimiter = String.valueOf(idDelimiterQuote);
                if (containsDelimiters) {
                    StringBuffer sqlIdentSB = new StringBuffer(sqlIdentifier);
                    for (int i = 0; i < sqlIdentSB.length(); ++i) {
                        if (sqlIdentSB.charAt(i) != idDelimiterQuote) continue;
                        sqlIdentSB.insert(i, idDelimiterQuote);
                        ++i;
                    }
                    sqlIdentifier = sqlIdentSB.toString();
                }
                sqlIdentifier = delimiter + sqlIdentifier + delimiter;
            }
        }
        return sqlIdentifier;
    }

    public static String convertSQLIdentifierToCatalogFormat(String sqlIdentifier, char idDelimiterQuote) {
        String catalogIdentifier = sqlIdentifier;
        if (sqlIdentifier != null) {
            boolean containsQuotedDelimiters;
            String delimiter = String.valueOf(idDelimiterQuote);
            boolean isDelimited = sqlIdentifier.startsWith(delimiter) && sqlIdentifier.endsWith(delimiter);
            boolean bl = containsQuotedDelimiters = sqlIdentifier.indexOf(delimiter + delimiter) > -1;
            if (isDelimited) {
                catalogIdentifier = sqlIdentifier.substring(1, sqlIdentifier.length() - 1);
                if (containsQuotedDelimiters) {
                    catalogIdentifier = catalogIdentifier.replaceAll(delimiter + delimiter, delimiter);
                }
            } else {
                catalogIdentifier = sqlIdentifier.toUpperCase();
            }
        }
        return catalogIdentifier;
    }

    private static void copyAllDirectNonNullReferences(EObject donor, EObject recipient) {
        if (donor != null && recipient != null && donor != recipient) {
            Iterator refIt = donor.eClass().getEAllReferences().iterator();
            while (refIt.hasNext()) {
                EReference ref = (EReference)refIt.next();
                boolean isRefCopyable = recipient.eClass().getEAllReferences().contains((Object)ref) && ref.isChangeable();
                if (!isRefCopyable) continue;
                if (ref.isMany()) {
                    EList donorRefList = (EList)donor.eGet((EStructuralFeature)ref);
                    if (donorRefList.isEmpty()) continue;
                    EList recipientRefList = (EList)recipient.eGet((EStructuralFeature)ref);
                    recipientRefList.addAll((Collection)donorRefList);
                    continue;
                }
                EObject donorReference = (EObject)donor.eGet((EStructuralFeature)ref);
                if (donorReference == null) continue;
                recipient.eSet((EStructuralFeature)ref, (Object)donorReference);
            }
        }
    }

    public static ValueExpressionColumn createColumnExpression(String name) {
        ValueExpressionColumn colExpr = SQLQueryModelFactory.eINSTANCE.createValueExpressionColumn();
        colExpr.setName(name);
        return colExpr;
    }

    public static ColumnName createColumnName(String name) {
        SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
        ColumnName newCN = factory.createColumnName();
        newCN.setName(name);
        return newCN;
    }

    public static QueryDeleteStatement createDeleteStatement(String name) {
        SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
        QueryDeleteStatement sqlDeleteStatement = factory.createQueryDeleteStatement();
        sqlDeleteStatement.setName(name);
        return sqlDeleteStatement;
    }

    public static QueryInsertStatement createInsertStatement(String name) {
        SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
        QueryInsertStatement sqlInsertStatement = factory.createQueryInsertStatement();
        sqlInsertStatement.setName(name);
        return sqlInsertStatement;
    }

    public static QueryCombined createQueryCombined() {
        SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
        QueryCombined queryCombined = factory.createQueryCombined();
        return queryCombined;
    }

    public static QuerySelectStatement createQueryCombinedStatement(String name) {
        SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
        QuerySelectStatement sqlSelectStatement = factory.createQuerySelectStatement();
        sqlSelectStatement.setName(name);
        QueryExpressionRoot qroot = StatementHelper.createQueryExpressionRoot(sqlSelectStatement);
        QueryCombined queryCombined = factory.createQueryCombined();
        queryCombined.setLeftQuery(StatementHelper.createQuerySelect());
        queryCombined.setRightQuery(StatementHelper.createQuerySelect());
        sqlSelectStatement.getQueryExpr().setQuery(queryCombined);
        return sqlSelectStatement;
    }

    public static QueryExpressionRoot createQueryExpressionRoot() {
        SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
        QueryExpressionRoot expRoot = factory.createQueryExpressionRoot();
        return expRoot;
    }

    public static QueryExpressionRoot createQueryExpressionRoot(QuerySelectStatement aParent) {
        if (aParent != null) {
            QueryExpressionRoot expRoot = StatementHelper.createQueryExpressionRoot();
            aParent.setQueryExpr(expRoot);
            return expRoot;
        }
        return null;
    }

    public static QuerySelect createQuerySelect() {
        SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
        QuerySelect select = factory.createQuerySelect();
        return select;
    }

    public static QuerySelect createQuerySelect(QueryExpressionRoot anExpRoot) {
        if (anExpRoot != null) {
            QuerySelect select = StatementHelper.createQuerySelect();
            anExpRoot.setQuery(select);
            return select;
        }
        return null;
    }

    public static QuerySelect createQuerySelect(QuerySelectStatement aStatement) {
        if (aStatement == null) {
            return null;
        }
        if (aStatement.getQueryExpr() == null) {
            return null;
        }
        QuerySelect select = StatementHelper.createQuerySelect();
        aStatement.getQueryExpr().setQuery(select);
        return select;
    }

    public static QuerySelectStatement createQuerySelectStatement(String aName) {
        SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
        QuerySelectStatement sqlSelectStatement = factory.createQuerySelectStatement();
        sqlSelectStatement.setName(aName);
        return sqlSelectStatement;
    }

    public static QueryStatement createQueryStatement(int stmtType, String stmtName) {
        QueryStatement stmt = null;
        switch (stmtType) {
            case 0: {
                stmt = StatementHelper.createQuerySelectStatement(stmtName);
                break;
            }
            case 1: {
                stmt = StatementHelper.createInsertStatement(stmtName);
                break;
            }
            case 2: {
                stmt = StatementHelper.createUpdateStatement(stmtName);
                break;
            }
            case 3: {
                stmt = StatementHelper.createDeleteStatement(stmtName);
                break;
            }
            case 4: {
                stmt = StatementHelper.createQueryCombinedStatement(stmtName);
                break;
            }
            case 5: {
                stmt = StatementHelper.createWithStatement(stmtName);
            }
        }
        return stmt;
    }

    public static QueryUpdateStatement createUpdateStatement(String name) {
        SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
        QueryUpdateStatement sqlUpdateStatement = factory.createQueryUpdateStatement();
        sqlUpdateStatement.setName(name);
        return sqlUpdateStatement;
    }

    public static QuerySelectStatement createWithStatement(String name) {
        SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
        QuerySelectStatement sqlSelectStatement = factory.createQuerySelectStatement();
        sqlSelectStatement.setName(name);
        QueryExpressionRoot qroot = StatementHelper.createQueryExpressionRoot(sqlSelectStatement);
        QuerySelect qSelectMain = StatementHelper.createQuerySelect();
        qroot.setQuery(qSelectMain);
        WithTableSpecification withTable = factory.createWithTableSpecification();
        withTable.setName("WithTable1");
        QuerySelect qSelect = StatementHelper.createQuerySelect();
        withTable.setWithTableQueryExpr(qSelect);
        sqlSelectStatement.getQueryExpr().getWithClause().add((Object)withTable);
        return sqlSelectStatement;
    }

    public static WithTableReference createWithTableReferenceForWithTable(WithTableSpecification withTableSpec) {
        WithTableReference withTableRef = null;
        if (withTableSpec != null) {
            withTableRef = SQLQueryModelFactory.eINSTANCE.createWithTableReference();
            withTableRef.setWithTableSpecification(withTableSpec);
            withTableRef.setName(withTableSpec.getName());
            TableHelper.exposeEffectiveResultColumns(withTableRef);
        }
        return withTableRef;
    }

    public static boolean equalSQLIdentifiers(String sqlIdent1, String sqlIdent2, char identDelimiterQuote) {
        boolean equalIdentifiers = false;
        String delimiterQuote = String.valueOf(identDelimiterQuote);
        if (sqlIdent1 != null) {
            equalIdentifiers = sqlIdent1.startsWith(delimiterQuote) && sqlIdent1.endsWith(delimiterQuote) ? sqlIdent1.equals(sqlIdent2) : sqlIdent1.equalsIgnoreCase(sqlIdent2);
        }
        return equalIdentifiers;
    }

    public static ResultColumn findResultColumnForColumnExpression(QuerySelect select, ValueExpressionColumn columnExpr) {
        ResultColumn resultColumnFound = null;
        String colName = columnExpr.getName();
        if (colName != null && select != null) {
            if (columnExpr.getTableExpr() == null) {
                resultColumnFound = StatementHelper.findResultColumnForColumnNameOrAlias(select, colName);
            } else {
                String colTableName = columnExpr.getTableExpr().getName();
                Iterator resultColIt = select.getSelectClause().iterator();
                while (resultColIt.hasNext()) {
                    QueryResultSpecification resultSpec = (QueryResultSpecification)resultColIt.next();
                    if (!(resultSpec instanceof ResultColumn)) continue;
                    ResultColumn resultColumn = (ResultColumn)resultSpec;
                    ValueExpressionColumn resultColExpr = null;
                    TableExpression resultColTableExpr = null;
                    TableCorrelation resultColTableCorr = null;
                    String resultColExprName = null;
                    String resultColExprTableName = null;
                    String resultColExprTableAlias = null;
                    if (!(resultColumn.getValueExpr() instanceof ValueExpressionColumn)) continue;
                    resultColExpr = (ValueExpressionColumn)resultColumn.getValueExpr();
                    resultColExprName = resultColExpr.getName();
                    resultColTableExpr = resultColExpr.getTableExpr();
                    if (resultColTableExpr != null) {
                        resultColExprTableName = resultColTableExpr.getName();
                        resultColTableCorr = resultColTableExpr.getTableCorrelation();
                        if (resultColTableCorr != null) {
                            resultColExprTableAlias = resultColTableCorr.getName();
                        }
                    }
                    if (!colName.equals(resultColExprName) || !colTableName.equals(resultColExprTableName) && !colTableName.equals(resultColExprTableAlias)) continue;
                    resultColumnFound = resultColumn;
                    break;
                }
            }
        }
        return resultColumnFound;
    }

    public static ResultColumn findResultColumnForColumnNameOrAlias(QuerySelect select, String columnNameOrAlias) {
        ResultColumn resultColumnFound = null;
        Iterator resultColIt = select.getSelectClause().iterator();
        while (resultColIt.hasNext()) {
            QueryResultSpecification resultSpec = (QueryResultSpecification)resultColIt.next();
            if (!(resultSpec instanceof ResultColumn)) continue;
            ResultColumn resultColumn = (ResultColumn)resultSpec;
            String resultColumnAlias = null;
            String resultColumnName = null;
            if (resultColumn.getName() != null) {
                resultColumnAlias = resultColumn.getName();
                if (!resultColumnAlias.equals(columnNameOrAlias)) continue;
                resultColumnFound = resultColumn;
                break;
            }
            if (!(resultColumn.getValueExpr() instanceof ValueExpressionColumn)) continue;
            ValueExpressionColumn resultColExpr = (ValueExpressionColumn)resultColumn.getValueExpr();
            resultColumnName = resultColExpr.getName();
            if (resultColExpr.getTableExpr() != null && StatementHelper.isColumnNameAmbiguous(resultColExpr) || !resultColumnName.equals(columnNameOrAlias)) continue;
            resultColumnFound = resultColumn;
            break;
        }
        return resultColumnFound;
    }

    private static Set getAllDirectReferences(EObject eObject) {
        return StatementHelper.getDirectReferences(eObject, null);
    }

    public static List getAllVariablesInQueryStatement(QueryStatement queryStmt) {
        Class typeFilter = ValueExpressionVariable.class;
        Set hostVariableSet = StatementHelper.getReferencesRecursively((EObject)queryStmt, typeFilter);
        ArrayList sortedVariables = new ArrayList(hostVariableSet);
        Comparator sqlSrcOccurenceComp = new Comparator(){

            public int compare(Object o1, Object o2) {
                int result = 0;
                ValueExpressionVariable h1 = (ValueExpressionVariable)o1;
                ValueExpressionVariable h2 = (ValueExpressionVariable)o2;
                SQLQuerySourceInfo h1si = h1.getSourceInfo();
                SQLQuerySourceInfo h2si = h2.getSourceInfo();
                if (h1si != null && h2si != null) {
                    int h1Loc = h1si.getSpanStartOffset();
                    int h2Loc = h2si.getSpanStartOffset();
                    result = h1Loc - h2Loc;
                } else {
                    StatementHelper.logError((class$org$eclipse$datatools$modelbase$sql$query$helper$StatementHelper == null ? (class$org$eclipse$datatools$modelbase$sql$query$helper$StatementHelper = StatementHelper.class$("org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper")) : class$org$eclipse$datatools$modelbase$sql$query$helper$StatementHelper).getName() + "could not compare the location of host variables or parameter markers as no " + (class$org$eclipse$datatools$modelbase$sql$query$util$SQLQuerySourceInfo == null ? (class$org$eclipse$datatools$modelbase$sql$query$util$SQLQuerySourceInfo = StatementHelper.class$("org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceInfo")) : class$org$eclipse$datatools$modelbase$sql$query$util$SQLQuerySourceInfo).getName() + " was associated with them. For host variables or parameter markers: " + h1 + " and " + h2);
                }
                return result;
            }
        };
        Collections.sort(sortedVariables, sqlSrcOccurenceComp);
        return sortedVariables;
    }

    public static Database getDatabase(QueryStatement stmt) {
        Database db = null;
        TableExpression tableExpr = (TableExpression)StatementHelper.getTablesForStatement(stmt).get(0);
        if (tableExpr != null) {
            Table table = TableHelper.getTableForTableExpression(tableExpr);
            Schema schema = table.getSchema();
            db = schema.getDatabase();
        }
        return db;
    }

    public static TableInDatabase getDerivedDatabaseTable(ValueExpressionColumn columnExpr) {
        TableInDatabase derivedTable = null;
        if (columnExpr.getTableInDatabase() != null) {
            derivedTable = columnExpr.getTableInDatabase();
        } else {
            ValueExpressionColumn exposedColumn = TableHelper.getColumnExpressionForName(columnExpr.getTableExpr(), columnExpr.getName());
            if (exposedColumn != null && exposedColumn.getTableInDatabase() != null) {
                derivedTable = exposedColumn.getTableInDatabase();
            }
        }
        return derivedTable;
    }

    public static List getDerivedDatabaseTables(List columnExprList) {
        HashSet<TableInDatabase> derivedTables = new HashSet<TableInDatabase>();
        Iterator it = columnExprList.iterator();
        while (it.hasNext()) {
            ValueExpressionColumn colExpr = (ValueExpressionColumn)it.next();
            TableInDatabase derivedTable = StatementHelper.getDerivedDatabaseTable(colExpr);
            if (derivedTable == null) continue;
            derivedTables.add(derivedTable);
        }
        return new ArrayList(derivedTables);
    }

    public static Set getDirectReferences(EObject eObject, Class typeFilter) {
        HashSet<EObject> directRefs = new HashSet<EObject>();
        Iterator refIt = eObject.eClass().getEAllReferences().iterator();
        while (refIt.hasNext()) {
            EReference ref = (EReference)refIt.next();
            if (ref.isMany()) {
                EList refList = (EList)eObject.eGet((EStructuralFeature)ref);
                Iterator refListIt = refList.iterator();
                while (refListIt.hasNext()) {
                    EObject reference = (EObject)refListIt.next();
                    if (reference == null || typeFilter != null && !typeFilter.isAssignableFrom(reference.getClass())) continue;
                    directRefs.add(reference);
                }
                continue;
            }
            EObject reference = (EObject)eObject.eGet((EStructuralFeature)ref);
            if (reference == null || typeFilter != null && !typeFilter.isAssignableFrom(reference.getClass())) continue;
            directRefs.add(reference);
        }
        return directRefs;
    }

    public static SQLQueryObject getEContainerRecursively(EObject eObject, Class containerType) {
        SQLQueryObject container = null;
        if (eObject != null && containerType != null) {
            EObject eContainer = eObject.eContainer();
            while (eContainer instanceof SQLQueryObject) {
                if (containerType.isAssignableFrom(eContainer.getClass())) {
                    container = (SQLQueryObject)eContainer;
                    break;
                }
                eContainer = eContainer.eContainer();
            }
        }
        return container;
    }

    private static List getEffectiveResultColumns(QueryExpressionBody queryExpr) {
        List effectiveResultColumnList = null;
        effectiveResultColumnList = queryExpr.getColumnList() != null && !queryExpr.getColumnList().isEmpty() ? queryExpr.getColumnList() : TableHelper.exposeEffectiveResultColumns(queryExpr);
        return effectiveResultColumnList;
    }

    public static List getEffectiveResultColumns(QuerySelectStatement selectStmt) {
        List resultValueExprList = new ArrayList();
        if (selectStmt != null && selectStmt.getQueryExpr() != null) {
            QueryExpressionBody queryExpr = selectStmt.getQueryExpr().getQuery();
            resultValueExprList = StatementHelper.getEffectiveResultColumns(queryExpr);
        }
        return resultValueExprList;
    }

    private static Set getEObjectReferencesRecursively(EObject eObject, EObject referencedBy, HashSet references, HashSet visited, Class typeFilter, Class[] referencePathFilter) {
        if (references == null) {
            references = new HashSet<EObject>();
        }
        if (eObject == null) {
            return references;
        }
        if (visited == null) {
            visited = new HashSet<EObject>();
        }
        if (referencePathFilter == null || referencePathFilter.length == 0) {
            referencePathFilter = new Class[]{SQLQueryObject.class};
        }
        if (visited.contains(eObject)) {
            return references;
        }
        if (StatementHelper.isSubtypeOf(eObject, typeFilter)) {
            references.add(eObject);
        }
        visited.add(eObject);
        Iterator itCon = eObject.eClass().getEAllReferences().iterator();
        while (itCon.hasNext()) {
            EReference ref = (EReference)itCon.next();
            if (ref.isMany()) {
                EList list = (EList)eObject.eGet((EStructuralFeature)ref);
                Iterator itChild = list.iterator();
                while (itChild.hasNext()) {
                    EObject child = (EObject)itChild.next();
                    if (child == null || child == referencedBy || !StatementHelper.isSubtypeOf(child, referencePathFilter) && !StatementHelper.isSubtypeOf(child, typeFilter)) continue;
                    StatementHelper.getEObjectReferencesRecursively(child, eObject, references, visited, typeFilter, referencePathFilter);
                }
                continue;
            }
            EObject child = (EObject)eObject.eGet((EStructuralFeature)ref);
            if (child == null || child == referencedBy || !StatementHelper.isSubtypeOf(child, referencePathFilter) && !StatementHelper.isSubtypeOf(child, typeFilter)) continue;
            StatementHelper.getEObjectReferencesRecursively(child, eObject, references, visited, typeFilter, referencePathFilter);
        }
        return references;
    }

    public static QuerySearchCondition getHavingCondition(QueryStatement stmt) {
        QuerySelectStatement selStmt;
        QueryExpressionRoot qRoot;
        QuerySearchCondition havingCon = null;
        if (stmt instanceof QuerySelectStatement && (qRoot = (selStmt = (QuerySelectStatement)stmt).getQueryExpr()) != null && qRoot.getQuery() instanceof QuerySelect) {
            QuerySelect qSelect = (QuerySelect)qRoot.getQuery();
            havingCon = qSelect.getHavingClause();
        }
        return havingCon;
    }

    public static QuerySearchCondition getHavingCondition(SQLQueryObject stmt) {
        QuerySelect qSelect;
        QuerySearchCondition havingCon = null;
        if (stmt instanceof QueryStatement) {
            havingCon = StatementHelper.getHavingCondition((QueryStatement)stmt);
        } else if (stmt instanceof QuerySelect && (qSelect = (QuerySelect)stmt) != null) {
            havingCon = qSelect.getHavingClause();
        }
        return havingCon;
    }

    public static Predicate getPredicateOfVariable(ValueExpressionVariable variable) {
        Set predicateSet = StatementHelper.getReferencesViaSpecificReferencePaths((EObject)variable, Predicate.class, new Class[]{QueryValueExpression.class});
        Predicate pred1 = null;
        if (predicateSet != null && predicateSet.iterator().hasNext()) {
            pred1 = (Predicate)predicateSet.iterator().next();
        }
        return pred1;
    }

    private static QueryExpressionRoot getQueryExpressionRootForTableReference(TableExpression tableRef) {
        QueryExpressionRoot queryExprRoot = null;
        Set oneQueryExprRootSet = null;
        Class targetType = QueryExpressionRoot.class;
        Class[] referenceToTraverse = new Class[]{TableReference.class};
        oneQueryExprRootSet = StatementHelper.getReferencesViaSpecificReferencePaths((EObject)tableRef, targetType, referenceToTraverse);
        if (!oneQueryExprRootSet.isEmpty()) {
            queryExprRoot = (QueryExpressionRoot)oneQueryExprRootSet.iterator().next();
        }
        return queryExprRoot;
    }

    public static QuerySelect getQuerySelectForTableReference(TableExpression tableExpr) {
        QuerySelect querySelect = null;
        if (tableExpr != null) {
            EObject eContainer = tableExpr.eContainer();
            while (eContainer instanceof SQLQueryObject) {
                if (eContainer instanceof QuerySelect) {
                    querySelect = (QuerySelect)eContainer;
                    break;
                }
                eContainer = eContainer.eContainer();
            }
        }
        return querySelect;
    }

    public static QueryStatement getQueryStatementForTableReference(TableReference tableRef) {
        QueryStatement queryStmt = null;
        Set oneQueryStmtSet = StatementHelper.getReferencesRecursively((EObject)tableRef, QueryStatement.class);
        if (oneQueryStmtSet != null && !oneQueryStmtSet.isEmpty()) {
            queryStmt = (QueryStatement)oneQueryStmtSet.iterator().next();
        }
        return queryStmt;
    }

    public static Set getReferencesRecursively(EObject eObject, Class typeFilter) {
        return StatementHelper.getEObjectReferencesRecursively(eObject, null, null, null, typeFilter, null);
    }

    public static Set getReferencesViaSpecificReferencePaths(EObject eObject, Class typeFilter, Class[] referencePathTypes) {
        return StatementHelper.getEObjectReferencesRecursively(eObject, null, null, null, typeFilter, referencePathTypes);
    }

    public static List getResultTableAllColumnsInQueryResultSpecificationList(List queryResultSpecList) {
        ArrayList<ResultTableAllColumns> resultTables = new ArrayList<ResultTableAllColumns>();
        Iterator resultIt = queryResultSpecList.iterator();
        while (resultIt.hasNext()) {
            QueryResultSpecification resultSpec = (QueryResultSpecification)resultIt.next();
            if (!(resultSpec instanceof ResultTableAllColumns)) continue;
            ResultTableAllColumns resultTable = (ResultTableAllColumns)resultSpec;
            resultTables.add(resultTable);
        }
        return resultTables;
    }

    public static QuerySearchCondition getSearchCondition(QueryStatement stmt) {
        QuerySelectStatement selStmt;
        QueryExpressionRoot qRoot;
        QuerySearchCondition searchCon = null;
        if (stmt instanceof QueryUpdateStatement) {
            QueryUpdateStatement updStmt = (QueryUpdateStatement)stmt;
            searchCon = updStmt.getWhereClause();
        } else if (stmt instanceof QueryDeleteStatement) {
            QueryDeleteStatement delStmt = (QueryDeleteStatement)stmt;
            searchCon = delStmt.getWhereClause();
        } else if (stmt instanceof QuerySelectStatement && (qRoot = (selStmt = (QuerySelectStatement)stmt).getQueryExpr()) != null && qRoot.getQuery() instanceof QuerySelect) {
            QuerySelect qSelect = (QuerySelect)qRoot.getQuery();
            searchCon = qSelect.getWhereClause();
        }
        return searchCon;
    }

    public static QuerySearchCondition getSearchCondition(SQLQueryObject stmt) {
        QuerySelect qSelect;
        QuerySearchCondition searchCon = null;
        if (stmt instanceof QueryStatement) {
            searchCon = StatementHelper.getSearchCondition((QueryStatement)stmt);
        } else if (stmt instanceof QuerySelect && (qSelect = (QuerySelect)stmt) != null) {
            searchCon = qSelect.getWhereClause();
        }
        return searchCon;
    }

    public static String getSQLForExecution(SQLQueryObject queryObject) {
        SQLQuerySourceInfo sourceInfo = queryObject.getSourceInfo();
        SQLQuerySourceFormat sourceFormat = sourceInfo.getSqlFormat();
        boolean preserveComments = sourceFormat.isPreserveComments();
        String omitSchema = sourceFormat.getOmitSchema();
        sourceFormat.setPreserveComments(false);
        sourceFormat.setOmitSchema(null);
        String sql = queryObject.getSQL();
        sourceFormat.setPreserveComments(preserveComments);
        sourceFormat.setOmitSchema(omitSchema);
        return sql;
    }

    public static String getSQLQualified(SQLQueryObject queryObject, int qualificationSpec) {
        String sql = null;
        SQLQuerySourceInfo srcInfo = queryObject.getSourceInfo();
        SQLQuerySourceFormat sourceFormat = srcInfo.getSqlFormat();
        int origQualifySpec = sourceFormat.getQualifyIdentifiers();
        sourceFormat.setQualifyIdentifiers(qualificationSpec);
        sql = queryObject.getSQL();
        sourceFormat.setQualifyIdentifiers(origQualifySpec);
        return sql;
    }

    public static String getSQLSchemaQualified(SQLQueryObject queryObject) {
        return StatementHelper.getSQLQualified(queryObject, 1);
    }

    public static String getSQLSourceUnformatted(SQLQueryObject queryObject) {
        SQLQuerySourceInfo sourceInfo = queryObject.getSourceInfo();
        SQLQuerySourceFormat sourceFormat = sourceInfo.getSqlFormat();
        boolean preserveComments = sourceFormat.isPreserveComments();
        sourceFormat.setPreserveComments(false);
        String toBeTrimmed = queryObject.getSQL();
        toBeTrimmed = StatementHelper.stripWhiteSpace(toBeTrimmed, '\"');
        sourceFormat.setPreserveComments(preserveComments);
        return toBeTrimmed;
    }

    public static String getSQLSourceUnformatted(String queryStmt) {
        String toBeTrimmed = queryStmt;
        StringBuffer trimmed = new StringBuffer();
        char SPACE = ' ';
        char NEW_LINE = '\n';
        char lastChar = SPACE;
        for (int i = 0; i < toBeTrimmed.length(); ++i) {
            char currentChar = toBeTrimmed.charAt(i);
            if (currentChar == NEW_LINE) {
                if (lastChar == SPACE) continue;
                trimmed.append(SPACE);
                lastChar = SPACE;
                continue;
            }
            if (currentChar == SPACE && lastChar == SPACE) continue;
            trimmed.append(currentChar);
            lastChar = currentChar;
        }
        return trimmed.toString();
    }

    public static String getSQLTableQualified(SQLQueryObject queryObject) {
        return StatementHelper.getSQLQualified(queryObject, 2);
    }

    public static String getSQLUnqualified(SQLQueryObject queryObject) {
        return StatementHelper.getSQLQualified(queryObject, 3);
    }

    public static String getSQLWithComments(SQLQueryObject queryObject) {
        SQLQuerySourceInfo sourceInfo = queryObject.getSourceInfo();
        SQLQuerySourceFormat sourceFormat = sourceInfo.getSqlFormat();
        boolean preserveComments = sourceFormat.isPreserveComments();
        boolean generateComments = sourceFormat.isGenerateCommentsForStatementOnly();
        sourceFormat.setPreserveComments(true);
        sourceFormat.setGenerateCommentsForStatementOnly(false);
        String sql = queryObject.getSQL();
        sourceFormat.setPreserveComments(preserveComments);
        sourceFormat.setGenerateCommentsForStatementOnly(generateComments);
        return sql;
    }

    public static String getSQLWithoutComments(SQLQueryObject queryObject) {
        SQLQuerySourceInfo sourceInfo = queryObject.getSourceInfo();
        SQLQuerySourceFormat sourceFormat = sourceInfo.getSqlFormat();
        boolean preserveComments = sourceFormat.isPreserveComments();
        sourceFormat.setPreserveComments(false);
        String sql = queryObject.getSQL();
        sourceFormat.setPreserveComments(preserveComments);
        return sql;
    }

    public static int getStatementType(QueryStatement statement) {
        int type = -1;
        if (statement instanceof QuerySelectStatement) {
            type = 0;
            QueryExpressionRoot root = ((QuerySelectStatement)statement).getQueryExpr();
            if (root != null) {
                EList withList;
                QueryExpressionBody qBody = root.getQuery();
                if (qBody instanceof QueryCombined) {
                    type = 4;
                }
                if (!(withList = root.getWithClause()).isEmpty()) {
                    type = 5;
                }
            }
        } else if (statement instanceof QueryInsertStatement) {
            type = 1;
        } else if (statement instanceof QueryUpdateStatement) {
            type = 2;
        } else if (statement instanceof QueryDeleteStatement) {
            type = 3;
        }
        return type;
    }

    public static TableExpression getTableExpressionForTable(Table table, QuerySelect qSelect) {
        TableExpression tableExpr = null;
        if (qSelect != null) {
            List tableExprList = StatementHelper.getTableExpressionsInQuerySelect(qSelect);
            String name = table.getName();
            tableExpr = TableHelper.getTableExpressionFromTableExprList(name, tableExprList);
        }
        return tableExpr;
    }

    public static TableExpression getTableExpressionForTable(Table table, QuerySelectStatement selectStmt) {
        QueryExpressionRoot root;
        TableExpression tableExpr = null;
        if (selectStmt != null && (root = selectStmt.getQueryExpr()) != null) {
            QueryExpressionBody query = root.getQuery();
            List tableExprList = StatementHelper.getTableExpressionsInQueryExpressionBody(query);
            String name = table.getName();
            tableExpr = TableHelper.getTableExpressionFromTableExprList(name, tableExprList);
        }
        return tableExpr;
    }

    public static List getTableExpressionsInQueryExpressionBody(QueryExpressionBody query) {
        ArrayList tableExprList = new ArrayList();
        if (query != null) {
            if (query instanceof QuerySelect) {
                tableExprList.addAll(StatementHelper.getTableExpressionsInQuerySelect((QuerySelect)query));
            }
            if (query instanceof QueryCombined) {
                QueryCombined combined = (QueryCombined)query;
                tableExprList.addAll(StatementHelper.getTableExpressionsInQueryExpressionBody(combined.getLeftQuery()));
                tableExprList.addAll(StatementHelper.getTableExpressionsInQueryExpressionBody(combined.getRightQuery()));
            }
        }
        return tableExprList;
    }

    public static List getTableExpressionsInQuerySelect(QuerySelect querySelect) {
        ArrayList<TableReference> tableExprList = new ArrayList<TableReference>();
        if (querySelect != null) {
            EList fromClause = querySelect.getFromClause();
            Iterator fromClauseItr = fromClause.iterator();
            while (fromClauseItr.hasNext()) {
                TableReference tableRef = (TableReference)fromClauseItr.next();
                if (tableRef instanceof TableExpression) {
                    tableExprList.add(tableRef);
                    continue;
                }
                if (tableRef instanceof TableNested) {
                    tableExprList.addAll(JoinHelper.getTablesInNestedTable((TableNested)tableRef));
                    continue;
                }
                if (!(tableRef instanceof TableJoined)) continue;
                tableExprList.addAll(JoinHelper.getTablesInJoin((TableJoined)tableRef));
            }
        }
        return tableExprList;
    }

    public static List getTableExpressionsVisibleInQuerySelect(QuerySelect querySelect) {
        ArrayList tableExprList = new ArrayList();
        if (querySelect != null) {
            EList fromClause = querySelect.getFromClause();
            tableExprList.addAll(TableHelper.getTableExpressionsInTableReferenceList((List)fromClause));
            if (!StatementHelper.isQuerySelectNestedQuery(querySelect)) {
                EObject eContainer = querySelect.eContainer();
                while (eContainer instanceof SQLQueryObject) {
                    if (eContainer instanceof QuerySelect) {
                        QuerySelect superSelect = (QuerySelect)eContainer;
                        List superTables = StatementHelper.getTableExpressionsVisibleInQuerySelect(superSelect);
                        break;
                    }
                    eContainer = eContainer.eContainer();
                }
            }
        }
        return tableExprList;
    }

    public static List getTablesForStatement(QueryStatement stmt) {
        QueryExpressionBody query;
        QuerySelectStatement selectStmt;
        QueryExpressionRoot queryExpr;
        ArrayList<TableInDatabase> tableList = new ArrayList<TableInDatabase>();
        if (stmt == null) {
            return tableList;
        }
        if (stmt instanceof QueryInsertStatement) {
            QueryInsertStatement insertStmt = (QueryInsertStatement)stmt;
            TableInDatabase tableExpr = insertStmt.getTargetTable();
            if (tableExpr != null) {
                tableList.add(tableExpr);
            }
        } else if (stmt instanceof QueryUpdateStatement) {
            QueryUpdateStatement updateStmt = (QueryUpdateStatement)stmt;
            TableInDatabase tableExpr = updateStmt.getTargetTable();
            if (tableExpr != null) {
                tableList.add(tableExpr);
            }
        } else if (stmt instanceof QueryDeleteStatement) {
            QueryDeleteStatement deleteStmt = (QueryDeleteStatement)stmt;
            TableInDatabase tableExpr = deleteStmt.getTargetTable();
            if (tableExpr != null) {
                tableList.add(tableExpr);
            }
        } else if (stmt instanceof QuerySelectStatement && (queryExpr = (selectStmt = (QuerySelectStatement)stmt).getQueryExpr()) != null && (query = queryExpr.getQuery()) != null) {
            tableList.addAll(StatementHelper.getTableExpressionsInQueryExpressionBody(query));
        }
        return tableList;
    }

    public static List getTablesForStatement(SQLQueryObject stmt) {
        ArrayList tableList = new ArrayList();
        if (stmt == null) {
            return tableList;
        }
        if (stmt instanceof QueryStatement) {
            tableList.addAll(StatementHelper.getTablesForStatement((QueryStatement)stmt));
        } else if (stmt instanceof QuerySelect) {
            tableList.addAll(StatementHelper.getTableExpressionsInQuerySelect((QuerySelect)stmt));
        }
        return tableList;
    }

    public static String getTemplateSQL(int statementType) {
        String templateSQL = null;
        QueryStatement stmt = StatementHelper.createQueryStatement(statementType, "");
        if (stmt != null) {
            templateSQL = stmt.getSQL();
        }
        return templateSQL;
    }

    private static WithTableSpecification getWithTableSpecificationForName(String withTableName, List withTableSpecList) {
        WithTableSpecification withTableFound = null;
        if (withTableName != null && withTableSpecList != null) {
            Iterator withIt = withTableSpecList.iterator();
            while (withIt.hasNext()) {
                WithTableSpecification tempWithTable = (WithTableSpecification)withIt.next();
                String tempWithTableName = tempWithTable.getName();
                if (!withTableName.equals(tempWithTableName)) continue;
                withTableFound = tempWithTable;
                break;
            }
        }
        return withTableFound;
    }

    private static WithTableSpecification getWithTableSpecificationForNameRecursively(String withTableName, QuerySelect querySelect) {
        WithTableSpecification withTableFound = null;
        if (querySelect != null) {
            EObject eContainer = querySelect.eContainer();
            while (withTableFound == null && eContainer instanceof SQLQueryObject) {
                if (eContainer instanceof QueryExpressionRoot) {
                    QueryExpressionRoot queryExprRt = (QueryExpressionRoot)eContainer;
                    EList withTableSpecList = queryExprRt.getWithClause();
                    withTableFound = StatementHelper.getWithTableSpecificationForName(withTableName, (List)withTableSpecList);
                } else if (eContainer instanceof QuerySelectStatement) break;
                eContainer = eContainer.eContainer();
            }
        }
        return withTableFound;
    }

    public static boolean isColumnNameAmbiguous(ValueExpressionColumn columnExpr) {
        boolean need2qualify = false;
        if (columnExpr != null && columnExpr.getTableExpr() != null) {
            TableExpression colsTableExpr = columnExpr.getTableExpr();
            String colName = columnExpr.getName();
            QuerySelect queryStmt = (QuerySelect)StatementHelper.getEContainerRecursively((EObject)columnExpr, QuerySelect.class);
            List queryTableRefs = StatementHelper.getTableExpressionsVisibleInQuerySelect(queryStmt);
            if (queryTableRefs != null && queryTableRefs.size() > 1) {
                Iterator tableIt = queryTableRefs.iterator();
                while (tableIt.hasNext()) {
                    TableExpression tableRef = (TableExpression)tableIt.next();
                    if (tableRef == colsTableExpr || tableRef == queryStmt) continue;
                    if (tableRef.getColumnList() != null && TableHelper.getColumnExpressionForName(tableRef, colName) != null) {
                        need2qualify = true;
                        break;
                    }
                    if (tableRef instanceof TableInDatabase && TableHelper.getColumnForName((TableInDatabase)tableRef, colName) != null) {
                        need2qualify = true;
                        break;
                    }
                    if (!TableHelper.isTableReferencedByColumnWithName(tableRef, colName)) continue;
                    need2qualify = true;
                    break;
                }
            }
        }
        return need2qualify;
    }

    public static boolean isOrderByClauseContainsValidOrderBySpecification(List orderByClause) {
        boolean isOrderByClauseValid = false;
        if (orderByClause != null && !orderByClause.isEmpty()) {
            Iterator orderIt = orderByClause.iterator();
            while (orderIt.hasNext()) {
                OrderBySpecification orderBy = (OrderBySpecification)orderIt.next();
                if (!StatementHelper.isOrderBySpecificationValid(orderBy)) continue;
                isOrderByClauseValid = true;
            }
        }
        return isOrderByClauseValid;
    }

    public static boolean isOrderBySpecificationValid(OrderBySpecification orderBySpec) {
        boolean isOrderBySpecValid = false;
        if (orderBySpec != null) {
            if (orderBySpec instanceof OrderByOrdinal) {
                OrderByOrdinal orderOrdinal = (OrderByOrdinal)orderBySpec;
                isOrderBySpecValid = orderOrdinal.getOrdinalValue() > 0;
            } else if (orderBySpec instanceof OrderByResultColumn) {
                OrderByResultColumn orderColumn = (OrderByResultColumn)orderBySpec;
                isOrderBySpecValid = orderColumn.getResultCol() != null && orderColumn.getResultCol().getValueExpr() != null;
            } else if (orderBySpec instanceof OrderByValueExpression) {
                OrderByValueExpression orderExpr = (OrderByValueExpression)orderBySpec;
                isOrderBySpecValid = orderExpr.getValueExpr() != null;
            }
        }
        return isOrderBySpecValid;
    }

    private static boolean isQuerySelectNestedQuery(QuerySelect querySelect) {
        boolean isNestedQuery = false;
        if (querySelect != null) {
            EObject eContainer = querySelect.eContainer();
            while (eContainer instanceof TableReference) {
                if (eContainer instanceof QuerySelect) {
                    isNestedQuery = true;
                    break;
                }
                eContainer = eContainer.eContainer();
            }
        }
        return isNestedQuery;
    }

    private static boolean isSubtypeOf(EObject eObject, Class typeFilter) {
        return typeFilter == null || typeFilter.isAssignableFrom(eObject.getClass());
    }

    private static boolean isSubtypeOf(EObject eObject, Class[] typeFilter) {
        boolean isSubtype = false;
        if (typeFilter == null || typeFilter.length == 0) {
            isSubtype = true;
        } else {
            for (int i = 0; i < typeFilter.length; ++i) {
                if (!typeFilter[i].isAssignableFrom(eObject.getClass())) continue;
                isSubtype |= true;
                break;
            }
        }
        return isSubtype;
    }

    public static boolean isTableNameAmbiguous(TableExpression tableExpr) {
        boolean isAmbiguous = false;
        if (tableExpr.getTableCorrelation() != null) {
            return false;
        }
        QuerySelect select = StatementHelper.getQuerySelectForTableReference(tableExpr);
        if (select != null) {
            List tableExprList = StatementHelper.getTableExpressionsInQuerySelect(select);
            Iterator it = tableExprList.iterator();
            while (it.hasNext()) {
                TableExpression otherTable = (TableExpression)it.next();
                if (otherTable == tableExpr || otherTable.getTableCorrelation() != null || tableExpr.getName() == null || !tableExpr.getName().equals(otherTable.getName())) continue;
                isAmbiguous = true;
                break;
            }
        }
        return isAmbiguous;
    }

    public static boolean isTemplateSQL(String sql) {
        boolean isTemplate = false;
        int compares = -1;
        if (templates.isEmpty()) {
            templates.add(StatementHelper.createQueryStatement(0, "").getSQL());
            templates.add(StatementHelper.createQueryStatement(1, "").getSQL());
            templates.add(StatementHelper.createQueryStatement(2, "").getSQL());
            templates.add(StatementHelper.createQueryStatement(3, "").getSQL());
            templates.add(StatementHelper.createQueryStatement(4, "").getSQL());
            templates.add(StatementHelper.createQueryStatement(5, "").getSQL());
        }
        Iterator itr = templates.iterator();
        while (compares != 0 && itr.hasNext()) {
            String template = (String)itr.next();
            compares = StatementHelper.compareSQL(template, sql);
        }
        if (compares == 0) {
            isTemplate = true;
        }
        return isTemplate;
    }

    public static void logDebug(String debugMsg) {
        SQLQueryLogger.getLogger().writeInfo(debugMsg);
    }

    public static void logError(String errorMsg) {
        SQLQueryLogger.getLogger().writeLog(errorMsg);
    }

    public static boolean omitSchema(TableInDatabase tableInDB) {
        boolean omitSchema = false;
        if (tableInDB.getDatabaseTable() != null) {
            String schemaName;
            Schema schema;
            SQLQuerySourceFormat sourceFormat = null;
            QueryStatement queryStmt = StatementHelper.getQueryStatementForTableReference(tableInDB);
            if (queryStmt != null && queryStmt.getSourceInfo() != null && queryStmt.getSourceInfo().getSqlFormat() != null) {
                sourceFormat = queryStmt.getSourceInfo().getSqlFormat();
            } else if (tableInDB.getSourceInfo() != null && tableInDB.getSourceInfo().getSqlFormat() != null) {
                sourceFormat = tableInDB.getSourceInfo().getSqlFormat();
            }
            String omitSchemaName = null;
            if (sourceFormat != null) {
                omitSchemaName = sourceFormat.getOmitSchema();
            }
            if ((schema = tableInDB.getDatabaseTable().getSchema()) != null && (schemaName = schema.getName()) != null && schemaName.length() > 0 && schemaName.equals(omitSchemaName)) {
                omitSchema = true;
            }
        }
        return omitSchema;
    }

    private static void removeColumnReferences(ValueExpressionColumn colExpr) {
        Set colRefList = StatementHelper.getAllDirectReferences((EObject)colExpr);
        Iterator colRefIt = colRefList.iterator();
        while (colRefIt.hasNext()) {
            EObject reference = (EObject)colRefIt.next();
            if (reference instanceof GroupingSpecification) {
                StatementHelper.removeGroupingSpecification((GroupingSpecification)reference);
                continue;
            }
            if (reference instanceof OrderBySpecification) {
                StatementHelper.removeOrderBySpecification((OrderBySpecification)reference);
                continue;
            }
            if (reference instanceof Predicate) {
                StatementHelper.removePredicate((Predicate)reference);
                continue;
            }
            if (reference instanceof ResultColumn) {
                StatementHelper.removeResultColumn((ResultColumn)reference);
                continue;
            }
            if (!(reference instanceof QueryValueExpression)) continue;
            StatementHelper.removeValueExpression((QueryValueExpression)reference);
        }
    }

    public static String removeCommentsInSQL(String statement, char delimitedIdentifierQt) {
        boolean NO_QUOTE = false;
        boolean SINGLE_QUOTE = true;
        int DOUBLE_QUOTE = 2;
        int INSIDE_COMMENT = 3;
        int lastChar = 32;
        int delimiterState = 0;
        StringBuffer nonCommentStmt = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(statement);
        char c = iter.first();
        while (c != '\uffff') {
            switch (delimiterState) {
                case 3: {
                    if (c != '\r' && c != '\n') break;
                    delimiterState = 0;
                    break;
                }
                case 0: {
                    if (c == '\'') {
                        delimiterState = 1;
                        break;
                    }
                    if (c == delimitedIdentifierQt) {
                        delimiterState = 2;
                        break;
                    }
                    if (c != '-') break;
                    char lookAheadChar = iter.next();
                    if (lookAheadChar == '-') {
                        delimiterState = 3;
                        break;
                    }
                    nonCommentStmt.append(c);
                    lastChar = c;
                    c = lookAheadChar;
                    break;
                }
                case 1: {
                    char lookAheadChar;
                    if (c != '\'' || (lookAheadChar = iter.next()) == '\'') break;
                    delimiterState = 0;
                    nonCommentStmt.append(c);
                    lastChar = c;
                    c = lookAheadChar;
                    break;
                }
                case 2: {
                    char lookAheadChar;
                    if (c != delimitedIdentifierQt || (lookAheadChar = iter.next()) == delimitedIdentifierQt) break;
                    delimiterState = 0;
                    nonCommentStmt.append(c);
                    lastChar = c;
                    c = lookAheadChar;
                }
            }
            if (delimiterState != 3) {
                if ((c == '\n' || c == '\r') && delimiterState == 0) {
                    if (lastChar != 32) {
                        nonCommentStmt.append(' ');
                        lastChar = 32;
                    }
                } else if (c != '\uffff' && (delimiterState != 0 || lastChar != 32 || c != ' ')) {
                    nonCommentStmt.append(c);
                    lastChar = c;
                }
            }
            c = iter.next();
        }
        return nonCommentStmt.toString().trim();
    }

    private static void removeGroupingSpecification(GroupingSpecification groupingSpec) {
        GroupingSpecification groupingSpecToRemove = groupingSpec;
        boolean foundSelect = false;
        QuerySelect qSelect = null;
        for (EObject container = groupingSpec.eContainer(); !foundSelect && container != null; container = container.eContainer()) {
            if (container instanceof QuerySelect) {
                qSelect = (QuerySelect)container;
                foundSelect = true;
                continue;
            }
            if (container instanceof SuperGroup) {
                groupingSpecToRemove = (SuperGroup)container;
                continue;
            }
            if (!(container instanceof GroupingSets)) continue;
            groupingSpecToRemove = (GroupingSets)container;
        }
        if (qSelect != null) {
            qSelect.getGroupByClause().remove((Object)groupingSpecToRemove);
        }
    }

    private static void removeOrderBySpecification(OrderBySpecification sortSpec) {
        QuerySelectStatement stmt = sortSpec.getSelectStatement();
        stmt.getOrderByClause().remove((Object)sortSpec);
    }

    private static void removePredicate(Predicate pred) {
        QuerySelect query;
        QuerySearchCondition searchCon = null;
        EObject parent = null;
        boolean isHaving = false;
        if (pred.getCombinedRight() == null && pred.getCombinedLeft() == null) {
            parent = pred.eContainer();
            if (parent instanceof QuerySelect && (query = (QuerySelect)parent).getHavingClause() == pred) {
                isHaving = true;
            }
        } else {
            if (pred.getCombinedLeft() != null) {
                searchCon = pred.getCombinedLeft();
            } else if (pred.getCombinedRight() != null) {
                searchCon = pred.getCombinedRight();
            } else if (pred.getNest() != null) {
                searchCon = pred.getNest();
            }
            while (searchCon.getCombinedLeft() != null) {
                searchCon = searchCon.getCombinedLeft();
            }
            parent = searchCon.eContainer();
            if (parent instanceof QuerySelect && (query = (QuerySelect)parent).getHavingClause() == searchCon) {
                isHaving = true;
            }
        }
        if (searchCon != null) {
            if (pred.getCombinedRight() != null && pred.getCombinedRight().getCombinedLeft() == null) {
                searchCon = pred.getCombinedRight().getLeftCondition();
                if (searchCon != null) {
                    searchCon.setCombinedLeft(null);
                }
            } else if (pred.getCombinedLeft() != null) {
                if (pred.getCombinedLeft().getCombinedLeft() != null) {
                    pred.getCombinedLeft().getCombinedLeft().setLeftCondition(pred.getCombinedLeft().getRightCondition());
                } else {
                    searchCon = pred.getCombinedLeft().getRightCondition();
                }
            } else if (pred.getCombinedRight() != null && pred.getCombinedRight().getCombinedLeft() != null) {
                SearchConditionCombined currentGroup = pred.getCombinedRight();
                pred.getCombinedRight().setRightCondition(pred.getCombinedRight().getCombinedLeft().getRightCondition());
                currentGroup.setCombinedLeft(currentGroup.getCombinedLeft().getCombinedLeft());
                if (currentGroup.getCombinedLeft() == null) {
                    searchCon = currentGroup;
                }
            }
        }
        if (parent != null) {
            StatementHelper.updateSearchConditionParent(searchCon, parent, isHaving);
        }
    }

    private static void removeResultColumn(ResultColumn resCol) {
        QuerySelect query = resCol.getQuerySelect();
        EList ordByColList = resCol.getOrderByResultCol();
        if (ordByColList != null && !ordByColList.isEmpty()) {
            Iterator orderByColListIter = ordByColList.iterator();
            boolean deleted = false;
            while (orderByColListIter.hasNext() && !deleted) {
                OrderByResultColumn rstCol;
                Object col = orderByColListIter.next();
                if (!(col instanceof OrderByResultColumn) || (rstCol = (OrderByResultColumn)col).getResultCol() != resCol) continue;
                orderByColListIter.remove();
                deleted = true;
            }
        }
        if (query != null) {
            query.getSelectClause().remove((Object)resCol);
        }
    }

    public static void removeTableExpressionFromQueryStatement(TableExpression tableExpr, SQLQueryObject queryObj) {
        QueryStatement stmt;
        Set directlyReferencedObjects = StatementHelper.getAllDirectReferences((EObject)tableExpr);
        Iterator dirRefIter = directlyReferencedObjects.iterator();
        while (dirRefIter.hasNext()) {
            EObject reference = (EObject)dirRefIter.next();
            if (!(reference instanceof ValueExpressionColumn)) continue;
            ValueExpressionColumn valExprCol = (ValueExpressionColumn)reference;
            StatementHelper.removeColumnReferences(valExprCol);
        }
        if (queryObj instanceof QuerySelect) {
            QuerySelect querySelect = (QuerySelect)queryObj;
            EList tableExprList = querySelect.getFromClause();
            if (tableExprList != null && !tableExprList.isEmpty()) {
                JoinHelper.removeJoinsForTable((List)tableExprList, tableExpr);
                tableExprList.remove(tableExpr);
            }
        } else if (queryObj instanceof QuerySelectStatement) {
            QuerySelect querySelect;
            EList tableExprList;
            QueryExpressionBody query;
            stmt = (QuerySelectStatement)queryObj;
            QueryExpressionRoot queryExpr = stmt.getQueryExpr();
            if (queryExpr != null && (query = queryExpr.getQuery()) != null && query instanceof QuerySelect && (tableExprList = (querySelect = (QuerySelect)query).getFromClause()) != null && !tableExprList.isEmpty()) {
                JoinHelper.removeJoinsForTable((List)tableExprList, tableExpr);
                tableExprList.remove(tableExpr);
            }
        } else if (queryObj instanceof QueryInsertStatement) {
            stmt = (QueryInsertStatement)queryObj;
            stmt.getTargetColumnList().clear();
            stmt.getSourceValuesRowList().clear();
            stmt.setTargetTable(null);
        } else if (queryObj instanceof QueryUpdateStatement) {
            stmt = (QueryUpdateStatement)queryObj;
            stmt.setTargetTable(null);
        } else if (queryObj instanceof QueryDeleteStatement) {
            stmt = (QueryDeleteStatement)queryObj;
            stmt.setTargetTable(null);
        }
    }

    public static void removeValueExpression(QueryValueExpression valExpr) {
        EObject container = valExpr.eContainer();
        if (container instanceof ValueExpressionNested) {
            ValueExpressionNested nest = (ValueExpressionNested)container;
            nest.setNestedValueExpr(null);
            StatementHelper.removeValueExpression(nest);
        } else if (container instanceof ValueExpressionCombined) {
            ValueExpressionCombined combined = (ValueExpressionCombined)container;
            combined.setLeftValueExpr(null);
            combined.setRightValueExpr(null);
            StatementHelper.removeValueExpression(combined);
        } else if (container instanceof GroupingExpression) {
            GroupingExpression groupingExpr = (GroupingExpression)container;
            groupingExpr.setValueExpr(null);
            StatementHelper.removeGroupingSpecification(groupingExpr);
        } else if (container instanceof OrderByValueExpression) {
            OrderByValueExpression orderByVal = (OrderByValueExpression)container;
            orderByVal.setValueExpr(null);
            StatementHelper.removeOrderBySpecification(orderByVal);
        } else if (container instanceof Predicate) {
            Predicate pred = (Predicate)container;
            StatementHelper.removePredicate(pred);
        } else if (container instanceof ResultColumn) {
            ResultColumn resultCol = (ResultColumn)container;
            resultCol.setValueExpr(null);
            StatementHelper.removeResultColumn(resultCol);
        }
    }

    public static Set resolveOrderByColumns(QueryExpressionBody queryExpr, List orderByList) {
        HashSet removedColumns = new HashSet();
        if (queryExpr instanceof QuerySelect) {
            QuerySelect select = (QuerySelect)queryExpr;
            removedColumns.addAll(StatementHelper.resolveOrderByColumns(select, orderByList));
        } else if (queryExpr instanceof QueryCombined) {
            QueryCombined combined = (QueryCombined)queryExpr;
            removedColumns.addAll(StatementHelper.resolveOrderByColumns(combined.getLeftQuery(), orderByList));
            removedColumns.addAll(StatementHelper.resolveOrderByColumns(combined.getRightQuery(), orderByList));
        } else if (!(queryExpr instanceof QueryValues)) {
            throw new UnsupportedOperationException("resolveOrderByColumns(QueryExpressionBody, List) not implemented for " + queryExpr.getClass().getName() + " in " + StatementHelper.class.getName());
        }
        return removedColumns;
    }

    public static Set resolveOrderByColumns(QuerySelect select, List orderByList) {
        ArrayList<OrderByResultColumn> newOrderByResultColumnList = new ArrayList<OrderByResultColumn>();
        HashSet<ValueExpressionColumn> removedColumnExprs = new HashSet<ValueExpressionColumn>();
        Iterator orderIt = orderByList.iterator();
        while (orderIt.hasNext()) {
            OrderByValueExpression orderByVE;
            OrderBySpecification orderBy = (OrderBySpecification)orderIt.next();
            if (orderBy instanceof OrderByValueExpression && (orderByVE = (OrderByValueExpression)orderBy).getValueExpr() instanceof ValueExpressionColumn) {
                ValueExpressionColumn columnExpr = (ValueExpressionColumn)orderByVE.getValueExpr();
                ResultColumn resultCol = null;
                resultCol = columnExpr.getTableExpr() == null ? StatementHelper.findResultColumnForColumnNameOrAlias(select, columnExpr.getName()) : StatementHelper.findResultColumnForColumnExpression(select, columnExpr);
                if (resultCol != null) {
                    OrderByResultColumn newOrderByRC = SQLQueryModelFactory.eINSTANCE.createOrderByResultColumn();
                    newOrderByRC.setResultCol(resultCol);
                    newOrderByRC.setOrderingSpecOption(orderByVE.getOrderingSpecOption());
                    newOrderByRC.setNullOrderingOption(orderByVE.getNullOrderingOption());
                    newOrderByResultColumnList.add(newOrderByRC);
                    orderIt.remove();
                    orderByVE.setValueExpr(null);
                    removedColumnExprs.add(columnExpr);
                    TableHelper.removeColumnExpressionFromTableIfNotReferenced(columnExpr);
                }
            }
            if (!(orderBy instanceof OrderByResultColumn)) continue;
            OrderByResultColumn orderByRC = (OrderByResultColumn)orderBy;
        }
        orderByList.addAll(newOrderByResultColumnList);
        return removedColumnExprs;
    }

    public static void resolveQueryResultSpecification(QuerySelect querySelect) {
        EList tableRefList = querySelect.getFromClause();
        EList queryResultSpecList = querySelect.getSelectClause();
        Set columnExprSet = TableHelper.findColumnReferencesInQueryResultSpecificationList((List)queryResultSpecList);
        TableHelper.resolveColumnTableReferences(columnExprSet, (List)tableRefList);
        List tableExprList = TableHelper.getTableExpressionsInTableReferenceList((List)tableRefList);
        List resultTableList = StatementHelper.getResultTableAllColumnsInQueryResultSpecificationList((List)queryResultSpecList);
        TableHelper.resolveResultTableReferences(resultTableList, tableExprList);
    }

    public static void resolveResultTableAllColumns(QuerySelect querySelect) {
        EList tableRefList = querySelect.getFromClause();
        EList queryResultSpecList = querySelect.getSelectClause();
        List tableExprList = TableHelper.getTableExpressionsInTableReferenceList((List)tableRefList);
        List resultTableList = StatementHelper.getResultTableAllColumnsInQueryResultSpecificationList((List)queryResultSpecList);
        TableHelper.resolveResultTableReferences(resultTableList, tableExprList);
    }

    public static WithTableReference resolveWithTableSpecificationReference(TableExpression potentialWithTableRef) {
        WithTableReference withTableRef = null;
        if (potentialWithTableRef != null) {
            String withTableName = potentialWithTableRef.getName();
            WithTableSpecification withTableSpec = null;
            QuerySelect querySelect = StatementHelper.getQuerySelectForTableReference(potentialWithTableRef);
            withTableSpec = StatementHelper.getWithTableSpecificationForNameRecursively(withTableName, querySelect);
            if (withTableSpec != null) {
                withTableRef = StatementHelper.createWithTableReferenceForWithTable(withTableSpec);
                StatementHelper.substituteTableReference(potentialWithTableRef, withTableRef);
            }
        }
        return withTableRef;
    }

    public static void setHavingClauseForStatement(QuerySearchCondition newSearchCon, QueryStatement statement) {
        QueryExpressionRoot qRoot;
        if (statement instanceof QuerySelectStatement && (qRoot = ((QuerySelectStatement)statement).getQueryExpr()) != null && qRoot.getQuery() instanceof QuerySelect) {
            QuerySelect qSelect = (QuerySelect)qRoot.getQuery();
            qSelect.setHavingClause(newSearchCon);
        }
    }

    public static void setHavingClauseForStatement(QuerySearchCondition newSearchCon, SQLQueryObject statement) {
        if (statement instanceof QueryStatement) {
            StatementHelper.setHavingClauseForStatement(newSearchCon, (QueryStatement)statement);
        } else if (statement instanceof QuerySelect) {
            QuerySelect qSelect = (QuerySelect)statement;
            qSelect.setHavingClause(newSearchCon);
        }
    }

    public static void setWhereClauseForStatement(QuerySearchCondition newSearchCon, QueryStatement statement) {
        if (statement instanceof QuerySelectStatement) {
            QueryExpressionRoot qRoot = ((QuerySelectStatement)statement).getQueryExpr();
            if (qRoot != null && qRoot.getQuery() instanceof QuerySelect) {
                QuerySelect qSelect = (QuerySelect)qRoot.getQuery();
                qSelect.setWhereClause(newSearchCon);
            }
        } else if (statement instanceof QueryUpdateStatement) {
            ((QueryUpdateStatement)statement).setWhereClause(newSearchCon);
        } else if (statement instanceof QueryDeleteStatement) {
            ((QueryDeleteStatement)statement).setWhereClause(newSearchCon);
        }
    }

    public static void setWhereClauseForStatement(QuerySearchCondition newSearchCon, SQLQueryObject statement) {
        if (statement instanceof QueryStatement) {
            StatementHelper.setWhereClauseForStatement(newSearchCon, (QueryStatement)statement);
        } else if (statement instanceof QuerySelect) {
            QuerySelect qSelect = (QuerySelect)statement;
            qSelect.setWhereClause(newSearchCon);
        }
    }

    private static String stripWhiteSpace(String sql, char delimitedIdentifierQt) {
        String stmtTerm = ";";
        if (sql != null) {
            sql = StatementHelper.toSQLFormatUpperCase(sql, delimitedIdentifierQt);
            sql = sql.replaceAll("\n", " ");
            sql = sql.replaceAll("\\s*,\\s*", ",");
            sql = sql.replaceAll("\\s*\\(\\s*", "(");
            sql = sql.replaceAll("\\s*\\)\\s*", ")");
            sql = sql.replaceAll("\\s+", " ");
            sql = sql.replaceAll("\\s*=\\s*", "=");
            sql = sql.replaceAll("\\s*-\\s*", "-");
            sql = sql.replaceAll("\\s*\\+\\s*", "+");
            sql = sql.replaceAll("\\s*\\*\\s*", "*");
            sql = sql.replaceAll("\\s*/\\s*", "/");
            sql = sql.replaceAll(stmtTerm, " ");
        }
        return sql.trim();
    }

    private static String stripWhiteSpaceAndComments(String sql, char delimitedIdentifierQt) {
        if (sql != null) {
            sql = StatementHelper.removeCommentsInSQL(sql, delimitedIdentifierQt);
            sql = StatementHelper.toSQLFormatUpperCase(sql, delimitedIdentifierQt);
            sql = StatementHelper.stripWhiteSpace(sql, delimitedIdentifierQt);
        }
        return sql.trim();
    }

    private static void substituteTableReference(TableExpression oldTableRef, TableExpression substitute) {
        if (oldTableRef != null && substitute != null && oldTableRef != substitute) {
            if (oldTableRef.getQuerySelect() != null) {
                EList oldTableSiblings = oldTableRef.getQuerySelect().getFromClause();
                for (int i = 0; i < oldTableSiblings.size(); ++i) {
                    TableReference oldSibling = (TableReference)oldTableSiblings.get(i);
                    if (oldSibling != oldTableRef) continue;
                    oldTableSiblings.set(i, substitute);
                    break;
                }
            }
            StatementHelper.copyAllDirectNonNullReferences((EObject)oldTableRef, (EObject)substitute);
        }
    }

    private static String toSQLFormatUpperCase(String sql, char delimitedIdentifierQt) {
        StringBuffer sqlUC = new StringBuffer();
        char[] sqlChar = sql.toCharArray();
        char delimiterQuote = delimitedIdentifierQt;
        boolean inDelimitedIdentifier = false;
        for (int i = 0; i < sqlChar.length; ++i) {
            char c = sqlChar[i];
            if (c == delimiterQuote) {
                boolean bl = inDelimitedIdentifier = !inDelimitedIdentifier;
            }
            if (!inDelimitedIdentifier) {
                c = Character.toUpperCase(c);
            }
            sqlUC.append(c);
        }
        return sqlUC.toString();
    }

    private static void updateSearchConditionParent(QuerySearchCondition searchCon, Object parent, boolean isHaving) {
        if (parent instanceof QueryDeleteStatement) {
            ((QueryDeleteStatement)parent).setWhereClause(searchCon);
        } else if (parent instanceof QueryUpdateStatement) {
            ((QueryUpdateStatement)parent).setWhereClause(searchCon);
        } else if (parent instanceof TableJoined) {
            ((TableJoined)parent).setJoinCondition(searchCon);
        } else if (parent instanceof ValueExpressionCaseSearchContent) {
            ((ValueExpressionCaseSearchContent)parent).setSearchCondition(searchCon);
        } else if (parent instanceof QuerySelect && isHaving) {
            ((QuerySelect)parent).setHavingClause(searchCon);
        } else if (parent instanceof QuerySelect && !isHaving) {
            ((QuerySelect)parent).setWhereClause(searchCon);
        }
    }

    public void addNewName(Table selectedTable) {
        boolean done = false;
        String token = selectedTable.getName();
        Integer value = new Integer(0);
        Integer number = (Integer)this.nameList.get(token);
        if (number == null) {
            this.nameList.put(token, value);
        } else {
            String result;
            while (!done && this.findSelect(result = this.nameGenerator(selectedTable.getName()))) {
            }
        }
    }

    public QueryInsertStatement createInsertStatement(String name, boolean addToDb) {
        SQLQueryModelFactoryImpl factory = new SQLQueryModelFactoryImpl();
        QueryInsertStatement sqlInsertStatement = factory.createQueryInsertStatement();
        sqlInsertStatement.setName(name);
        if (addToDb) {
            // empty if block
        }
        return sqlInsertStatement;
    }

    public QuerySelectStatement createSelectStatement(String name) {
        SQLQueryModelFactory factory = SQLQueryModelFactory.eINSTANCE;
        QuerySelectStatement sqlSelectStatement = factory.createQuerySelectStatement();
        sqlSelectStatement.setName(name);
        return sqlSelectStatement;
    }

    public QueryUpdateStatement createUpdateStatement(String name, boolean addToDb) {
        SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
        QueryUpdateStatement sqlUpdateStatement = factory.createQueryUpdateStatement();
        sqlUpdateStatement.setName(name);
        if (addToDb) {
            // empty if block
        }
        return sqlUpdateStatement;
    }

    private boolean findInsert(String name) {
        return false;
    }

    private boolean findSelect(String name) {
        return false;
    }

    public String getNewName(QueryInsertStatement insert) {
        boolean done = false;
        while (!done) {
            String result = this.nameGenerator("Insert");
            if (this.findInsert(result)) continue;
            return result;
        }
        return "Insert1";
    }

    private String nameGenerator(String token) {
        Integer number = (Integer)this.nameList.get(token);
        int value = 1;
        if (number == null) {
            this.nameList.put(token, new Integer(value));
        } else {
            value = number;
            this.nameList.remove(token);
            this.nameList.put(token, new Integer(++value));
        }
        return token + value;
    }
}

