/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.query.helper;

import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.TableReference;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.helper.SchemaHelper;
import org.eclipse.datatools.modelbase.sql.tables.Table;

public class DatabaseHelper {
    public static void resolveTableReferenceRDBTables(QueryStatement aSQLStmt, Database aDatabase, String aDefaultSchemaName) {
        List tableRefList = StatementHelper.getTablesForStatement(aSQLStmt);
        DatabaseHelper.resolveTableReferenceRDBTables(tableRefList, aDatabase, aDefaultSchemaName);
    }

    public static void resolveTableReferenceRDBTables(List aTableRefList, Database aDatabase, String aDefaultSchemaName) {
        TableInDatabase table = null;
        Iterator tableIt = aTableRefList.iterator();
        while (tableIt.hasNext()) {
            TableReference tblRef = (TableReference)tableIt.next();
            if (!(tblRef instanceof TableInDatabase)) continue;
            table = (TableInDatabase)tblRef;
            DatabaseHelper.resolveTableReferenceRDBTable(table, aDatabase, aDefaultSchemaName);
        }
    }

    public static void resolveTableReferenceRDBTable(TableInDatabase aTableInDB, Database aDatabase, String aDefaultSchemaName) {
        Table rdbTable = null;
        Schema rdbSchema = null;
        String rdbSchemaName = null;
        String searchTableName = null;
        searchTableName = aTableInDB.getName();
        Table tempRdbTbl = aTableInDB.getDatabaseTable();
        Schema tempRdbSch = null;
        if (tempRdbTbl != null) {
            tempRdbSch = tempRdbTbl.getSchema();
            rdbSchemaName = tempRdbSch != null && tempRdbSch.getName() != null && tempRdbSch.getName().length() > 0 ? tempRdbSch.getName() : aDefaultSchemaName;
        }
        if ((rdbSchema = org.eclipse.datatools.modelbase.sql.schema.helper.DatabaseHelper.findSchema((Database)aDatabase, rdbSchemaName)) != null) {
            rdbTable = SchemaHelper.findTable((Schema)rdbSchema, (String)searchTableName);
        }
        if (rdbTable != null) {
            aTableInDB.setDatabaseTable(rdbTable);
            TableHelper.populateTableExpressionColumns(aTableInDB, rdbTable);
        }
    }

    public static DataType getDataType(int decimal, String string, String string2, String string3, Database adb) {
        throw new UnsupportedOperationException(DatabaseHelper.class.getName() + "#getDataType() not implemented!");
    }
}

