/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.deltaddl;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.enablement.ase.ISybaseASEDdlConstants;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEProcedure;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.TransactionModeType;
import org.eclipse.datatools.enablement.sybase.ddl.ISybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;

public class SybaseASEProcedureDeltaDdlProvider
implements IDeltaDdlGenProvider,
ISybaseASEDdlConstants {
    static int _localhost = 0;
    private static final String DROP = "drop proc ";
    private static final String DECLARE = "declare @name varchar(767)--proc name\r\nselect @name = <<@name>>\r\ndeclare @newname varchar(767)\r\nselect @newname = <<@newname>>\r\n";
    private static final String BACKUP = "declare @backupstatus int\r\nexec @backupstatus = sp_rename @name, @newname\r\n";
    private static final String CLEANUP = "if exists (select 1 from dbo.sysobjects o where o.uid = user_id(<<@owner>>) and o.name = <<@name>>)\r\nbegin\r\n    exec ('drop proc '+@newname)\r\n    --restore the x mode\r\n    exec sp_procxmode @name, <<xmode>>\r\nend \r\nelse\r\nbegin\r\n    exec sp_rename @newname, @name --restore\r\nend\r\n";
    private static final String RENAME = "declare @newname varchar(767)\r\nselect @newname = <<@newname>>\r\nif exists (select 1 from dbo.sysobjects o where o.uid = user_id(<<@owner>>) and o.name = <<@newname>>)\r\nbegin\r\n    exec (<<@drop>>)\r\n    --restore the x mode\r\n    exec sp_procxmode @newname, <<xmode>>\r\nend \r\n";

    public void analyze(SQLObject element, Map changeMap, Map changedRecords) {
    }

    public void processAlterStatement(SQLObject element, Map modifyRecordMap, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, IProgressMonitor monitor) {
        if (!(element instanceof SybaseASEProcedure)) {
            return;
        }
        SybaseASEProcedure proc = (SybaseASEProcedure)element;
        TransactionModeType xmode = proc.getTransactionMode();
        String modeLiteral = SQLUtil.quote((String)xmode.getLiteral(), (String)"'");
        String owner = SQLUtil.quote((String)proc.getSchema().getName(), (String)"'");
        boolean xmodeChanged = false;
        boolean sourceChanged = false;
        List records = (List)modifyRecordMap.get(element);
        if (records != null) {
            String source = proc.getSource().getBody();
            Iterator iter = records.iterator();
            while (iter.hasNext()) {
                SybaseDeltaDdlGeneration.FeatureChangeRecord r = (SybaseDeltaDdlGeneration.FeatureChangeRecord)iter.next();
                if (r.feature.getFeatureID() == 1 && r.changed == proc) {
                    String name = SQLUtil.quote((String)((String)r.oldValue), (String)"'");
                    String drop = DROP + (quoteIdentifiers ? SQLUtil.quote((String)((String)r.oldValue), (String)"\"") : (String)r.oldValue);
                    drop = SQLUtil.quote((String)drop, (String)"'");
                    String newname = SQLUtil.quote((String)((String)r.newValue), (String)"'");
                    script.addCreateRoutineStatements(source);
                    String alter = RENAME.replaceAll("<<@owner>>", owner).replaceAll("<<@name>>", name).replaceAll("<<@drop>>", drop).replaceAll("<<@newname>>", newname).replaceAll("<<xmode>>", modeLiteral);
                    script.addCreateRoutineStatements(alter);
                    return;
                }
                if (r.feature.getFeatureID() == 24) {
                    xmodeChanged = true;
                    continue;
                }
                if (r.feature.getFeatureID() != 7 || r.changed != proc.getSource()) continue;
                sourceChanged = true;
            }
            String name = SQLUtil.quote((String)proc.getName(), (String)"'");
            String drop = DROP + (quoteIdentifiers ? SQLUtil.quote((String)proc.getName(), (String)"\"") : proc.getName());
            drop = SQLUtil.quote((String)drop, (String)"'");
            String newname = SQLUtil.quote((String)SybaseASEProcedureDeltaDdlProvider.makeNewName(name), (String)"'");
            String alter = "";
            if (xmodeChanged && !sourceChanged) {
                alter = "exec sp_procxmode " + name + ", " + modeLiteral;
                script.addCreateRoutineStatements(alter);
                return;
            }
            if (!sourceChanged) {
                return;
            }
            alter = "declare @name varchar(767)--proc name\r\nselect @name = <<@name>>\r\ndeclare @newname varchar(767)\r\nselect @newname = <<@newname>>\r\ndeclare @backupstatus int\r\nexec @backupstatus = sp_rename @name, @newname\r\n".replaceAll("<<@name>>", name).replaceAll("<<@drop>>", drop).replaceAll("<<@newname>>", newname).replaceAll("<<xmode>>", modeLiteral);
            script.addCreateRoutineStatements(alter);
            script.addCreateRoutineStatements(source);
            alter = "declare @name varchar(767)--proc name\r\nselect @name = <<@name>>\r\ndeclare @newname varchar(767)\r\nselect @newname = <<@newname>>\r\nif exists (select 1 from dbo.sysobjects o where o.uid = user_id(<<@owner>>) and o.name = <<@name>>)\r\nbegin\r\n    exec ('drop proc '+@newname)\r\n    --restore the x mode\r\n    exec sp_procxmode @name, <<xmode>>\r\nend \r\nelse\r\nbegin\r\n    exec sp_rename @newname, @name --restore\r\nend\r\n".replaceAll("<<@owner>>", owner).replaceAll("<<@name>>", name).replaceAll("<<@drop>>", drop).replaceAll("<<@newname>>", newname).replaceAll("<<xmode>>", modeLiteral);
            script.addCreateRoutineStatements(alter);
        }
    }

    public void processCreateStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, ISybaseDdlGenerator generator, IProgressMonitor monitor) {
    }

    public void processDropStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, SybaseDdlScript script, ISybaseDdlGenerator generator, IProgressMonitor monitor) {
    }

    static String makeNewName(String oldName) {
        if (_localhost == 0) {
            try {
                _localhost = Math.abs(InetAddress.getLocalHost().hashCode());
            }
            catch (Exception e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        String timeStamp = String.valueOf(Math.abs(System.currentTimeMillis()));
        int random = Math.abs(new Random().nextInt() % 1000);
        return "T" + _localhost + timeStamp + random;
    }
}

