/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ASEUtil;
import org.eclipse.datatools.enablement.ase.catalog.ICatalogTable;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogSchema;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASECheckConstraintImpl;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsPackage;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.expressions.SearchConditionDefault;
import org.eclipse.datatools.modelbase.sql.expressions.impl.SQLExpressionsFactoryImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogCheckConstraint
extends SybaseASECheckConstraintImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 3257282535142011699L;
    private Boolean sourceLoaded = Boolean.FALSE;
    private Boolean creatorLoaded = Boolean.FALSE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.sourceLoaded;
        synchronized (bl) {
            if (this.sourceLoaded.booleanValue()) {
                this.sourceLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        SybaseASECatalogSchema schema = (SybaseASECatalogSchema)this.getBaseTable().getSchema();
        return schema.getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getBaseTable().getSchema().getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchCondition getSearchCondition() {
        Boolean bl = this.sourceLoaded;
        synchronized (bl) {
            if (!this.sourceLoaded.booleanValue()) {
                this.loadSource();
            }
        }
        return this.searchCondition;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadSource() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String oldCatalog = null;
        try {
            try {
                oldCatalog = conn.getCatalog();
                conn.setCatalog(this.getBaseTable().getSchema().getCatalog().getName());
                stmt = conn.prepareStatement("SELECT b.text FROM sysconstraints a, syscomments b, sysprocedures p, sysobjects o, sysusers U WHERE a.constrid = b.id AND p.id = b.id AND p.sequence = 0 AND p.status & 4096 = 4096 AND a.status & 128 = 128 AND o.id = a.constrid AND o.name like ? AND o.uid = U.uid AND U.name = ?");
                stmt.setString(1, this.getName());
                stmt.setString(2, this.getCreator().getName());
                rs = stmt.executeQuery();
                SearchConditionDefault sc = null;
                while (true) {
                    if (!rs.next()) {
                        super.setSearchCondition(sc);
                    }
                    String statement = rs.getString(1);
                    sc = (SearchConditionDefault)SQLExpressionsFactoryImpl.init().create(SQLExpressionsPackage.eINSTANCE.getSearchConditionDefault());
                    sc.setSQL(SQLUtil.parseSearchStatement((String)statement));
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        this.eSetDeliver(deliver);
        this.sourceLoaded = Boolean.TRUE;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 11) {
            this.getSearchCondition();
        }
        if (id == 12) {
            this.getCreator();
        }
        return super.eIsSet(eFeature);
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema getCreator() {
        Boolean bl = this.creatorLoaded;
        synchronized (bl) {
            if (!this.creatorLoaded.booleanValue()) {
                this.loadCreatorInfo();
            }
        }
        return this.creator;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadCreatorInfo() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String oldCatalog = null;
        try {
            try {
                oldCatalog = conn.getCatalog();
                conn.setCatalog(this.getBaseTable().getSchema().getCatalog().getName());
                stmt = conn.prepareStatement("SELECT u.name FROM sysconstraints a, sysobjects o, sysusers u WHERE o.name=? AND u.uid=o.uid AND a.tableid = ? AND  a.status & 128 = 128 AND a.constrid not in (select domain from syscolumns where id = ?) AND o.id = a.constrid");
                stmt.setString(1, this.getName());
                stmt.setInt(2, ((ICatalogTable)this.getBaseTable()).getTableId());
                stmt.setInt(3, ((ICatalogTable)this.getBaseTable()).getTableId());
                rs = stmt.executeQuery();
                Schema creator = null;
                while (true) {
                    if (!rs.next()) {
                        super.setCreator(creator);
                    }
                    String creatorName = rs.getString(1);
                    SybaseASECatalog catalog = (SybaseASECatalog)this.getBaseTable().getSchema().getCatalog();
                    creator = (Schema)ASEUtil.getSQLObject((Collection)catalog.getSchemas(), creatorName);
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        this.eSetDeliver(deliver);
        this.creatorLoaded = Boolean.TRUE;
    }
}

