/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.base.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterListener;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.enablement.sybase.asa.baseloaders.SchemaASABaseLoader;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.impl.SybaseASABaseSchemaImpl;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASACatalogBaseSchema
extends SybaseASABaseSchemaImpl
implements ICatalogObject {
    private static final long serialVersionUID = -4758818420058402657L;
    protected Boolean tablesLoaded = Boolean.FALSE;
    protected Boolean routinesLoaded = Boolean.FALSE;
    protected Boolean userDefintDatatypesLoaded = Boolean.FALSE;
    protected SoftReference schemaLoaderRef = null;
    private transient ConnectionFilterListener filterListener = new ConnectionFilterListener(){

        public void connectionFilterAdded(String filterKey) {
            SybaseASACatalogBaseSchema.this.handleFilterChanged(filterKey);
        }

        public void connectionFilterRemoved(String filterKey) {
            SybaseASACatalogBaseSchema.this.handleFilterChanged(filterKey);
        }
    };

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public Connection getConnection() {
        return ((ICatalogObject)this.getCatalogDatabase()).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.tablesLoaded;
        synchronized (bl) {
            if (this.tablesLoaded.booleanValue()) {
                this.tablesLoaded = Boolean.FALSE;
            }
        }
        bl = this.routinesLoaded;
        synchronized (bl) {
            if (this.routinesLoaded.booleanValue()) {
                this.routinesLoaded = Boolean.FALSE;
            }
        }
        bl = this.userDefintDatatypesLoaded;
        synchronized (bl) {
            if (this.userDefintDatatypesLoaded.booleanValue()) {
                this.userDefintDatatypesLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    protected SchemaASABaseLoader createSchemaLoader() {
        return new SchemaASABaseLoader((Schema)this);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 6: {
                this.getTables();
                break;
            }
            case 0: {
                this.getRoutines();
                break;
            }
            case 4: {
                this.getUserDefinedTypes();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getRoutines() {
        Boolean bl = this.routinesLoaded;
        synchronized (bl) {
            if (!this.routinesLoaded.booleanValue()) {
                this.getSchemaLoader().loadRoutines(super.getRoutines());
                this.routinesLoaded = Boolean.TRUE;
            }
        }
        return super.getRoutines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getTables() {
        Boolean bl = this.tablesLoaded;
        synchronized (bl) {
            if (!this.tablesLoaded.booleanValue()) {
                this.getSchemaLoader().loadTables(super.getTables());
                this.tablesLoaded = Boolean.TRUE;
            }
        }
        return super.getTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getUserDefinedTypes() {
        Boolean bl = this.userDefintDatatypesLoaded;
        synchronized (bl) {
            if (!this.userDefintDatatypesLoaded.booleanValue()) {
                this.getSchemaLoader().loadUDTs(super.getUserDefinedTypes());
                this.userDefintDatatypesLoaded = Boolean.TRUE;
            }
        }
        return super.getUserDefinedTypes();
    }

    protected SchemaASABaseLoader getSchemaLoader() {
        SchemaASABaseLoader loader;
        SchemaASABaseLoader schemaASABaseLoader = loader = this.schemaLoaderRef == null ? null : (SchemaASABaseLoader)this.schemaLoaderRef.get();
        if (loader == null) {
            loader = this.createSchemaLoader();
            this.schemaLoaderRef = new SoftReference<SchemaASABaseLoader>(loader);
        }
        return loader;
    }

    public NotificationChain basicSetCatalog(Catalog newCatalog, NotificationChain msgs) {
        ConnectionInfo connectionInfo;
        if (this.catalog != null && this.catalog.getDatabase() != null) {
            connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.catalog.getDatabase());
            connectionInfo.removeFilterListener(this.filterListener);
        }
        if (newCatalog != null && newCatalog.getDatabase() != null) {
            connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(newCatalog.getDatabase());
            connectionInfo.addFilterListener(this.filterListener);
        }
        return super.basicSetCatalog(newCatalog, msgs);
    }

    private void handleFilterChanged(String filterKey) {
        boolean refresh = false;
        ConnectionInfo conInf = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.getCatalogDatabase());
        if (this.tablesLoaded.booleanValue() && filterKey.equals(this.getTableFilterKey()) || conInf != null && conInf.getFilter(this.getTableFilterKey()) == null && ("DatatoolsTableFilterPredicate".equals(filterKey) || filterKey.equals(this.getCatalog().getName() + "::" + "DatatoolsTableFilterPredicate"))) {
            this.tablesLoaded = Boolean.FALSE;
            refresh = true;
        }
        if (this.routinesLoaded.booleanValue() && filterKey.equals(this.getRoutineFilterKey()) || conInf != null && conInf.getFilter(this.getRoutineFilterKey()) == null && ("DatatoolsSPFilterPredicate".equals(filterKey) || filterKey.equals(this.getCatalog().getName() + "::" + "DatatoolsSPFilterPredicate"))) {
            this.routinesLoaded = Boolean.FALSE;
            refresh = true;
        }
        if (this.userDefintDatatypesLoaded.booleanValue() && filterKey.equals(this.getUDTFilterKey()) || conInf != null && conInf.getFilter(this.getUDTFilterKey()) == null && ("DatatoolsUDTFilterPredicate".equals(filterKey) || filterKey.equals(this.getCatalog().getName() + "::" + "DatatoolsUDTFilterPredicate"))) {
            this.userDefintDatatypesLoaded = Boolean.FALSE;
            refresh = true;
        }
        if (refresh) {
            RefreshManager.getInstance().referesh((ICatalogObject)this);
        }
    }

    private String getTableFilterKey() {
        return this.getCatalog().getName() + "::" + this.getName() + "::" + "DatatoolsTableFilterPredicate";
    }

    private String getRoutineFilterKey() {
        return this.getCatalog().getName() + "::" + this.getName() + "::" + "DatatoolsSPFilterPredicate";
    }

    private String getUDTFilterKey() {
        return this.getCatalog().getName() + "::" + this.getName() + "::" + "DatatoolsUDTFilterPredicate";
    }
}

