/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.datatools.enablement.oda.xml.util.AnyNumberElementPlaceholderNode;
import org.eclipse.datatools.enablement.oda.xml.util.ChildrenAllowedTreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.ElementNode;
import org.eclipse.datatools.enablement.oda.xml.util.IXMLPathNode;
import org.eclipse.datatools.enablement.oda.xml.util.NestedColumn;
import org.eclipse.datatools.enablement.oda.xml.util.TreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.XMLPath;

public class MappingPathElementTree {
    public static final String DOUBLE_SLASH_REPLACEMENT = "<>";
    public static final String FORWARD_SLASH = "/";
    public static final String DOUBLE_SLASH = "//";
    public static final String ASTERISK = "*";
    public static final String ATTR_MARKER = "@";
    private TreeNode lastTreeNodeForTablePath;
    private ChildrenAllowedTreeNode root;
    private Map indexNestedColumnMap = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.enablement.oda.xml.util.MappingPathElementTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public MappingPathElementTree(String tablePath, String[] relativeColumnPaths) {
        if (!$assertionsDisabled && !MappingPathElementTree.isValidTableMappingPath(tablePath)) {
            throw new AssertionError();
        }
        this.initFromTablePath(tablePath);
        int i = 0;
        while (i < relativeColumnPaths.length) {
            String relativePath = relativeColumnPaths[i];
            if (MappingPathElementTree.isValidColumnMappingPath(relativePath)) {
                if (relativePath.equals("")) {
                    this.lastTreeNodeForTablePath.addColumnIndex(i);
                } else if (relativePath.startsWith("../") || relativePath.equals("..")) {
                    int doubleDotCount = 0;
                    String[] splits = relativePath.split(FORWARD_SLASH);
                    int j = 0;
                    while (j < splits.length) {
                        if (splits[j].equals("..")) {
                            ++doubleDotCount;
                        }
                        ++j;
                    }
                    Set ancestors = this.getPossibleAncestors(this.lastTreeNodeForTablePath, doubleDotCount);
                    String path = relativePath.replaceFirst("\\Q..\\E(\\Q/..\\E)*", "");
                    this.indexNestedColumnMap.put(new Integer(i), new NestedColumn(doubleDotCount, path));
                    Iterator itr = ancestors.iterator();
                    while (itr.hasNext()) {
                        ChildrenAllowedTreeNode ancestor = (ChildrenAllowedTreeNode)itr.next();
                        this.addColumnPath(ancestor, path, i);
                    }
                } else if (this.lastTreeNodeForTablePath instanceof ChildrenAllowedTreeNode) {
                    this.addColumnPath((ChildrenAllowedTreeNode)this.lastTreeNodeForTablePath, relativePath, i);
                }
            }
            ++i;
        }
    }

    public boolean matchesTablePath(XMLPath path) {
        Set nodes = this.getPossibleEndNodes(path);
        Iterator itr = nodes.iterator();
        while (itr.hasNext()) {
            TreeNode node = (TreeNode)itr.next();
            if (node != this.lastTreeNodeForTablePath) continue;
            return true;
        }
        return false;
    }

    private Set getPossibleEndNodes(XMLPath path) {
        IXMLPathNode[] absolutePath = path.getPath();
        HashSet result = new HashSet();
        Iterator children = this.root.getMatchedChildren(absolutePath[0]).iterator();
        while (children.hasNext()) {
            TreeNode child = (TreeNode)children.next();
            result.addAll(this.getPossibleEndNodes(absolutePath, 0, child));
        }
        return result;
    }

    private Set getPossibleEndNodes(IXMLPathNode[] absolutePath, int fromIndex, TreeNode fromNode) {
        if (!($assertionsDisabled || absolutePath != null && fromIndex > -1 && fromNode != null)) {
            throw new AssertionError();
        }
        if (fromIndex >= absolutePath.length) {
            return Collections.EMPTY_SET;
        }
        if (fromNode.matches(absolutePath[fromIndex])) {
            if (fromIndex == absolutePath.length - 1) {
                TreeNode node;
                HashSet<TreeNode> result = new HashSet<TreeNode>();
                result.add(fromNode);
                if (fromNode instanceof AnyNumberElementPlaceholderNode) {
                    Set children = fromNode.getMatchedChildren(absolutePath[fromIndex]);
                    result.addAll(children);
                }
                if ((node = fromNode.getAnyNumberElementChild()) != null) {
                    result.add(node);
                }
                return result;
            }
            if (fromNode instanceof AnyNumberElementPlaceholderNode) {
                HashSet<TreeNode> result = new HashSet<TreeNode>();
                int i = 0;
                while (i <= absolutePath.length - fromIndex - 1) {
                    IXMLPathNode firstElement = absolutePath[fromIndex + i];
                    Set children = fromNode.getMatchedChildren(firstElement);
                    Iterator itr = children.iterator();
                    while (itr.hasNext()) {
                        TreeNode child = (TreeNode)itr.next();
                        result.addAll(this.getPossibleEndNodes(absolutePath, fromIndex + i, child));
                    }
                    ++i;
                }
                if (fromNode.matches(absolutePath[absolutePath.length - 1])) {
                    result.add(fromNode);
                }
                return result;
            }
            if (!fromNode.hasChild()) {
                return Collections.EMPTY_SET;
            }
            HashSet result = new HashSet();
            Set children = fromNode.getMatchedChildren(absolutePath[fromIndex + 1]);
            Iterator itr = children.iterator();
            while (itr.hasNext()) {
                TreeNode child = (TreeNode)itr.next();
                result.addAll(this.getPossibleEndNodes(absolutePath, fromIndex + 1, child));
            }
            return result;
        }
        return Collections.EMPTY_SET;
    }

    public int[] getMatchedColumnIndexs(XMLPath path) {
        Set nodes = this.getPossibleEndNodes(path);
        return this.getAllColumnIndexes(nodes);
    }

    private int[] getAllColumnIndexes(Set nodes) {
        HashSet indexes = new HashSet();
        Iterator itr = nodes.iterator();
        while (itr.hasNext()) {
            TreeNode node = (TreeNode)itr.next();
            indexes.addAll(node.getColumnIndexes());
        }
        int[] result = new int[indexes.size()];
        itr = indexes.iterator();
        int i = 0;
        while (itr.hasNext()) {
            int index = (Integer)itr.next();
            result[i++] = index;
        }
        return result;
    }

    public int[] getMatchedButNotNestedColumnIndexs(XMLPath column, XMLPath row) {
        if (!($assertionsDisabled || column != null && row != null)) {
            throw new AssertionError();
        }
        IXMLPathNode[] columnPath = column.getPath();
        IXMLPathNode[] rowPath = row.getPath();
        if (!column.getPathString().startsWith(row.getPathString())) {
            return new int[0];
        }
        HashSet<TreeNode> columnEndNodes = new HashSet<TreeNode>();
        if (columnPath.length == rowPath.length) {
            columnEndNodes.add(this.lastTreeNodeForTablePath);
            TreeNode node = this.lastTreeNodeForTablePath.getAnyNumberElementChild();
            if (node != null) {
                columnEndNodes.add(node);
            }
        } else {
            Iterator children = this.lastTreeNodeForTablePath.getMatchedChildren(columnPath[rowPath.length]).iterator();
            while (children.hasNext()) {
                TreeNode child = (TreeNode)children.next();
                columnEndNodes.addAll(this.getPossibleEndNodes(columnPath, rowPath.length, child));
            }
        }
        return this.getAllColumnIndexes(columnEndNodes);
    }

    public boolean isNestedColumn(int index) {
        return this.indexNestedColumnMap.containsKey(new Integer(index));
    }

    public int[] getNestedColumnIndexes() {
        Set indexes = this.indexNestedColumnMap.keySet();
        int[] result = new int[indexes.size()];
        Iterator itr = indexes.iterator();
        int i = 0;
        while (itr.hasNext()) {
            result[i++] = (Integer)itr.next();
        }
        return result;
    }

    public boolean isValidNestedColumn(int index, XMLPath row, XMLPath column) {
        NestedColumn nc = (NestedColumn)this.indexNestedColumnMap.get(new Integer(index));
        if (nc == null) {
            return false;
        }
        IXMLPathNode[] rowPath = row.getPath();
        IXMLPathNode[] columnPath = column.getPath();
        if (rowPath.length == 0) {
            return false;
        }
        int doubleDotCount = nc.getDoubleDotCount();
        if (rowPath.length < doubleDotCount) {
            return false;
        }
        if (columnPath.length < rowPath.length - doubleDotCount) {
            return false;
        }
        int i = 0;
        while (i < rowPath.length - doubleDotCount) {
            if (!rowPath[i].equals(columnPath[i])) {
                return false;
            }
            ++i;
        }
        if (columnPath.length == rowPath.length - doubleDotCount) {
            return nc.getPurePath().equals("");
        }
        String pureMappingPath = nc.getPurePath();
        if (pureMappingPath.equals("")) {
            return false;
        }
        IXMLPathNode[] nodes = new IXMLPathNode[columnPath.length - (rowPath.length - doubleDotCount)];
        System.arraycopy(columnPath, rowPath.length - doubleDotCount, nodes, 0, nodes.length);
        XMLPath path = new XMLPath(nodes);
        MappingPathElementTree tree = new MappingPathElementTree(pureMappingPath, new String[0]);
        return tree.matchesTablePath(path);
    }

    private Set getPossibleAncestors(TreeNode node, int upLevel) {
        if (node == null || upLevel < 1) {
            return Collections.EMPTY_SET;
        }
        if (upLevel == 1) {
            if (node == this.root) {
                return Collections.EMPTY_SET;
            }
            if (node instanceof AnyNumberElementPlaceholderNode) {
                HashSet<TreeNode> result = new HashSet<TreeNode>();
                result.add(node);
                result.add(node.getParent());
                if (node.getParent().getParent() != null) {
                    result.add(node.getParent().getParent());
                }
                return result;
            }
            HashSet<ChildrenAllowedTreeNode> result = new HashSet<ChildrenAllowedTreeNode>();
            result.add(node.getParent());
            if (node.getParent() instanceof AnyNumberElementPlaceholderNode) {
                result.add(node.getParent().getParent());
            }
            return result;
        }
        return this.getPossibleAncestors(node.getParent(), upLevel - 1);
    }

    private void initFromTablePath(String tablePath) {
        tablePath = tablePath.replaceAll(DOUBLE_SLASH, "/<>/");
        String[] splits = tablePath.split(FORWARD_SLASH);
        this.root = new ElementNode(FORWARD_SLASH);
        if (!$assertionsDisabled && splits.length <= 1) {
            throw new AssertionError();
        }
        TreeNode currentNode = this.root.addChild(splits[1]);
        int i = 2;
        while (i < splits.length) {
            currentNode = ((ChildrenAllowedTreeNode)currentNode).addChild(splits[i]);
            ++i;
        }
        this.lastTreeNodeForTablePath = currentNode;
    }

    private void addColumnPath(ChildrenAllowedTreeNode fromNode, String relativePath, int columnIndex) {
        String dummy = relativePath.replaceAll(DOUBLE_SLASH, "/<>/");
        String[] splits = dummy.split(FORWARD_SLASH);
        TreeNode currentNode = fromNode;
        int j = splits.length > 0 && splits[0].equals("") ? 1 : 0;
        while (j < splits.length) {
            currentNode = currentNode.addChild(splits[j]);
            ++j;
        }
        currentNode.addColumnIndex(columnIndex);
    }

    public static boolean isValidTableMappingPath(String tablePath) {
        return tablePath != null && tablePath.startsWith(FORWARD_SLASH) && !tablePath.equals(FORWARD_SLASH) && tablePath.indexOf("///") == -1 && !MappingPathElementTree.containParentAxisAfterAnyElement(tablePath) && !tablePath.matches(".*\\Q/@\\E.*\\Q/\\E.+");
    }

    private static boolean isValidColumnMappingPath(String columnPath) {
        return columnPath != null && columnPath.indexOf("///") == -1 && !MappingPathElementTree.containParentAxisAfterAnyElement(columnPath) && !columnPath.matches(".*\\Q/@\\E.*\\Q/\\E.+");
    }

    private static boolean containParentAxisAfterAnyElement(String mappingPath) {
        return mappingPath.matches(".*\\Q//../\\E.*") || mappingPath.matches(".*\\Q//..\\E$");
    }
}

