/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import org.eclipse.datatools.enablement.oda.xml.util.XPathParserUtil;

public class SaxParserUtil {
    public static final String TEMPCOLUMNNAMEPREFIX = "-$TEMP_XML_COLUMN$-";
    public static final String ROOTTEMPCOLUMNNAMEPREFIX = "-$TEMP_XML_COLUMN_ROOT$-";

    public static boolean isSamePath(String path, String generatedPath) {
        return XPathParserUtil.match(generatedPath, path);
    }

    public static String processParentAxis(String path) {
        String prefix = "";
        if (path.startsWith("//")) {
            path = path.replaceFirst("//", "");
            prefix = "//";
        } else if (path.startsWith("/")) {
            path = path.replaceFirst("/", "");
            prefix = "/";
        }
        String[] temp = path.split("/");
        int i = 0;
        while (i < temp.length) {
            if (temp[i].equals("..")) {
                temp[i] = null;
                int j = i - 1;
                while (j >= 0) {
                    if (temp[j] != null) {
                        temp[j] = null;
                        break;
                    }
                    --j;
                }
            }
            ++i;
        }
        path = prefix;
        i = 0;
        while (i < temp.length) {
            if (temp[i] != null) {
                path = i == 0 ? String.valueOf(path) + temp[i] : String.valueOf(path) + (temp[i].startsWith("[") ? "" : "/") + temp[i];
            }
            ++i;
        }
        if (path.startsWith("///")) {
            path = path.replaceFirst("\\Q/\\E", "");
        }
        return path;
    }

    static String createTempColumnName(int index) {
        return TEMPCOLUMNNAMEPREFIX + index;
    }

    static String createTableRootTempColumnNameForFilter() {
        return ROOTTEMPCOLUMNNAMEPREFIX;
    }

    static boolean isTempColumn(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith(TEMPCOLUMNNAMEPREFIX) || name.startsWith(ROOTTEMPCOLUMNNAMEPREFIX);
    }
}

