/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.date;

import com.ibm.icu.util.ULocale;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.eclipse.datatools.enablement.oda.xml.util.date.PatternKey;

public class DateFormatFactory {
    private static final int NO_TIME_STYLE = -999;
    private static ThreadLocal tlsCache;
    private static ThreadLocal patternCache;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static DateFormat getDateTimeInstance(int dateStyle, int timeStyle, ULocale locale) {
        if (!$assertionsDisabled && locale == null) {
            throw new AssertionError();
        }
        String keyStr = locale.getName() + "/" + Integer.toString(dateStyle) + "/" + Integer.toString(timeStyle);
        HashMap tlsMap = (HashMap)tlsCache.get();
        if (!$assertionsDisabled && tlsMap == null) {
            throw new AssertionError();
        }
        DateFormat result = (DateFormat)tlsMap.get(keyStr);
        if (result == null) {
            result = timeStyle == -999 ? DateFormat.getDateInstance(dateStyle, locale.toLocale()) : DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale.toLocale());
            result.setLenient(false);
            tlsMap.put(keyStr, result);
        }
        return result;
    }

    public static DateFormat getDateInstance(int dateStyle, ULocale locale) {
        return DateFormatFactory.getDateTimeInstance(dateStyle, -999, locale);
    }

    public static SimpleDateFormat getPatternInstance(PatternKey pattern) {
        HashMap patternMap = (HashMap)patternCache.get();
        if (!$assertionsDisabled && patternMap == null) {
            throw new AssertionError();
        }
        return (SimpleDateFormat)patternMap.get(pattern);
    }

    static {
        $assertionsDisabled = !DateFormatFactory.class.desiredAssertionStatus();
        tlsCache = new ThreadLocal(){

            protected Object initialValue() {
                return new HashMap();
            }
        };
        patternCache = new ThreadLocal(){

            protected Object initialValue() {
                HashMap<PatternKey, SimpleDateFormat> value = new HashMap<PatternKey, SimpleDateFormat>();
                String[] dateFormatPattern = new String[]{"yyyy-MM-dd HH:mm:ss.S z", "yyyy-MM-dd HH:mm:ss.Sz", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss z", "yyyy-MM-dd HH:mm:ssz", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm z", "yyyy-MM-dd HH:mmz", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "yyyy-MM", "yyyy", "HH:mm:ss.S z", "HH:mm:ss.Sz", "HH:mm:ss.S", "HH:mm:ss z", "HH:mm:ssz", "HH:mm:ss", "HH:mm z", "HH:mmz", "HH:mm"};
                SimpleDateFormat simpleDateFormatter = null;
                PatternKey patterKey = null;
                for (int i = 0; i < dateFormatPattern.length; ++i) {
                    patterKey = PatternKey.getPatterKey(dateFormatPattern[i]);
                    simpleDateFormatter = new SimpleDateFormat(dateFormatPattern[i]);
                    simpleDateFormatter.setLenient(false);
                    value.put(patterKey, simpleDateFormatter);
                }
                return value;
            }
        };
    }
}

