/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.datatools.enablement.oda.xml.util.ColumnInfo;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserUtil;

class TableInfo {
    private String tableName;
    private HashMap columnInfos;
    private HashMap filterInfos;
    private String originalRootPath;
    private String rootPath;

    public TableInfo(String tableName, String rootPath) {
        this.tableName = tableName;
        this.originalRootPath = rootPath;
        String temp = SaxParserUtil.processParentAxis(this.originalRootPath.replaceAll("\\Q[@\\E.*\\Q=\\E.*\\Q]\\E", ""));
        this.rootPath = "//".equals(temp) ? "//*" : temp;
        this.columnInfos = new HashMap();
        this.filterInfos = new HashMap();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPath(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getColumnPath();
    }

    public String getOriginalPath(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getColumnOriginalPath();
    }

    public int getBackRefNumber(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getBackRefNumber();
    }

    public int getForwardRefNumber(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getForwardRefNumber();
    }

    public String getType(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getColumnType();
    }

    public HashMap getFilter() {
        return this.filterInfos;
    }

    public HashMap getColumnFilters(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getFilters();
    }

    public List getFilterColumns() {
        Object[] names = this.columnInfos.keySet().toArray();
        String[] temp = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            temp[((ColumnInfo)this.columnInfos.get((Object)names[i])).getColumnIndex() - 1] = names[i].toString();
        }
        ArrayList filterColumnList = new ArrayList();
        for (int i = 0; i < temp.length; ++i) {
            if (!SaxParserUtil.isTempColumn(temp[i])) continue;
            filterColumnList.add(this.columnInfos.get(temp[i]));
        }
        return filterColumnList;
    }

    public void addColumn(ColumnInfo ci) {
        this.columnInfos.put(ci.getColumnName(), ci);
    }

    public void addFilter(String columnName, String value) {
        this.filterInfos.put(columnName, value);
    }

    public String[] getColumnNames() {
        String[] temp = this.getRealColumnNames();
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < temp.length && !SaxParserUtil.isTempColumn(temp[i]); ++i) {
            l.add(temp[i]);
        }
        String[] result = new String[l.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = l.get(i).toString();
        }
        return result;
    }

    public String[] getRealColumnNames() {
        Object[] names = this.columnInfos.keySet().toArray();
        String[] temp = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            temp[((ColumnInfo)this.columnInfos.get((Object)names[i])).getColumnIndex() - 1] = names[i].toString();
        }
        return temp;
    }

    public String[] getComplexNestXMLColumnNames() {
        ArrayList<String> temp = new ArrayList<String>();
        String[] columnNames = this.getColumnNames();
        String[] simpleNestXMLColumnNames = this.getSimpleNestXMLColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            if (((ColumnInfo)this.columnInfos.get(columnNames[i])).getColumnPath().startsWith(this.rootPath)) continue;
            boolean isComplexNestXMLColumn = true;
            for (int j = 0; j < simpleNestXMLColumnNames.length; ++j) {
                if (!simpleNestXMLColumnNames[j].equals(columnNames[i])) continue;
                isComplexNestXMLColumn = false;
                break;
            }
            if (!isComplexNestXMLColumn) continue;
            temp.add(columnNames[i]);
        }
        return this.getStringArrayFromList(temp);
    }

    private String[] getStringArrayFromList(ArrayList temp) {
        String[] result = new String[temp.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = temp.get(i).toString();
        }
        return result;
    }

    public String[] getSimpleNestXMLColumnNames() {
        ArrayList<String> temp = new ArrayList<String>();
        String[] columnNames = this.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            String nestedXMLColumnPathPrefix = ((ColumnInfo)this.columnInfos.get(columnNames[i])).getColumnPath();
            if (!nestedXMLColumnPathPrefix.matches(".*\\Q@\\E.*") || !this.isSimpleNestedColumn(this.rootPath, nestedXMLColumnPathPrefix = nestedXMLColumnPathPrefix.replaceAll("\\Q[@\\E.*", ""))) continue;
            temp.add(columnNames[i]);
        }
        return this.getStringArrayFromList(temp);
    }

    private boolean isSimpleNestedColumn(String rootPath, String treatedColumPath) {
        String[] tempString1 = treatedColumPath.split("/");
        String[] tempString2 = rootPath.split("/");
        if (tempString2.length <= tempString1.length) {
            return false;
        }
        for (int j = 0; j < tempString1.length; ++j) {
            if (tempString1[j] == null || tempString2[j] == null || tempString1[j].equals(tempString2[j]) || "*".equals(tempString1[j]) || "*".equals(tempString2[j])) continue;
            return false;
        }
        return true;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String getOriginalRootPath() {
        return this.originalRootPath;
    }

    public String getAncestor() {
        String[] columnNames = this.getColumnNames();
        if (columnNames.length == 1) {
            return this.getPath(columnNames[0]);
        }
        String[] paths = new String[columnNames.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = this.getPath(columnNames[i]).replaceFirst("\\Q\\[@\\E.*\\Q\\]\\E", "");
        }
        String theLongestPath = "";
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i].split("\\Q/\\E").length <= theLongestPath.split("\\Q/\\E").length) continue;
            theLongestPath = paths[i];
        }
        boolean isAbsolutePath = false;
        if (theLongestPath.startsWith("//")) {
            isAbsolutePath = false;
            theLongestPath = theLongestPath.replaceFirst("\\Q//\\E", "");
        } else {
            isAbsolutePath = true;
            theLongestPath = theLongestPath.replaceFirst("\\Q/\\E", "");
        }
        String[] temp = theLongestPath.split("\\Q/\\E");
        String prefix = isAbsolutePath ? "/" : "//";
        for (int j = 0; j < temp.length; ++j) {
            String attempedPrefix = j == 0 ? prefix + temp[j] : prefix + "/" + temp[j];
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i].startsWith(attempedPrefix)) continue;
                return prefix;
            }
            prefix = attempedPrefix;
        }
        return prefix;
    }
}

