/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.date;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.datatools.enablement.oda.xml.util.date.DateFormatter;

class DateFormatUtil {
    private static void loadULocaleInstanceFromLocale(Set uLocales) {
        Locale[] ls = Locale.getAvailableLocales();
        int i = 0;
        while (i < ls.length) {
            uLocales.add(ULocale.forLocale((Locale)ls[i]));
            ++i;
        }
    }

    private static void loadULocaleInstanceFromULocale(Set uLocales) {
        ULocale[] uls = ULocale.getAvailableLocales();
        int i = 0;
        while (i < uls.length) {
            uLocales.add(uls[i]);
            ++i;
        }
    }

    private static ULocale[] populateULocaleCache() {
        HashSet uLocales = new HashSet();
        DateFormatUtil.loadULocaleInstanceFromULocale(uLocales);
        DateFormatUtil.loadULocaleInstanceFromLocale(uLocales);
        ULocale[] AllULocales = new ULocale[uLocales.size()];
        Object[] localeArray = uLocales.toArray();
        int i = 0;
        while (i < AllULocales.length) {
            AllULocales[i] = (ULocale)localeArray[i];
            ++i;
        }
        return AllULocales;
    }

    private DateFormatUtil() {
    }

    static Map getAllDateFormatter() {
        HashMap<ULocale, DateFormatter> reMap = new HashMap<ULocale, DateFormatter>(80);
        ULocale[] AllULocales = DateFormatUtil.populateULocaleCache();
        int i = 0;
        while (i < AllULocales.length) {
            reMap.put(AllULocales[i], new DateFormatter(AllULocales[i]));
            ++i;
        }
        return reMap;
    }

    static Map getAllDateFormat() {
        HashMap<String, DateFormat> reMap = new HashMap<String, DateFormat>(240);
        ULocale[] AllULocales = DateFormatUtil.populateULocaleCache();
        int i = 0;
        while (i < AllULocales.length) {
            int dateStyle = 1;
            while (dateStyle <= 3) {
                DateFormat dateFormat = DateFormat.getDateInstance((int)dateStyle, (ULocale)AllULocales[i]);
                dateFormat.setLenient(false);
                String key = String.valueOf(String.valueOf(dateStyle)) + ":" + AllULocales[i].getName();
                reMap.put(key, dateFormat);
                ++dateStyle;
            }
            ++i;
        }
        return reMap;
    }

    static Map getAllDateTimeFormat() {
        HashMap<String, DateFormat> reMap = new HashMap<String, DateFormat>(720);
        ULocale[] AllULocales = DateFormatUtil.populateULocaleCache();
        int i = 0;
        while (i < AllULocales.length) {
            int dateStyle = 1;
            while (dateStyle <= 3) {
                int timeStyle = 1;
                while (timeStyle <= 3) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance((int)dateStyle, (int)timeStyle, (ULocale)AllULocales[i]);
                    dateFormat.setLenient(false);
                    String key = String.valueOf(String.valueOf(dateStyle)) + ":" + String.valueOf(timeStyle) + ":" + AllULocales[i].getName();
                    reMap.put(key, dateFormat);
                    ++timeStyle;
                }
                ++dateStyle;
            }
            ++i;
        }
        return reMap;
    }
}

