/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.io.IOException;
import java.util.HashMap;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.datatools.enablement.oda.xml.util.ISaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.XMLDataInputStream;
import org.eclipse.datatools.enablement.oda.xml.util.XPathHolder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxParser
extends DefaultHandler
implements Runnable {
    private XMLDataInputStream inputStream;
    private XPathHolder pathHolder;
    private ISaxParserConsumer spConsumer;
    private HashMap currentElementRecoder;
    private boolean start;
    private boolean alive;
    private String currentCacheValue;
    private boolean stopCurrentThread;

    public SaxParser(XMLDataInputStream stream, ISaxParserConsumer consumer) {
        this.inputStream = stream;
        this.spConsumer = consumer;
        this.start = true;
        this.alive = true;
        this.currentCacheValue = "";
        this.currentElementRecoder = new HashMap();
        this.stopCurrentThread = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                SAXParser xr = new SAXParser();
                xr.setContentHandler(this);
                xr.setErrorHandler(this);
                this.inputStream.init();
                try {
                    xr.parse(new InputSource(this.inputStream));
                }
                catch (ThreadStopException tsE) {
                    tsE.printStackTrace();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.alive = false;
            this.spConsumer.wakeup();
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.alive = false;
            this.spConsumer.wakeup();
            return;
        }
    }

    public void startDocument() {
        this.pathHolder = new XPathHolder();
    }

    public void endDocument() {
        this.alive = false;
        this.cleanUp();
        this.spConsumer.wakeup();
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (this.stopCurrentThread) {
            throw new ThreadStopException();
        }
        String elementName = this.getElementName(uri, qName, name);
        String parentPath = this.pathHolder.getPath();
        if (this.currentElementRecoder.get(String.valueOf(parentPath) + "/" + elementName) == null) {
            this.currentElementRecoder.put(String.valueOf(parentPath) + "/" + elementName, new Integer(1));
        } else {
            this.currentElementRecoder.put(String.valueOf(parentPath) + "/" + elementName, new Integer((Integer)this.currentElementRecoder.get(String.valueOf(parentPath) + "/" + elementName) + 1));
        }
        this.pathHolder.push(String.valueOf(elementName) + "[" + (Integer)this.currentElementRecoder.get(String.valueOf(parentPath) + "/" + elementName) + "]");
        this.spConsumer.detectNewRow(this.pathHolder.getPath(), true);
        int i = 0;
        while (i < atts.getLength()) {
            this.spConsumer.manipulateData(this.getAttributePath(atts, i), atts.getValue(i));
            this.spConsumer.detectNewRow(this.getAttributePath(atts, i), true);
            ++i;
        }
    }

    private String getAttributePath(Attributes atts, int i) {
        return String.valueOf(this.pathHolder.getPath()) + "[@" + this.getElementName(atts.getURI(i), atts.getQName(i), atts.getLocalName(i)) + "]";
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.spConsumer.manipulateData(this.pathHolder.getPath(), this.currentCacheValue.trim());
        this.currentCacheValue = "";
        this.spConsumer.detectNewRow(this.pathHolder.getPath(), false);
        String path = this.pathHolder.getPath();
        Object[] keys = this.currentElementRecoder.keySet().toArray();
        int i = 0;
        while (i < keys.length && path != "") {
            if (keys[i].toString().startsWith(path) && !keys[i].toString().equals(path)) {
                this.currentElementRecoder.remove(keys[i]);
            }
            ++i;
        }
        this.pathHolder.pop();
    }

    private String getElementName(String uri, String qName, String name) {
        return qName;
    }

    public void characters(char[] ch, int start, int length) {
        int i = 0;
        while (i < length) {
            this.currentCacheValue = String.valueOf(this.currentCacheValue) + ch[start + i];
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStart(boolean start) {
        this.start = start;
        if (start) {
            SaxParser saxParser = this;
            synchronized (saxParser) {
                this.notify();
            }
        }
        SaxParser saxParser = this;
        synchronized (saxParser) {
            try {
                this.spConsumer.wakeup();
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void stopParsing() {
        this.cleanUp();
        this.stopCurrentThread = true;
    }

    public boolean isSuspended() {
        return !this.start;
    }

    public boolean isAlive() {
        return this.alive;
    }

    private void cleanUp() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class ThreadStopException
    extends RuntimeException {
        private static final long serialVersionUID = 7871277314833138093L;

        ThreadStopException() {
        }
    }
}

