/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.util.List;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.XMLRelationInfoUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.TreeNodeData;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XPathPopulationUtil;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class RowMappingDialog
extends TrayDialog {
    private String title;
    private List pathList;
    private String selectStr;
    private Button absolutePathButton;
    private Button anyLocationButton;
    private Button customButton;
    private Label absolutePathLabel;
    private Label anyLocationLabel;
    private Label customPathLabel;
    private Combo xmlPathField;
    private TreeItem selectedItem;
    private String rootPath;
    private int selectRadioIndex;
    private static final String PATH_SEPERATOR = "/";

    public RowMappingDialog(Shell parent, String title, TreeItem selectedItem, int selectRadioIndex, String selectStr) {
        super(parent);
        this.title = title;
        this.selectedItem = selectedItem;
        this.pathList = this.getSelectedXPathList();
        this.selectRadioIndex = selectRadioIndex;
        this.selectStr = selectStr;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite panel = (Composite)super.createDialogArea(parent);
        Label label = new Label(panel, 0);
        label.setText(Messages.getString("RowMappingDialog.info"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData data = new GridData(1808);
        data.heightHint = 250;
        Group composite = new Group(panel, 0);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        GridData buttonGd = new GridData();
        buttonGd.verticalAlignment = 1;
        buttonGd.verticalIndent = 5;
        GridData labelGd = new GridData(768);
        labelGd.verticalIndent = 5;
        this.absolutePathButton = new Button((Composite)composite, 80);
        this.absolutePathButton.setLayoutData((Object)buttonGd);
        this.absolutePathLabel = new Label((Composite)composite, 64);
        this.absolutePathLabel.setLayoutData((Object)labelGd);
        this.anyLocationButton = new Button((Composite)composite, 80);
        this.anyLocationButton.setLayoutData((Object)buttonGd);
        this.anyLocationLabel = new Label((Composite)composite, 64);
        this.anyLocationLabel.setLayoutData((Object)labelGd);
        this.customButton = new Button((Composite)composite, 80);
        this.customButton.setLayoutData((Object)buttonGd);
        this.customPathLabel = new Label((Composite)composite, 64);
        this.customPathLabel.setLayoutData((Object)labelGd);
        this.customPathLabel.setText(Messages.getString("xPathChoosePage.messages.elementSelection.item.custom"));
        new Label((Composite)composite, 0);
        GridData txtGridData = new GridData(768);
        this.xmlPathField = new Combo((Composite)composite, 4);
        this.xmlPathField.setLayoutData((Object)txtGridData);
        int i = 0;
        while (i < this.pathList.size()) {
            this.xmlPathField.setText(TextProcessor.process((String)this.pathList.get(i).toString(), (String)"//"));
            this.xmlPathField.add(TextProcessor.process((String)this.pathList.get(i).toString(), (String)"//"));
            ++i;
        }
        this.setLabelValuesAndListeners((Composite)composite);
        XMLRelationInfoUtil.setSystemHelp((Control)composite, "org.eclipse.datatools.oda.cshelp.Dialog_XPathExpression_ID");
        if (this.selectRadioIndex == 1) {
            this.absolutePathButton.setSelection(true);
            this.xmlPathField.setEnabled(false);
            if (this.pathList.size() > 0) {
                this.xmlPathField.setText(TextProcessor.process((String)this.pathList.get(0).toString(), (String)"//"));
            }
        } else if (this.selectRadioIndex == 2) {
            this.anyLocationButton.setSelection(true);
            this.xmlPathField.setEnabled(false);
            if (this.pathList.size() > 1) {
                this.xmlPathField.setText(TextProcessor.process((String)this.pathList.get(1).toString(), (String)"//"));
            }
        } else {
            this.customButton.setSelection(true);
            this.xmlPathField.setText(TextProcessor.process((String)this.selectStr, (String)"//"));
        }
        return composite;
    }

    private void setLabelValuesAndListeners(Composite composite) {
        if (this.selectedItem != null) {
            if (this.pathList.size() < 2) {
                return;
            }
            this.resetButtonsAndLabels(true);
        } else {
            this.resetButtonsAndLabels(false);
        }
        this.absolutePathLabel.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                RowMappingDialog.this.absolutePathButton.setSelection(true);
                RowMappingDialog.this.anyLocationButton.setSelection(false);
                RowMappingDialog.this.customButton.setSelection(false);
                RowMappingDialog.this.doSelectAbsolutePathButton();
            }
        });
        this.anyLocationLabel.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                RowMappingDialog.this.anyLocationButton.setSelection(true);
                RowMappingDialog.this.absolutePathButton.setSelection(false);
                RowMappingDialog.this.customButton.setSelection(false);
                RowMappingDialog.this.doSelectAnyLocationButton();
            }
        });
        this.customPathLabel.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                RowMappingDialog.this.customButton.setSelection(true);
                RowMappingDialog.this.xmlPathField.setEnabled(true);
                RowMappingDialog.this.absolutePathButton.setSelection(false);
                RowMappingDialog.this.anyLocationButton.setSelection(false);
                RowMappingDialog.this.selectRadioIndex = 3;
            }
        });
        this.absolutePathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RowMappingDialog.this.doSelectAbsolutePathButton();
            }
        });
        this.anyLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RowMappingDialog.this.doSelectAnyLocationButton();
            }
        });
        this.customButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RowMappingDialog.this.customButton.getSelection()) {
                    RowMappingDialog.this.selectRadioIndex = 3;
                    RowMappingDialog.this.xmlPathField.setEnabled(true);
                }
            }
        });
        composite.layout();
    }

    private void doSelectAbsolutePathButton() {
        if (this.absolutePathButton.getSelection() && this.pathList != null && this.pathList.size() > 0) {
            this.selectRadioIndex = 1;
            this.rootPath = this.pathList.get(0).toString();
            this.xmlPathField.setEnabled(false);
            this.xmlPathField.setText(TextProcessor.process((String)this.rootPath, (String)"//"));
        }
    }

    private void doSelectAnyLocationButton() {
        if (this.anyLocationButton.getSelection() && this.pathList != null && this.pathList.size() > 1) {
            this.selectRadioIndex = 2;
            this.rootPath = this.pathList.get(1).toString();
            this.xmlPathField.setEnabled(false);
            this.xmlPathField.setText(TextProcessor.process((String)this.rootPath, (String)"//"));
        }
    }

    private void resetButtonsAndLabels(boolean visible) {
        if (visible) {
            this.absolutePathLabel.setText(Messages.getFormattedString("xPathChoosePage.messages.elementSelection.item.absolutePath", new String[]{this.selectedItem.getText()}));
            this.anyLocationLabel.setText(Messages.getFormattedString("xPathChoosePage.messages.elementSelection.item.anyLocation", new String[]{this.selectedItem.getText()}));
        } else {
            this.absolutePathLabel.setText(Messages.getString("xPathChoosePage.messages.elementSelection.disable.absolutePath"));
            this.anyLocationLabel.setText(Messages.getString("xPathChoosePage.messages.elementSelection.disable.anyLocation"));
        }
        this.absolutePathButton.setEnabled(visible);
        this.absolutePathLabel.setEnabled(visible);
        this.anyLocationButton.setEnabled(visible);
        this.anyLocationLabel.setEnabled(visible);
    }

    private List getSelectedXPathList() {
        String path = this.selectedItem == null ? PATH_SEPERATOR + this.rootPath : this.getRootPath();
        return XPathPopulationUtil.getPathList((String)path);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.selectStr = this.absolutePathButton.getSelection() ? this.pathList.get(0).toString() : (this.anyLocationButton.getSelection() ? this.pathList.get(1).toString() : this.xmlPathField.getText());
        }
        super.buttonPressed(buttonId);
    }

    private String getRootPath() {
        ATreeNode node;
        TreeItem selected = this.selectedItem;
        if (selected.getData() instanceof TreeNodeData) {
            node = ((TreeNodeData)selected.getData()).getTreeNode();
            if (node.getType() == 2) {
                return null;
            }
            this.rootPath = PATH_SEPERATOR + selected.getText();
        }
        while (selected.getParentItem() != null) {
            if (!((selected = selected.getParentItem()).getData() instanceof TreeNodeData) || (node = ((TreeNodeData)selected.getData()).getTreeNode()).getType() != 1) continue;
            this.rootPath = PATH_SEPERATOR + selected.getText() + this.rootPath;
        }
        return this.rootPath;
    }

    String getSelectedPath() {
        return this.selectStr;
    }

    int getSelectIndex() {
        return this.selectRadioIndex;
    }
}

