/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.XMLRelationInfoUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.XMLInformationHolder;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class XmlDataSetSelectionPage
extends DataSetWizardPage {
    private static String DEFAULT_MESSAGE = Messages.getString("wizard.defaultMessage.selectFile");
    private static final int ERROR_FOLDER = 1;
    private static final int ERROR_EMPTY_PATH = 2;
    private transient Text folderLocation;
    private transient Button previewNumCheckBox;
    private transient Button useDataSourceXMLDataCheckBox;
    private transient Text numberText;
    private transient Button browseFolderButton;
    private boolean selected = false;
    private boolean useDataSourceXMLDataSelected = true;
    private String fileLocation;
    private final int UNUSED_ROW_CACHE = -1;
    private final int INVALID_ROW_NUMBER = -2;
    private final int NEGATIVE_ROW_NUMBER = -4;
    private int maxRow = -1;

    public XmlDataSetSelectionPage() {
        this(Messages.getString("wizard.title.newDataSet"));
    }

    public XmlDataSetSelectionPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(DEFAULT_MESSAGE);
        this.setPageComplete(false);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
        XMLRelationInfoUtil.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Wizard_XMLSample_ID");
    }

    public Control createPageControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(272);
        data.horizontalSpan = 3;
        Label label1 = new Label(composite, 0);
        label1.setText(Messages.getString("lable.selectXmlFile"));
        label1.setLayoutData((Object)data);
        this.setupXMLFolderLocation(composite);
        this.setUseDataSourceXMLDataSelection(composite);
        this.setRowSelection(composite);
        return composite;
    }

    private void initializeControl() {
        String xmlFile;
        DataSetDesign dataSetDesign = this.getDataSetDesign();
        if (dataSetDesign == null) {
            return;
        }
        if (XMLInformationHolder.hasDestroyed()) {
            XMLInformationHolder.start(dataSetDesign);
        }
        if ((xmlFile = XMLInformationHolder.getPropertyValue("XML_FILE")) == null || xmlFile.trim().length() == 0) {
            this.useDataSourceXMLDataSelected = true;
            this.folderLocation.setText("");
            this.enableFolderLocation(false);
        } else {
            this.useDataSourceXMLDataSelected = false;
            this.folderLocation.setText(xmlFile);
            this.enableFolderLocation(true);
        }
        this.useDataSourceXMLDataCheckBox.setSelection(this.useDataSourceXMLDataSelected);
        String rowNumber = XMLInformationHolder.getPropertyValue("MAX_ROW");
        try {
            this.maxRow = Integer.parseInt(rowNumber);
            if (this.maxRow == -1 || this.maxRow == -2 || this.maxRow == -4) {
                this.maxRow = -1;
            } else {
                this.selected = true;
                this.previewNumCheckBox.setSelection(this.selected);
                this.numberText.setEnabled(this.selected);
                this.numberText.setText(rowNumber);
            }
            this.setPageStatus();
        }
        catch (NumberFormatException e) {
            this.maxRow = -1;
        }
        this.setPageComplete(true);
        if (!this.isSessionEditable()) {
            this.getControl().setEnabled(false);
        }
    }

    private void setRowSelection(Composite composite) {
        Composite rowSelectionGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 3;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 0;
        rowSelectionGroup.setLayout((Layout)layout);
        rowSelectionGroup.setLayoutData((Object)new GridData(272));
        this.previewNumCheckBox = new Button(rowSelectionGroup, 32);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        this.previewNumCheckBox.setLayoutData((Object)data);
        this.previewNumCheckBox.setText(Messages.getString("label.preview"));
        this.numberText = new Text(rowSelectionGroup, 2048);
        this.numberText.setEnabled(false);
        data = new GridData();
        data.horizontalSpan = 1;
        Point minSize = this.numberText.computeSize(-1, -1, true);
        data.widthHint = Math.max(50, minSize.x);
        this.numberText.setLayoutData((Object)data);
        this.numberText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (XmlDataSetSelectionPage.this.numberText.getText() != null && XmlDataSetSelectionPage.this.numberText.getText().trim().length() > 0) {
                    XmlDataSetSelectionPage.this.setPageStatus();
                }
            }
        });
        Label label = new Label(rowSelectionGroup, 1);
        label.setText(Messages.getString("xmlDataSetSelectionPage.messages.lineofdata"));
        this.previewNumCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XmlDataSetSelectionPage.this.selected = !XmlDataSetSelectionPage.this.selected;
                XmlDataSetSelectionPage.this.numberText.setEnabled(XmlDataSetSelectionPage.this.selected);
                if (!XmlDataSetSelectionPage.this.selected) {
                    XmlDataSetSelectionPage.this.maxRow = -1;
                    XmlDataSetSelectionPage.this.setPageComplete(true);
                    XMLInformationHolder.setPropertyValue("MAX_ROW", Integer.toString(XmlDataSetSelectionPage.this.maxRow));
                    XmlDataSetSelectionPage.this.setPageStatus();
                } else if (XmlDataSetSelectionPage.this.numberText.getText() != null && XmlDataSetSelectionPage.this.numberText.getText().trim().length() > 0) {
                    XmlDataSetSelectionPage.this.setPageStatus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setUseDataSourceXMLDataSelection(Composite composite) {
        Composite rowSelectionGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        GridData data = new GridData(272);
        data.horizontalSpan = 3;
        rowSelectionGroup.setLayout((Layout)layout);
        rowSelectionGroup.setLayoutData((Object)data);
        this.useDataSourceXMLDataCheckBox = new Button(rowSelectionGroup, 32);
        this.useDataSourceXMLDataCheckBox.setLayoutData((Object)data);
        this.useDataSourceXMLDataCheckBox.setText(Messages.getString("label.useXMLFileFromDataSource"));
        this.useDataSourceXMLDataCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XmlDataSetSelectionPage.this.useDataSourceXMLDataSelected = !XmlDataSetSelectionPage.this.useDataSourceXMLDataSelected;
                if (XmlDataSetSelectionPage.this.useDataSourceXMLDataSelected) {
                    XmlDataSetSelectionPage.this.enableFolderLocation(false);
                    XmlDataSetSelectionPage.this.fileLocation = "";
                } else {
                    XmlDataSetSelectionPage.this.enableFolderLocation(true);
                    XmlDataSetSelectionPage.this.fileLocation = XmlDataSetSelectionPage.this.folderLocation.getText();
                }
                XmlDataSetSelectionPage.this.setXMLFileLocaiton();
                XmlDataSetSelectionPage.this.setPageStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void enableFolderLocation(boolean enable) {
        this.folderLocation.setEnabled(enable);
        this.browseFolderButton.setEnabled(enable);
    }

    private void setPageStatus() {
        if (this.numberText == null || !this.previewNumCheckBox.getSelection()) {
            this.setMessage(DEFAULT_MESSAGE);
            return;
        }
        String rowNumber = this.numberText.getText();
        this.maxRow = this.validateRowNumber(rowNumber);
        if (this.maxRow == -2 || this.maxRow == -4) {
            this.setPageComplete(false);
            this.setDetailsMessage(Messages.getString("error.dataset.maxRowNumberError"), 3);
        } else {
            XMLInformationHolder.setPropertyValue("MAX_ROW", Integer.toString(this.maxRow));
            this.setPageComplete(true);
            this.setMessage(DEFAULT_MESSAGE);
        }
    }

    private int validateRowNumber(String maxRow) {
        int rowNumber = 0;
        try {
            rowNumber = Integer.parseInt(maxRow);
        }
        catch (NumberFormatException e) {
            return -2;
        }
        if (rowNumber < 0) {
            return -4;
        }
        return rowNumber;
    }

    private void setupXMLFolderLocation(Composite composite) {
        GridData data = new GridData(784);
        data.horizontalSpan = 2;
        this.folderLocation = new Text(composite, 2052);
        this.folderLocation.setLayoutData((Object)data);
        this.setPageComplete(false);
        this.folderLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XmlDataSetSelectionPage.this.setXMLFileLocaiton();
            }
        });
        this.browseFolderButton = new Button(composite, 0);
        this.browseFolderButton.setText(Messages.getString("file.choose"));
        this.browseFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedLocation;
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
                if (XmlDataSetSelectionPage.this.folderLocation.getText() != null && XmlDataSetSelectionPage.this.folderLocation.getText().trim().length() > 0) {
                    dialog.setFilterPath(XmlDataSetSelectionPage.this.folderLocation.getText());
                }
                if ((selectedLocation = dialog.open()) != null) {
                    XmlDataSetSelectionPage.this.folderLocation.setText(selectedLocation);
                    XmlDataSetSelectionPage.this.setXMLFileLocaiton();
                }
            }
        });
    }

    private int varifyFileLocation(String fileLocation) {
        int result;
        block6: {
            result = 0;
            if (fileLocation != null && fileLocation.trim().length() > 0) {
                try {
                    new URL(fileLocation);
                }
                catch (MalformedURLException e) {
                    File file = new File(fileLocation);
                    if (file.exists()) {
                        this.setMessage(DEFAULT_MESSAGE);
                        break block6;
                    }
                    this.setDetailsMessage(Messages.getString("error.selectFolder"), 3);
                    result = 1;
                }
            } else if (!this.useDataSourceXMLDataSelected) {
                this.setDetailsMessage(Messages.getString("error.emptyPath"), 3);
                result = 2;
            }
        }
        return result;
    }

    private void setXMLFileLocaiton() {
        this.fileLocation = this.useDataSourceXMLDataSelected ? "" : (this.folderLocation.getText() == null ? "" : this.folderLocation.getText());
        XMLInformationHolder.setPropertyValue("XML_FILE", this.fileLocation);
    }

    private DataSetDesign getDataSetDesign() {
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        return dataSetDesign;
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        try {
            this.savePage(design);
        }
        catch (OdaException odaException) {
            // empty catch block
        }
        return design;
    }

    private void savePage(DataSetDesign dataSetDesign) throws OdaException {
        if (XMLInformationHolder.hasDestroyed()) {
            return;
        }
        if (dataSetDesign.getPrivateProperties() == null) {
            try {
                dataSetDesign.setPrivateProperties(DesignSessionUtil.createDataSetNonPublicProperties((String)dataSetDesign.getOdaExtensionDataSourceId(), (String)dataSetDesign.getOdaExtensionDataSetId(), (Properties)XmlDataSetSelectionPage.getPageProperties()));
            }
            catch (OdaException odaException) {
                // empty catch block
            }
        }
        if (dataSetDesign.getPrivateProperties() != null) {
            if (dataSetDesign.getPrivateProperties().findProperty("XML_FILE") != null) {
                dataSetDesign.getPrivateProperties().findProperty("XML_FILE").setNameValue("XML_FILE", XMLInformationHolder.getPropertyValue("XML_FILE"));
            }
            if (dataSetDesign.getPrivateProperties().findProperty("MAX_ROW") != null) {
                dataSetDesign.getPrivateProperties().findProperty("MAX_ROW").setNameValue("MAX_ROW", XMLInformationHolder.getPropertyValue("MAX_ROW"));
            }
        }
    }

    public IWizardPage getNextPage() {
        int result = this.varifyFileLocation(this.fileLocation);
        boolean doNext = true;
        if (result == 1) {
            doNext = MessageDialog.openQuestion((Shell)this.getShell(), (String)DEFAULT_MESSAGE, (String)Messages.getFormattedString("xmlDataSetSelectionPage.warning.errorReadXMLFile", new Object[]{this.fileLocation, Messages.getString("error.selectFolder")}));
        } else if (result == 2) {
            doNext = MessageDialog.openQuestion((Shell)this.getShell(), (String)DEFAULT_MESSAGE, (String)Messages.getFormattedString("xmlDataSetSelectionPage.warning.errorReadXMLFile", new Object[]{this.fileLocation, Messages.getString("error.emptyPath")}));
        }
        if (this.isValid() && doNext) {
            XMLInformationHolder.setPropertyValue("MAX_ROW", Integer.toString(this.maxRow));
            return super.getNextPage();
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        return this.isValid();
    }

    private boolean isValid() {
        return this.maxRow == -1 || this.maxRow >= 0;
    }

    private static Properties getPageProperties() {
        Properties prop = new Properties();
        prop.setProperty("XML_FILE", "");
        prop.setProperty("MAX_ROW", "-1");
        return prop;
    }

    public void setMessage(String newMessage) {
        super.setMessage(newMessage);
    }

    protected boolean canLeave() {
        return this.isValid();
    }

    private void setDetailsMessage(String message, int type) {
        this.setMessage(message, type);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().setFocus();
    }

    protected void cleanup() {
        XMLInformationHolder.destory();
    }
}

