/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.TextProcessorWrapper;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.XMLRelationInfoUtil;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class XMLSelectionPageHelper {
    private static final String AUTO_ENCODING;
    private WizardPage m_wizardPage;
    private PreferencePage m_propertyPage;
    private transient Text m_folderLocation = null;
    private transient Text m_schemaLocation = null;
    private transient Button browseFolderButton = null;
    private transient Combo encodingCombo = null;
    static final String DEFAULT_MESSAGE;
    private static final String EMPTY_STRING = "";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.enablement.oda.xml.ui.wizards.XMLSelectionPageHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        AUTO_ENCODING = Messages.getString("wizard.autoEncoding");
        DEFAULT_MESSAGE = Messages.getString("wizard.defaultMessage.selectFolder");
    }

    XMLSelectionPageHelper(WizardPage page) {
        this.m_wizardPage = page;
    }

    XMLSelectionPageHelper(PreferencePage page) {
        this.m_propertyPage = page;
    }

    void createCustomControl(Composite parent) {
        this.setMessage(DEFAULT_MESSAGE);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(272);
        data.horizontalSpan = 2;
        Label label1 = new Label(composite, 0);
        label1.setText(Messages.getString("lable.selectXmlFile"));
        label1.setLayoutData((Object)data);
        this.setupXMLFolderLocation(composite);
        data = new GridData(272);
        data.horizontalSpan = 2;
        Label label3 = new Label(composite, 0);
        label3.setText(Messages.getString("lable.selectXmlSchmaFile"));
        label3.setLayoutData((Object)data);
        this.setupSchemaFolderLocation(composite);
        data = new GridData(272);
        data.horizontalSpan = 2;
        Label label2 = new Label(composite, 0);
        label2.setText(Messages.getString("label.selectEncoding"));
        label2.setLayoutData((Object)data);
        this.setupEncodingControl(composite);
        XMLRelationInfoUtil.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Wizard_XML_Datasource_ID");
    }

    String getFolderLocation() {
        if (this.m_folderLocation == null) {
            return EMPTY_STRING;
        }
        return this.getFolderLocationString();
    }

    String getSchemaFileLocation() {
        if (this.m_schemaLocation == null) {
            return EMPTY_STRING;
        }
        return this.getSchemaLocationString();
    }

    String getEncoding() {
        if (this.encodingCombo == null || this.encodingCombo.getText().equals(AUTO_ENCODING)) {
            return EMPTY_STRING;
        }
        return this.encodingCombo.getText();
    }

    Properties collectCustomProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.setProperty("FILELIST", this.getFolderLocation());
        props.setProperty("SCHEMAFILELIST", this.getSchemaFileLocation());
        props.setProperty("ENCODINGLIST", this.getEncoding());
        return props;
    }

    void initCustomControl(Properties profileProps) {
        if (profileProps == null || profileProps.isEmpty() || this.m_folderLocation == null) {
            return;
        }
        String folderPath = profileProps.getProperty("FILELIST");
        if (folderPath == null) {
            folderPath = EMPTY_STRING;
        }
        this.m_folderLocation.setText(folderPath);
        String encoding = profileProps.getProperty("ENCODINGLIST");
        if (encoding == null) {
            this.encodingCombo.select(0);
        } else {
            this.encodingCombo.select(this.getIndex(encoding));
        }
        this.setFolderLocation(folderPath);
        String schemaPath = profileProps.getProperty("SCHEMAFILELIST");
        if (schemaPath == null) {
            schemaPath = EMPTY_STRING;
        }
        this.setSchemaLocation(schemaPath);
    }

    private int getIndex(String encoding) {
        return Arrays.binarySearch(this.encodingCombo.getItems(), encoding);
    }

    private void setupEncodingControl(Composite composite) {
        GridData data = new GridData(768);
        this.encodingCombo = new Combo(composite, 8);
        this.encodingCombo.setLayoutData((Object)data);
        this.encodingCombo.add(AUTO_ENCODING);
        Iterator<String> i = Charset.availableCharsets().keySet().iterator();
        while (i.hasNext()) {
            String encoding = i.next();
            this.encodingCombo.add(encoding);
        }
        this.encodingCombo.select(0);
    }

    private void setupXMLFolderLocation(Composite composite) {
        GridData data = new GridData(768);
        this.m_folderLocation = new Text(composite, 2048);
        this.m_folderLocation.setLayoutData((Object)data);
        this.browseFolderButton = new Button(composite, 0);
        this.browseFolderButton.setText(Messages.getString("file.choose"));
        this.browseFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedLocation;
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
                String folderLocationValue = XMLSelectionPageHelper.this.getFolderLocationString();
                if (folderLocationValue != null && folderLocationValue.trim().length() > 0) {
                    dialog.setFilterPath(folderLocationValue);
                }
                if ((selectedLocation = dialog.open()) != null) {
                    XMLSelectionPageHelper.this.setFolderLocation(selectedLocation);
                }
            }
        });
    }

    private void setupSchemaFolderLocation(Composite composite) {
        GridData data = new GridData(768);
        this.m_schemaLocation = new Text(composite, 2048);
        this.m_schemaLocation.setLayoutData((Object)data);
        this.browseFolderButton = new Button(composite, 0);
        this.browseFolderButton.setText(Messages.getString("file.choose"));
        this.browseFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedLocation;
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.xsd", "*.*"});
                String schemaLocationValue = XMLSelectionPageHelper.this.getSchemaLocationString();
                if (schemaLocationValue != null && schemaLocationValue.trim().length() > 0) {
                    dialog.setFilterPath(schemaLocationValue);
                }
                if ((selectedLocation = dialog.open()) != null) {
                    XMLSelectionPageHelper.this.setSchemaLocation(selectedLocation);
                }
            }
        });
    }

    private void setFolderLocation(String text) {
        this.m_folderLocation.setText(TextProcessorWrapper.process((String)text));
    }

    private String getFolderLocationString() {
        return TextProcessorWrapper.deprocess((String)this.m_folderLocation.getText());
    }

    private void setSchemaLocation(String text) {
        this.m_schemaLocation.setText(TextProcessorWrapper.process((String)text));
    }

    private String getSchemaLocationString() {
        return TextProcessorWrapper.deprocess((String)this.m_schemaLocation.getText());
    }

    private void setMessage(String message) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(message);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setMessage(message);
        }
    }

    private Control getControl() {
        if (this.m_wizardPage != null) {
            return this.m_wizardPage.getControl();
        }
        if (!$assertionsDisabled && this.m_propertyPage == null) {
            throw new AssertionError();
        }
        return this.m_propertyPage.getControl();
    }
}

