/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.ws.impl.DataSetMetaData;
import org.eclipse.datatools.enablement.oda.ws.impl.Query;
import org.eclipse.datatools.enablement.oda.ws.util.Java2SOAPManager;
import org.eclipse.datatools.enablement.oda.ws.util.RawMessageSender;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;

public class Connection
implements IConnection {
    private boolean m_isOpen = false;
    private RawMessageSender rawMessageSender;
    private Properties connProperties;
    private Java2SOAPManager java2SOAPManager;
    private boolean isCustom = false;

    public void open(Properties connProperties) throws OdaException {
        try {
            this.ping(connProperties);
        }
        catch (Exception e) {
            throw new OdaException();
        }
        this.connProperties = connProperties;
        boolean bl = this.isCustom = !WSUtil.isNull(connProperties.getProperty("connectionClass"));
        if (this.isCustom) {
            this.java2SOAPManager = new Java2SOAPManager();
            this.java2SOAPManager.setConnectionProperties(connProperties);
        } else {
            this.rawMessageSender = new RawMessageSender();
        }
        this.m_isOpen = true;
    }

    private void ping(Properties connProperties) throws OdaException, MalformedURLException, IOException {
        if (WSUtil.isNull(connProperties.getProperty("wsdlURI")) && WSUtil.isNull(connProperties.getProperty("soapEndPoint")) && WSUtil.isNull(connProperties.getProperty("connectionClass"))) {
            throw new OdaException();
        }
        this.pingURL(connProperties.getProperty("wsdlURI"));
    }

    private void pingURL(String spec) throws MalformedURLException, IOException {
        if (!WSUtil.isNull(spec) && !new File(spec).exists()) {
            new URL(spec).openStream();
        }
    }

    public void setAppContext(Object context) throws OdaException {
        if (this.isCustom && context instanceof Map) {
            this.java2SOAPManager.setAppConext((Map)context);
        }
    }

    public void close() throws OdaException {
        this.m_isOpen = false;
        if (this.isCustom) {
            this.java2SOAPManager = null;
        } else {
            this.rawMessageSender = null;
        }
    }

    public boolean isOpen() throws OdaException {
        return this.m_isOpen;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        if (this.isCustom) {
            return this.byCustom();
        }
        return new Query(this.rawMessageSender, this.connProperties);
    }

    private IQuery byCustom() throws OdaException {
        try {
            this.java2SOAPManager.newQuery(this.connProperties.getProperty("connectionClass"));
        }
        catch (Exception e) {
            throw new OdaException((Throwable)e);
        }
        return new Query(this.java2SOAPManager);
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public void commit() throws OdaException {
    }

    public void rollback() throws OdaException {
    }
}

