/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.ui.wizards;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSConsole;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSUIUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.ColumnMappingPage;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.XMLDataPreviewDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;

public class XMLColumnMappingPage
extends ColumnMappingPage {
    public XMLColumnMappingPage(String pageName) {
        super(pageName);
    }

    public void createPageCustomControl(Composite parent) {
        this.initWSConsole();
        super.createPageCustomControl(parent);
    }

    protected SelectionAdapter getPreviewButtonAdapter() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    String sampleXMLFile = WSConsole.getInstance().getPropertyValue("xmlFileURI");
                    if (sampleXMLFile != null && sampleXMLFile.trim().length() > 0) {
                        WSConsole.getInstance().setXMLPropertyValue("XML_FILE", sampleXMLFile);
                    } else {
                        WSConsole.getInstance().createSampleXMLFile();
                    }
                }
                catch (Exception exception) {}
                XMLDataPreviewDialog previewDialog = new XMLDataPreviewDialog(XMLColumnMappingPage.this.getShell());
                if (previewDialog.open() == 12) {
                    previewDialog.close();
                }
            }
        };
    }

    private void initWSConsole() {
        if (!WSConsole.getInstance().isSessionOK()) {
            WSConsole.getInstance().start(this.getInitializationDesign());
        }
    }

    protected void updateDesign(DataSetDesign dataSetDesign) {
        WSUIUtil.savePage(dataSetDesign);
    }

    protected String getQueryText(DataSetDesign dataSetDesign) {
        return WSUIUtil.getNonNullString((String)dataSetDesign.getPrivateProperties().findProperty("xmlQueryText").getValue());
    }

    protected void setQueryText(DataSetDesign dataSetDesign, String queryText) {
        dataSetDesign.getPrivateProperties().setProperty("xmlQueryText", queryText);
        WSConsole.getInstance().setPropertyValue("xmlQueryText", queryText);
    }

    public void refresh() {
        this.updateXMLFileURI();
        super.refresh();
    }

    private void updateXMLFileURI() {
        try {
            WSConsole.getInstance().updateXMLFileURI();
        }
        catch (OdaException e) {
            this.setMessage(e.getMessage(), 3);
        }
    }

    protected void cleanup() {
        WSConsole.getInstance().terminateSession();
    }
}

