/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.ui.wizards;

import java.awt.Toolkit;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.enablement.oda.ws.ui.Activator;
import org.eclipse.datatools.enablement.oda.ws.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.ws.ui.util.Constants;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSConsole;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSUIUtil;
import org.eclipse.datatools.enablement.oda.ws.ui.wizards.SOAPParametersPage;
import org.eclipse.datatools.enablement.oda.ws.util.WSDLAdvisor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class OperationPage
extends DataSetWizardPage {
    private transient Tree operationTree;
    private transient Label operationName;
    private transient Label operationDescription;
    private String operationTrace = "";
    private String initOperationTrace = "";
    private String wsdlURI = "";
    private String wsQuery = "";
    private Image wsdlImage;
    private Image serviceImage;
    private Image portImage;
    private Image operationImage;
    private static String DEFAULT_MESSAGE = Messages.getString("operationPage.message.default");

    public OperationPage(String pageName) {
        super(pageName);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        this.initialImages();
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
        int x = Toolkit.getDefaultToolkit().getScreenSize().width - 800;
        int y = Toolkit.getDefaultToolkit().getScreenSize().height - 700;
        if (this.getShell() != null) {
            this.getShell().setLocation(x / 2, y / 2);
        } else {
            parent.getShell().setLocation(x / 2, y / 2);
        }
    }

    private void initialImages() {
        this.wsdlImage = Activator.getDefault().getImageRegistry().get("iconWSDL");
        this.serviceImage = Activator.getDefault().getImageRegistry().get("iconService");
        this.portImage = Activator.getDefault().getImageRegistry().get("iconPort");
        this.operationImage = Activator.getDefault().getImageRegistry().get("iconOpeartion");
    }

    private Control createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 30;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(272);
        composite.setLayoutData((Object)layoutData);
        this.setupTreeComposite(composite);
        this.setupTextComposite(composite);
        return composite;
    }

    private void setupTreeComposite(Composite parent) {
        this.operationTree = new Tree(parent, 2820);
        this.operationTree.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 200;
        this.operationTree.setLayoutData((Object)layoutData);
        this.operationTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                this.handle();
            }

            private void handle() {
                TreeItem item = OperationPage.this.operationTree.getSelection()[0];
                if (item.getData() instanceof Operation) {
                    Operation operation = (Operation)item.getData();
                    OperationPage.this.operationTrace = OperationPage.this.toOperationTrace(item);
                    OperationPage.this.operationName.setText(WSUIUtil.getNonNullString((String)operation.getName()));
                    OperationPage.this.operationDescription.setText(WSDLAdvisor.retrieveDocument((Operation)operation));
                    OperationPage.this.setPageComplete(true);
                } else {
                    OperationPage.this.operationName.setText("");
                    OperationPage.this.operationDescription.setText("");
                    OperationPage.this.setPageComplete(false);
                }
            }
        });
    }

    private String toOperationTrace(TreeItem item) {
        Service service = (Service)item.getParentItem().getParentItem().getData();
        Port port = (Port)item.getParentItem().getData();
        Operation operation = (Operation)item.getData();
        return String.valueOf(service.getQName().getLocalPart()) + Constants.DELIMITER_OPEARTION + port.getName() + Constants.DELIMITER_OPEARTION + operation.getName();
    }

    private void setupTextComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 30;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(272);
        composite.setLayoutData((Object)layoutData);
        Label label = new Label(composite, 0);
        layoutData = new GridData();
        layoutData.widthHint = 100;
        label.setLayoutData((Object)layoutData);
        label.setText(Messages.getString("operationPage.label.selectOpearation"));
        this.operationName = new Label(composite, 2048);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.operationName.setLayoutData((Object)layoutData);
        label = new Label(composite, 0);
        layoutData = new GridData();
        layoutData.widthHint = 100;
        label.setLayoutData((Object)layoutData);
        label.setText(Messages.getString("operationPage.label.document"));
        this.operationDescription = new Label(composite, 2816);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        layoutData.heightHint = 40;
        this.operationDescription.setLayoutData((Object)layoutData);
    }

    private void initializeControl() {
        this.initWSConsole();
        this.initFromModel();
        this.populateTree();
        this.setPageComplete(false);
    }

    private void initWSConsole() {
        if (!WSConsole.getInstance().isSessionOK()) {
            WSConsole.getInstance().start(this.getInitializationDesign());
        }
    }

    private void initFromModel() {
        this.wsdlURI = WSConsole.getInstance().getPropertyValue("wsdlURI");
        this.operationTrace = WSConsole.getInstance().getPropertyValue("operationTrace");
        this.initOperationTrace = WSConsole.getInstance().getPropertyValue("operationTrace");
    }

    private void populateTree() {
        if (WSUIUtil.isNull((Object)this.wsdlURI)) {
            return;
        }
        this.operationTree.removeAll();
        TreeItem root = new TreeItem(this.operationTree, 0);
        root.setText(this.wsdlURI);
        root.setImage(this.wsdlImage);
        Definition definition = WSDLAdvisor.getDefinition((String)this.wsdlURI);
        if (definition == null) {
            return;
        }
        Map services = definition.getServices();
        Iterator srcIT = services.keySet().iterator();
        while (srcIT.hasNext()) {
            Service service = (Service)services.get(srcIT.next());
            TreeItem srcTI = this.populateTreeItem(root, service, service.getQName().getLocalPart(), this.serviceImage);
            Map ports = service.getPorts();
            Iterator prtIT = ports.keySet().iterator();
            while (prtIT.hasNext()) {
                Port port = (Port)ports.get(prtIT.next());
                TreeItem prtTI = this.populateTreeItem(srcTI, port, port.getName(), this.portImage);
                List operations = port.getBinding().getPortType().getOperations();
                int i = 0;
                while (i < operations.size()) {
                    TreeItem treeItem = this.populateTreeItem(prtTI, operations.get(i), ((Operation)operations.get(i)).getName(), this.operationImage);
                    if (!WSUIUtil.isNull((Object)this.operationTrace) && this.operationTrace.equals(this.toOperationTrace(treeItem))) {
                        this.highlight(treeItem);
                    }
                    ++i;
                }
            }
        }
    }

    private TreeItem populateTreeItem(TreeItem parent, Object child, String text, Image image) {
        TreeItem item = new TreeItem(parent, 0);
        item.setData(child);
        item.setText(text);
        item.setImage(image);
        return item;
    }

    private void highlight(TreeItem treeItem) {
        if (WSUIUtil.isNull((Object)this.operationTrace)) {
            return;
        }
        FontData fontData = new FontData("", 8, 1);
        treeItem.setFont(new Font(null, fontData));
        this.operationTree.setSelection(new TreeItem[]{treeItem});
        this.operationTree.setFocus();
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        WSUIUtil.checkExisted(design);
        this.savePage(design);
        return design;
    }

    private void savePage(DataSetDesign design) {
        if (!WSConsole.getInstance().isSessionOK()) {
            return;
        }
        design.getPrivateProperties().setProperty("operationTrace", WSConsole.getInstance().getPropertyValue("operationTrace"));
    }

    protected void refresh(DataSetDesign dataSetDesign) {
        super.refresh(dataSetDesign);
        this.refresh();
    }

    private void refresh() {
        this.initFromModel();
        this.populateTree();
        this.setMessage(DEFAULT_MESSAGE);
    }

    protected boolean canLeave() {
        this.saveToModle();
        this.testDirty();
        return super.canLeave();
    }

    private void testDirty() {
        if (!WSUIUtil.isNull((Object)this.initOperationTrace) && !this.initOperationTrace.equals(this.operationTrace) && MessageDialog.openConfirm(null, (String)Messages.getString("operationPage.title.operationChanged"), (String)Messages.getString("operationPage.message.operationChanged"))) {
            this.regenerateTemplate();
            try {
                WSConsole.getInstance().createXMLTempFileURI();
            }
            catch (OdaException e) {
                this.setMessage(e.getMessage(), 3);
            }
        }
    }

    private void regenerateTemplate() {
        this.wsQuery = WSUIUtil.getNonNullString((String)WSConsole.getInstance().getTemplate());
        if (!WSUIUtil.isNull((Object)this.wsQuery)) {
            WSConsole.getInstance().setPropertyValue("wsQueryText", this.wsQuery);
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        this.saveToModle();
        IWizardPage page = super.getNextPage();
        if (page instanceof SOAPParametersPage) {
            ((SOAPParametersPage)page).refresh();
        }
        return page;
    }

    private void saveToModle() {
        WSConsole.getInstance().setPropertyValue("operationTrace", this.operationTrace);
    }

    protected void cleanup() {
        WSConsole.getInstance().terminateSession();
    }
}

