/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.mysql.ddl;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.IEngineeringCallBack;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.mysql.MysqlPlugin;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogTable;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.IdentitySpecifier;
import org.eclipse.datatools.modelbase.sql.schema.ReferentialActionType;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.tables.ActionGranularityType;
import org.eclipse.datatools.modelbase.sql.tables.ActionTimeType;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.CheckType;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class MySqlDdlBuilder {
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected static final String EMPTY_STRING = "";
    protected static final String DOT = ".";
    protected static final String SPACE = " ";
    protected static final String COMMA = ",";
    protected static final String QUOTE = "`";
    protected static final String TAB = "\t";
    protected static final String LEFT_PARENTHESIS = "(";
    protected static final String RIGHT_PARENTHESIS = ")";
    protected static final String DROP = "DROP";
    protected static final String CREATE = "CREATE";
    protected static final String ALTER = "ALTER";
    protected static final String ADD = "ADD";
    protected static final String DELETE = "DELETE";
    protected static final String UPDATE = "UPDATE";
    protected static final String CASCADE = "CASCADE";
    protected static final String CASCADED = "CASCADED";
    protected static final String CHANGE = "CHANGE";
    protected static final String COLUMN = "COLUMN";
    protected static final String LOCAL = "LOCAL";
    protected static final String OPTION = "OPTION";
    protected static final String RESTRICT = "RESTRICT";
    protected static final String NULL = "NULL";
    protected static final String NOT = "NOT";
    protected static final String DEFAULT = "DEFAULT";
    protected static final String SET = "SET";
    protected static final String TRIGGER = "TRIGGER";
    protected static final String TABLE = "TABLE";
    protected static final String VIEW = "VIEW";
    protected static final String INDEX = "INDEX";
    protected static final String PROCEDURE = "PROCEDURE";
    protected static final String CONSTRAINT = "CONSTRAINT";
    protected static final String UNIQUE = "UNIQUE";
    protected static final String CHECK = "CHECK";
    protected static final String ENGINE = "ENGINE";
    protected static final String ON = "ON";
    protected static final String FOREIGN_KEY = "FOREIGN KEY";
    protected static final String REFERENCES = "REFERENCES";
    protected static final String PRIMARY_KEY = "PRIMARY KEY";
    protected static final String DEFERRABLE = "DEFERRABLE";
    protected static final String DEFERRED = "DEFERRED";
    protected static final String INITIALLY = "INITIALLY";
    protected static final String ALIAS = "ALIAS";
    protected static final String AS = "AS";
    protected static final String FOR = "FOR";
    protected static final String LONG = "LONG";
    protected static final String BLOB = "BLOB";
    protected static final String DBCLOB = "DBCLOB";
    protected static final String CLOB = "CLOB";
    protected static final String VARCHAR = "VARCHAR";
    protected static final String WITH = "WITH";
    protected static final String COMPARISONS = "COMPARISONS";
    protected static final String DATALINK = "DATALINK";
    protected static final String VARGRAPHIC = "VARGRAPHIC";
    protected static final String AFTER = "AFTER";
    protected static final String BEFORE = "BEFORE";
    protected static final String INSTEAD_OF = "INSTEAD OF";
    protected static final String INSERT = "INSERT";
    protected static final String NO = "NO";
    protected static final String OF = "OF";
    protected static final String REFERENCING = "REFERENCING";
    protected static final String NEW = "NEW";
    protected static final String OLD = "OLD";
    protected static final String NEW_TABLE = "NEW_TABLE";
    protected static final String OLD_TABLE = "OLD_TABLE";
    protected static final String EACH = "EACH";
    protected static final String ROW = "ROW";
    protected static final String STATEMENT = "STATEMENT";
    protected static final String WHEN = "WHEN";
    protected static final String AUTO_INCREMENT = "AUTO_INCREMENT";
    private HashMap createMap = new HashMap();
    private HashMap dropMap = new HashMap();
    private IEngineeringCallBack callback = null;
    private IEngineeringCallBack dummyCallback = null;

    public void setEngineeringCallBack(IEngineeringCallBack callback) {
        this.callback = callback;
    }

    public IEngineeringCallBack getEngineeringCallBack() {
        if (this.callback != null) {
            return this.callback;
        }
        return this.getDummyEngineeringCallBack();
    }

    public void clearDrop() {
        this.dropMap.clear();
    }

    public void clearCreate() {
        this.createMap.clear();
    }

    private void setCreateDone(Object sqlObject) {
        this.createMap.put(sqlObject, sqlObject);
    }

    private boolean hasCreateDone(Object sqlObject) {
        return this.createMap.get(sqlObject) != null;
    }

    public String dropTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP TRIGGER " + this.getName(trigger, quoteIdentifiers, qualifyNames);
    }

    public String dropView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP VIEW " + this.getName((Table)view, quoteIdentifiers, qualifyNames);
    }

    public List dropTableConstraint(TableConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        ArrayList<String> statements = new ArrayList<String>();
        if (constraint instanceof PrimaryKey) {
            PrimaryKey pk = (PrimaryKey)constraint;
            if (this.isAutoInc((UniqueConstraint)pk)) {
                Column column = this.getAutoIncColumn(pk);
                String statement = "ALTER TABLE " + this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames) + SPACE + CHANGE + SPACE + COLUMN + SPACE + this.getName(column, quoteIdentifiers) + SPACE + this.getColumnString(column, quoteIdentifiers, false);
                statements.add(statement);
            }
            String statement = "ALTER TABLE " + this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames) + SPACE + DROP + SPACE + PRIMARY_KEY;
            statements.add(statement);
        } else if (constraint instanceof ForeignKey) {
            String statement = "ALTER TABLE " + this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames) + SPACE + DROP + SPACE + FOREIGN_KEY + SPACE + this.getName(constraint, quoteIdentifiers);
            statements.add(statement);
        }
        return statements;
    }

    private Column getAutoIncColumn(PrimaryKey pk) {
        Column c;
        Iterator it = pk.getMembers().iterator();
        if (it.hasNext() && (c = (Column)it.next()).getIdentitySpecifier() != null) {
            return c;
        }
        return null;
    }

    public String dropIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        Table table = index.getTable();
        return "ALTER TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + SPACE + DROP + SPACE + INDEX + SPACE + this.getName(index, quoteIdentifiers, qualifyNames);
    }

    public String dropTable(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP TABLE " + this.getName((Table)table, quoteIdentifiers, qualifyNames);
    }

    public String createTable(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean generatePk) {
        MySqlCatalogTable mySqlTable;
        String tableType;
        PrimaryKey pk = table.getPrimaryKey();
        boolean hasPK = false;
        if (pk != null && pk.getMembers() != null && !pk.getMembers().isEmpty()) {
            hasPK = true;
        }
        String statement = "CREATE TABLE " + this.getName((Table)table, quoteIdentifiers, qualifyNames) + SPACE + LEFT_PARENTHESIS + NEWLINE;
        Iterator it = table.getColumns().iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            statement = String.valueOf(statement) + TAB + this.getColumnString(column, quoteIdentifiers, generatePk);
            if (it.hasNext()) {
                statement = String.valueOf(statement) + COMMA;
            } else if (hasPK && generatePk) {
                statement = String.valueOf(statement) + COMMA;
            }
            statement = String.valueOf(statement) + NEWLINE;
        }
        if (hasPK && generatePk) {
            Column c;
            this.setCreateDone(pk);
            String pkStatement = "\tPRIMARY KEY (";
            ArrayList<Column> colList = new ArrayList<Column>();
            Iterator iter = pk.getMembers().iterator();
            while (iter.hasNext()) {
                c = (Column)iter.next();
                if (c.getIdentitySpecifier() == null) continue;
                colList.add(c);
            }
            iter = pk.getMembers().iterator();
            while (iter.hasNext()) {
                c = (Column)iter.next();
                if (c.getIdentitySpecifier() != null) continue;
                colList.add(c);
            }
            iter = colList.iterator();
            while (iter.hasNext()) {
                c = (Column)iter.next();
                String columnName = c.getName();
                pkStatement = quoteIdentifiers ? String.valueOf(pkStatement) + this.getQuotedString(columnName) : String.valueOf(pkStatement) + columnName;
                if (!iter.hasNext()) continue;
                pkStatement = String.valueOf(pkStatement) + COMMA;
            }
            pkStatement = String.valueOf(pkStatement) + RIGHT_PARENTHESIS + NEWLINE;
            statement = String.valueOf(statement) + pkStatement;
        }
        statement = String.valueOf(statement) + RIGHT_PARENTHESIS;
        if (table instanceof MySqlCatalogTable && (tableType = (mySqlTable = (MySqlCatalogTable)table).getTableType()) != null) {
            statement = String.valueOf(statement) + " ENGINE=" + tableType;
        }
        return statement;
    }

    public String alterTableAddColumn(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        Table table = column.getTable();
        if (table instanceof BaseTable) {
            String statement = "ALTER TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + ADD + SPACE + COLUMN + this.getColumnString(column, quoteIdentifiers);
            return statement;
        }
        return null;
    }

    public String createView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames) {
        String viewDefinition = "CREATE ";
        viewDefinition = String.valueOf(viewDefinition) + "VIEW " + this.getName((Table)view, quoteIdentifiers, qualifyNames) + SPACE;
        String columns = this.getViewColumnList(view);
        if (columns != null) {
            viewDefinition = String.valueOf(viewDefinition) + LEFT_PARENTHESIS + columns + RIGHT_PARENTHESIS + SPACE;
        }
        viewDefinition = String.valueOf(viewDefinition) + AS + NEWLINE;
        viewDefinition = String.valueOf(viewDefinition) + view.getQueryExpression().getSQL();
        CheckType checkType = view.getCheckType();
        if (checkType == CheckType.CASCADED_LITERAL) {
            viewDefinition = String.valueOf(viewDefinition) + NEWLINE + WITH + SPACE + CASCADED + SPACE + CHECK + SPACE + OPTION;
        } else if (checkType == CheckType.LOCAL_LITERAL) {
            viewDefinition = String.valueOf(viewDefinition) + NEWLINE + WITH + SPACE + LOCAL + SPACE + CHECK + SPACE + OPTION;
        }
        return viewDefinition;
    }

    public String createIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE ";
        if (index.isUnique()) {
            statement = String.valueOf(statement) + "UNIQUE ";
        }
        statement = String.valueOf(statement) + "INDEX " + this.getName(index, quoteIdentifiers, false) + SPACE + ON + SPACE + this.getName(index.getTable(), quoteIdentifiers, qualifyNames) + SPACE + LEFT_PARENTHESIS + this.getIndexKeyColumns(index, quoteIdentifiers) + RIGHT_PARENTHESIS;
        return statement;
    }

    public String createTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE TRIGGER " + this.getName(trigger, quoteIdentifiers, qualifyNames) + SPACE;
        ActionTimeType actionTime = trigger.getActionTime();
        if (actionTime == ActionTimeType.AFTER_LITERAL) {
            statement = String.valueOf(statement) + AFTER;
        } else if (actionTime == ActionTimeType.BEFORE_LITERAL) {
            statement = String.valueOf(statement) + BEFORE;
        } else if (actionTime == ActionTimeType.INSTEADOF_LITERAL) {
            statement = String.valueOf(statement) + INSTEAD_OF;
        }
        statement = String.valueOf(statement) + SPACE;
        if (trigger.isDeleteType()) {
            statement = String.valueOf(statement) + DELETE;
        } else if (trigger.isInsertType()) {
            statement = String.valueOf(statement) + INSERT;
        } else if (trigger.isUpdateType()) {
            statement = String.valueOf(statement) + UPDATE;
            EList updateColumns = trigger.getTriggerColumn();
            if (!updateColumns.isEmpty()) {
                statement = String.valueOf(statement) + " OF ";
                Iterator it = updateColumns.iterator();
                while (it.hasNext()) {
                    Column column = (Column)it.next();
                    statement = String.valueOf(statement) + column.getName();
                    if (!it.hasNext()) continue;
                    statement = String.valueOf(statement) + ", ";
                }
            }
        }
        statement = String.valueOf(statement) + " ON " + this.getName(trigger.getSubjectTable(), quoteIdentifiers, qualifyNames) + NEWLINE;
        String newRow = trigger.getNewRow();
        String oldRow = trigger.getOldRow();
        if (newRow != null && newRow.length() != 0) {
            statement = String.valueOf(statement) + "REFERENCING NEW AS " + newRow + NEWLINE;
        }
        if (oldRow != null && oldRow.length() != 0) {
            statement = String.valueOf(statement) + "REFERENCING OLD AS " + oldRow + NEWLINE;
        }
        statement = trigger.getActionGranularity() == ActionGranularityType.ROW_LITERAL ? String.valueOf(statement) + "FOR EACH ROW" : String.valueOf(statement) + "FOR EACH STATEMENT";
        Iterator it = trigger.getActionStatement().iterator();
        while (it.hasNext()) {
            SQLStatement s = (SQLStatement)it.next();
            statement = String.valueOf(statement) + s.getSQL();
        }
        return statement;
    }

    public String addCheckConstraint(CheckConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        return "ALTER TABLE " + this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames) + SPACE + this.getAddCheckConstraintClause(constraint, quoteIdentifiers);
    }

    private boolean isAutoInc(UniqueConstraint constraint) {
        Column c;
        Iterator it = constraint.getMembers().iterator();
        return it.hasNext() && (c = (Column)it.next()).getIdentitySpecifier() != null;
    }

    public String addUniqueConstraint(UniqueConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        if (this.hasCreateDone(constraint)) {
            return null;
        }
        if (this.isAutoInc(constraint)) {
            return null;
        }
        return "ALTER TABLE " + this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames) + SPACE + ADD + SPACE + this.getUniqueConstraintType(constraint) + SPACE + LEFT_PARENTHESIS + this.getKeyColumns((ReferenceConstraint)constraint, quoteIdentifiers) + RIGHT_PARENTHESIS;
    }

    public String addForeignKey(ForeignKey foreignKey, boolean quoteIdentifiers, boolean qualifyNames) {
        UniqueConstraint uniqueConstraint = foreignKey.getUniqueConstraint();
        Index index = foreignKey.getUniqueIndex();
        BaseTable parentTable = null;
        String parentKey = null;
        if (uniqueConstraint != null) {
            parentTable = uniqueConstraint.getBaseTable();
            parentKey = this.getKeyColumns((ReferenceConstraint)uniqueConstraint, quoteIdentifiers);
        } else if (index != null) {
            parentTable = index.getTable();
            parentKey = this.getParentKeyColumns(index, quoteIdentifiers);
        }
        if (parentTable == null) {
            MysqlPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.rdb.mysql", 0, "Could not generate a foreignKey constraint for table " + foreignKey.getBaseTable(), new Throwable("No Index or Primary Key on referenced table")));
            return null;
        }
        String statement = "ALTER TABLE " + this.getName((Table)foreignKey.getBaseTable(), quoteIdentifiers, qualifyNames) + SPACE + ADD + SPACE + CONSTRAINT + SPACE + this.getName((TableConstraint)foreignKey, quoteIdentifiers) + SPACE + FOREIGN_KEY + SPACE + LEFT_PARENTHESIS + this.getKeyColumns((ReferenceConstraint)foreignKey, quoteIdentifiers) + RIGHT_PARENTHESIS + NEWLINE;
        statement = String.valueOf(statement) + "\tREFERENCES " + this.getName((Table)parentTable, quoteIdentifiers, qualifyNames) + SPACE + LEFT_PARENTHESIS + parentKey + RIGHT_PARENTHESIS;
        ReferentialActionType action = foreignKey.getOnDelete();
        if (action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + TAB + ON + SPACE + DELETE + SPACE;
        }
        statement = String.valueOf(statement) + this.getReferentialAction(action);
        action = foreignKey.getOnUpdate();
        if (action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + TAB + ON + SPACE + UPDATE + SPACE;
        }
        statement = String.valueOf(statement) + this.getReferentialAction(action);
        if (foreignKey.isDeferrable()) {
            statement = String.valueOf(statement) + NEWLINE + TAB + this.getDeferrableClause((Constraint)foreignKey);
        }
        return statement;
    }

    protected String getDeferrableClause(Constraint constraint) {
        String clause = null;
        if (constraint.isDeferrable()) {
            clause = DEFERRABLE;
            if (constraint.isInitiallyDeferred()) {
                clause = String.valueOf(clause) + " INITIALLY DEFERRED";
            }
        }
        return clause;
    }

    protected String getReferentialAction(ReferentialActionType action) {
        if (action == ReferentialActionType.CASCADE_LITERAL) {
            return CASCADE;
        }
        if (action == ReferentialActionType.RESTRICT_LITERAL) {
            return RESTRICT;
        }
        if (action == ReferentialActionType.SET_DEFAULT_LITERAL) {
            return "SET DEFAULT";
        }
        if (action == ReferentialActionType.SET_NULL_LITERAL) {
            return "SET NULL";
        }
        return EMPTY_STRING;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getViewColumnList(ViewTable view) {
        String columns = null;
        Iterator it = view.getColumns().iterator();
        if (!it.hasNext()) return null;
        Column c = (Column)it.next();
        columns = c.getName();
        while (it.hasNext()) {
            c = (Column)it.next();
            columns = String.valueOf(columns) + ", " + c.getName();
        }
        return columns;
    }

    protected String getColumnString(Column column, boolean quoteIdentifiers) {
        return this.getColumnString(column, quoteIdentifiers, true);
    }

    protected String getColumnString(Column column, boolean quoteIdentifiers, boolean includeAutoInc) {
        IdentitySpecifier specifier;
        String sql;
        ValueExpression exp = column.getGenerateExpression();
        if (exp != null && (sql = exp.getSQL()) != null) {
            return sql;
        }
        String columnName = column.getName();
        if (quoteIdentifiers) {
            columnName = this.getQuotedString(columnName);
        }
        String dataType = this.getDataTypeString((TypedElement)column, null);
        String columnString = String.valueOf(columnName) + SPACE + dataType;
        String defaultValue = column.getDefaultValue();
        if (defaultValue != null) {
            if (dataType.equals("DATETIME") || dataType.equals("TIME") || dataType.equals("DATE") || dataType.equals("TIMESTAMP")) {
                defaultValue = "'" + defaultValue.trim() + "'";
            }
            if (defaultValue.equals(EMPTY_STRING)) {
                defaultValue = "''";
            }
            columnString = String.valueOf(columnString) + SPACE + DEFAULT + SPACE + defaultValue;
        }
        if (!column.isNullable()) {
            columnString = String.valueOf(columnString) + SPACE + NOT + SPACE + NULL;
        }
        if (includeAutoInc && (specifier = column.getIdentitySpecifier()) != null) {
            columnString = String.valueOf(columnString) + " AUTO_INCREMENT";
        }
        return columnString;
    }

    protected String getUniqueConstraintType(UniqueConstraint constraint) {
        if (constraint instanceof PrimaryKey) {
            return PRIMARY_KEY;
        }
        return UNIQUE;
    }

    protected String getAddCheckConstraintClause(CheckConstraint constraint, boolean quoteIdentifiers) {
        String constraintName = this.getName((TableConstraint)constraint, quoteIdentifiers);
        String text = "ADD CONSTRAINT " + constraintName + SPACE + CHECK + SPACE + LEFT_PARENTHESIS + constraint.getSearchCondition().getSQL() + RIGHT_PARENTHESIS;
        if (constraint.isDeferrable()) {
            text = String.valueOf(text) + SPACE + this.getDeferrableClause((Constraint)constraint);
        }
        return text;
    }

    protected String getKeyColumns(ReferenceConstraint constraint, boolean quoteIdentifiers) {
        String name;
        Column c;
        String columns = null;
        Iterator it = constraint.getMembers().iterator();
        if (it.hasNext()) {
            c = (Column)it.next();
            name = c.getName();
            if (quoteIdentifiers) {
                name = this.getQuotedString(name);
            }
            columns = name;
        }
        while (it.hasNext()) {
            c = (Column)it.next();
            name = c.getName();
            if (quoteIdentifiers) {
                name = this.getQuotedString(name);
            }
            columns = String.valueOf(columns) + ", " + name;
        }
        return columns;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getIndexKeyColumns(Index index, boolean quoteIdentifiers) {
        Iterator it = index.getMembers().iterator();
        if (!it.hasNext()) {
            MysqlPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.rdb.mysql", 0, "No column found for index " + index.getName(), new Throwable("Index has no columns")));
            return null;
        }
        IndexMember m = (IndexMember)it.next();
        String columnName = m.getColumn().getName();
        if (quoteIdentifiers) {
            columnName = this.getQuotedString(columnName);
        }
        String columns = String.valueOf(columnName) + SPACE + m.getIncrementType().getName();
        while (it.hasNext()) {
            m = (IndexMember)it.next();
            columnName = m.getColumn().getName();
            if (quoteIdentifiers) {
                columnName = this.getQuotedString(columnName);
            }
            columns = String.valueOf(columns) + ", ";
            columns = String.valueOf(columns) + columnName + SPACE + m.getIncrementType().getName();
        }
        return columns;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getParentKeyColumns(Index index, boolean quoteIdentifiers) {
        Iterator it = index.getMembers().iterator();
        if (!it.hasNext()) {
            MysqlPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.rdb.mysql", 0, "No column found for index " + index.getName(), new Throwable("Index has no columns")));
            return null;
        }
        IndexMember m = (IndexMember)it.next();
        String columnName = m.getColumn().getName();
        if (quoteIdentifiers) {
            columnName = this.getQuotedString(columnName);
        }
        String columns = columnName;
        while (it.hasNext()) {
            m = (IndexMember)it.next();
            columnName = m.getColumn().getName();
            if (quoteIdentifiers) {
                columnName = this.getQuotedString(columnName);
            }
            columns = String.valueOf(columns) + ", " + columnName;
        }
        return columns;
    }

    protected String getDataTypeString(TypedElement typedElement, Schema schema) {
        SQLDataType containedType = typedElement.getContainedType();
        if (containedType != null) {
            EObject root;
            if (containedType instanceof PredefinedDataType && (root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)typedElement)) instanceof Database) {
                DatabaseDefinition def = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition((Database)root);
                return def.getPredefinedDataTypeFormattedName((PredefinedDataType)containedType);
            }
        } else {
            UserDefinedType referencedType = typedElement.getReferencedType();
            if (referencedType != null) {
                if (referencedType.getSchema() != schema) {
                    return this.getName(referencedType, false, true);
                }
                return referencedType.getName();
            }
        }
        return null;
    }

    protected String getName(TableConstraint constraint, boolean quoteIdentifiers) {
        String name = constraint.getName();
        if (quoteIdentifiers) {
            name = this.getQuotedString(name);
        }
        return name;
    }

    protected String getName(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = trigger.getName();
        String dbName = null;
        if (quoteIdentifiers) {
            name = this.getQuotedString(name);
            if (qualifyNames) {
                dbName = trigger.getSchema().getDatabase().getName();
                name = String.valueOf(dbName) + DOT + name;
                dbName = this.getQuotedString(dbName);
            }
        }
        return name;
    }

    protected String getName(Routine routine, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = routine.getName();
        String dbName = null;
        if (quoteIdentifiers) {
            name = this.getQuotedString(name);
            if (qualifyNames) {
                dbName = routine.getSchema().getDatabase().getName();
                dbName = this.getQuotedString(dbName);
                name = String.valueOf(dbName) + DOT + name;
            }
        }
        return name;
    }

    protected String getName(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        String indexName = index.getName();
        String dbName = null;
        if (quoteIdentifiers) {
            indexName = this.getQuotedString(indexName);
            if (qualifyNames) {
                dbName = index.getSchema().getDatabase().getName();
                dbName = this.getQuotedString(dbName);
                indexName = String.valueOf(dbName) + DOT + indexName;
            }
        }
        return indexName;
    }

    protected String getName(Column column, boolean quoteIdentifiers) {
        String columnName = column.getName();
        if (quoteIdentifiers) {
            columnName = this.getQuotedString(columnName);
        }
        return columnName;
    }

    protected String getName(Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        String tableName = table.getName();
        String dbName = null;
        if (quoteIdentifiers) {
            tableName = this.getQuotedString(tableName);
            if (qualifyNames) {
                dbName = table.getSchema().getDatabase().getName();
                dbName = this.getQuotedString(dbName);
                tableName = String.valueOf(dbName) + DOT + tableName;
            }
        }
        return tableName;
    }

    protected String getName(Sequence sequence, boolean quoteIdentifiers, boolean qualifyNames) {
        String sequenceName = sequence.getName();
        String dbName = null;
        if (quoteIdentifiers) {
            sequenceName = this.getQuotedString(sequenceName);
            if (qualifyNames) {
                dbName = sequence.getSchema().getDatabase().getName();
                dbName = this.getQuotedString(dbName);
                sequenceName = String.valueOf(dbName) + DOT + sequenceName;
            }
        }
        return sequenceName;
    }

    protected String getName(UserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        String typeName = type.getName();
        String dbName = null;
        if (quoteIdentifiers) {
            typeName = this.getQuotedString(typeName);
            if (qualifyNames) {
                dbName = type.getSchema().getDatabase().getName();
                dbName = this.getQuotedString(dbName);
                typeName = String.valueOf(dbName) + DOT + typeName;
            }
        }
        return typeName;
    }

    protected String getQuotedString(String orignal) {
        StringTokenizer tokenizer = new StringTokenizer(orignal, QUOTE);
        String result = null;
        if (tokenizer.countTokens() > 1) {
            if (tokenizer.hasMoreTokens()) {
                result = tokenizer.nextToken();
            }
            while (tokenizer.hasMoreTokens()) {
                result = String.valueOf(result) + QUOTE + QUOTE + tokenizer.nextToken();
            }
        } else if (tokenizer.hasMoreTokens()) {
            result = tokenizer.nextToken();
        }
        return QUOTE + result + QUOTE;
    }

    private IEngineeringCallBack getDummyEngineeringCallBack() {
        if (this.dummyCallback == null) {
            this.dummyCallback = new dummyEngineeringCallBack();
        }
        return this.dummyCallback;
    }

    private class dummyEngineeringCallBack
    implements IEngineeringCallBack {
        private dummyEngineeringCallBack() {
        }

        public String[] getMessages() {
            return new String[0];
        }

        public void writeMessage(String message) {
        }
    }
}

