/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.jdt.dbunit.internal.util;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class DbUnitStubUtility {
    public static GenStubSettings getCodeGenerationSettings(IJavaProject project) {
        return new GenStubSettings(project);
    }

    public static String formatCompilationUnit(IJavaProject project, String sourceString, String lineDelim) {
        return DbUnitStubUtility.codeFormat(project, sourceString, 8, 0, lineDelim);
    }

    public static String codeFormat(IJavaProject project, String sourceString, int kind, int initialIndentationLevel, String lineDelim) {
        CodeFormatter formatter = ToolFactory.createCodeFormatter((Map)project.getOptions(true));
        TextEdit edit = formatter.format(kind, sourceString, 0, sourceString.length(), initialIndentationLevel, lineDelim);
        if (edit != null) {
            Document doc = new Document(sourceString);
            try {
                edit.apply((IDocument)doc);
                return doc.get();
            }
            catch (MalformedTreeException e) {
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        return sourceString;
    }

    public static String genStub(ICompilationUnit compilationUnit, String destTypeName, IMethod method, GenStubSettings settings, String extraAnnotations, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        return DbUnitStubUtility.genStub(compilationUnit, destTypeName, method, settings, extraAnnotations, imports, null);
    }

    public static String genStub(ICompilationUnit compilationUnit, String destTypeName, IMethod method, GenStubSettings settings, String extraAnnotations, NewTypeWizardPage.ImportsManager imports, String extraReturnClause) throws CoreException {
        int flags;
        IType declaringtype = method.getDeclaringType();
        StringBuffer buf = new StringBuffer();
        String[] paramTypes = method.getParameterTypes();
        String[] paramNames = method.getParameterNames();
        String[] excTypes = method.getExceptionTypes();
        String retTypeSig = method.getReturnType();
        int lastParam = paramTypes.length - 1;
        String comment = null;
        if (settings.createComments) {
            comment = method.isConstructor() ? CodeGeneration.getMethodComment((ICompilationUnit)compilationUnit, (String)destTypeName, (String)method.getElementName(), (String[])paramNames, (String[])excTypes, null, null, (String)"\n") : (settings.methodOverwrites ? CodeGeneration.getMethodComment((ICompilationUnit)compilationUnit, (String)destTypeName, (String)method.getElementName(), (String[])paramNames, (String[])excTypes, (String)retTypeSig, (IMethod)method, (String)"\n") : CodeGeneration.getMethodComment((ICompilationUnit)compilationUnit, (String)destTypeName, (String)method.getElementName(), (String[])paramNames, (String[])excTypes, (String)retTypeSig, null, (String)"\n"));
        }
        if (comment != null) {
            buf.append(comment).append('\n');
        }
        if (extraAnnotations != null) {
            buf.append(extraAnnotations).append('\n');
        }
        if (Flags.isPublic((int)(flags = method.getFlags())) || declaringtype.isInterface() && !settings.noBody) {
            buf.append("public ");
        } else if (Flags.isProtected((int)flags)) {
            buf.append("protected ");
        } else if (Flags.isPrivate((int)flags)) {
            buf.append("private ");
        }
        if (Flags.isSynchronized((int)flags)) {
            buf.append("synchronized ");
        }
        if (Flags.isVolatile((int)flags)) {
            buf.append("volatile ");
        }
        if (Flags.isStrictfp((int)flags)) {
            buf.append("strictfp ");
        }
        if (Flags.isStatic((int)flags)) {
            buf.append("static ");
        }
        if (method.isConstructor()) {
            buf.append(destTypeName);
        } else {
            String retTypeFrm = Signature.toString((String)retTypeSig);
            if (!DbUnitStubUtility.isBuiltInType(retTypeSig)) {
                DbUnitStubUtility.resolveAndAdd(retTypeSig, declaringtype, imports);
            }
            buf.append(Signature.getSimpleName((String)retTypeFrm));
            buf.append(' ');
            buf.append(method.getElementName());
        }
        buf.append('(');
        for (int i = 0; i <= lastParam; ++i) {
            String paramTypeSig = paramTypes[i];
            String paramTypeFrm = Signature.toString((String)paramTypeSig);
            if (!DbUnitStubUtility.isBuiltInType(paramTypeSig)) {
                DbUnitStubUtility.resolveAndAdd(paramTypeSig, declaringtype, imports);
            }
            buf.append(Signature.getSimpleName((String)paramTypeFrm));
            buf.append(' ');
            buf.append(paramNames[i]);
            if (i >= lastParam) continue;
            buf.append(", ");
        }
        buf.append(')');
        int lastExc = excTypes.length - 1;
        if (lastExc >= 0) {
            buf.append(" throws ");
            for (int i = 0; i <= lastExc; ++i) {
                String excTypeSig = excTypes[i];
                String excTypeFrm = Signature.toString((String)excTypeSig);
                DbUnitStubUtility.resolveAndAdd(excTypeSig, declaringtype, imports);
                buf.append(Signature.getSimpleName((String)excTypeFrm));
                if (i >= lastExc) continue;
                buf.append(", ");
            }
        }
        if (settings.noBody) {
            buf.append(";\n\n");
        } else {
            buf.append(" {\n\t");
            if (!settings.callSuper) {
                if (extraReturnClause != null) {
                    buf.append('\t');
                    buf.append(extraReturnClause);
                    buf.append("\n\t");
                } else if (retTypeSig != null && !retTypeSig.equals("V")) {
                    buf.append('\t');
                    if (!DbUnitStubUtility.isBuiltInType(retTypeSig) || Signature.getArrayCount((String)retTypeSig) > 0) {
                        buf.append("return null;\n\t");
                    } else if (retTypeSig.equals("Z")) {
                        buf.append("return false;\n\t");
                    } else {
                        buf.append("return 0;\n\t");
                    }
                }
            } else {
                buf.append('\t');
                if (!method.isConstructor()) {
                    if (extraReturnClause != null) {
                        buf.append('\t');
                        buf.append(extraReturnClause);
                        buf.append("\n\t");
                    } else {
                        if (!"V".equals(retTypeSig)) {
                            buf.append("return ");
                        }
                        buf.append("super.");
                        buf.append(method.getElementName());
                    }
                } else {
                    buf.append("super");
                }
                buf.append('(');
                for (int i = 0; i <= lastParam; ++i) {
                    buf.append(paramNames[i]);
                    if (i >= lastParam) continue;
                    buf.append(", ");
                }
                buf.append(");\n\t");
            }
            buf.append("}\n\n");
        }
        return buf.toString();
    }

    private static boolean isBuiltInType(String typeName) {
        char first = Signature.getElementType((String)typeName).charAt(0);
        return first != 'L' && first != 'Q';
    }

    private static void resolveAndAdd(String refTypeSig, IType declaringType, NewTypeWizardPage.ImportsManager imports) throws JavaModelException {
        String resolvedTypeName = JavaModelUtil.getResolvedTypeName((String)refTypeSig, (IType)declaringType);
        if (resolvedTypeName != null) {
            imports.addImport(resolvedTypeName);
        }
    }

    public static String getTodoTaskTag(IJavaProject project) {
        String markers = null;
        markers = project == null ? JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.taskTags") : project.getOption("org.eclipse.jdt.core.compiler.taskTags", true);
        if (markers != null && markers.length() > 0) {
            int idx = markers.indexOf(44);
            if (idx == -1) {
                return markers;
            }
            return markers.substring(0, idx);
        }
        return null;
    }

    public static boolean isVisible(IMember member, IPackageFragment pack) throws JavaModelException {
        int type = member.getElementType();
        if (type == 10 || type == 9 && member.getElementName().startsWith("<")) {
            return false;
        }
        int otherflags = member.getFlags();
        IType declaringType = member.getDeclaringType();
        if (Flags.isPublic((int)otherflags) || declaringType != null && declaringType.isInterface()) {
            return true;
        }
        if (Flags.isPrivate((int)otherflags)) {
            return false;
        }
        IPackageFragment otherpack = (IPackageFragment)member.getAncestor(4);
        return pack != null && otherpack != null && pack.getElementName().equals(otherpack.getElementName());
    }

    private static boolean isVersionLessThan(String version1, String version2) {
        return version1.compareTo(version2) < 0;
    }

    public static boolean is50OrHigher(IJavaProject project) {
        return !DbUnitStubUtility.isVersionLessThan(project.getOption("org.eclipse.jdt.core.compiler.compliance", true), "1.5");
    }

    public static String[] getParameterTypeNamesForSeeTag(IMethod overridden) {
        try {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setProject(overridden.getJavaProject());
            IBinding[] bindings = parser.createBindings(new IJavaElement[]{overridden}, null);
            if (bindings.length == 1 && bindings[0] instanceof IMethodBinding) {
                return DbUnitStubUtility.getParameterTypeNamesForSeeTag((IMethodBinding)bindings[0]);
            }
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        String[] paramTypes = overridden.getParameterTypes();
        String[] paramTypeNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypeNames[i] = Signature.toString((String)Signature.getTypeErasure((String)paramTypes[i]));
        }
        return paramTypeNames;
    }

    private static String[] getParameterTypeNamesForSeeTag(IMethodBinding binding) {
        ITypeBinding[] typeBindings = binding.getParameterTypes();
        String[] result = new String[typeBindings.length];
        for (int i = 0; i < result.length; ++i) {
            ITypeBinding curr = typeBindings[i];
            if (curr.isTypeVariable()) {
                curr = curr.getErasure();
            }
            curr = curr.getTypeDeclaration();
            result[i] = curr.getQualifiedName();
        }
        return result;
    }

    public static class GenStubSettings {
        public boolean callSuper;
        public boolean methodOverwrites;
        public boolean noBody;
        public boolean createComments;
        public boolean useKeywordThis;
        public final int tabWidth;

        public GenStubSettings(IJavaProject project) {
            this.createComments = Boolean.valueOf(PreferenceConstants.getPreference((String)"org.eclipse.jdt.ui.javadoc", (IJavaProject)project));
            this.useKeywordThis = Boolean.valueOf(PreferenceConstants.getPreference((String)"org.eclipse.jdt.ui.keywordthis", (IJavaProject)project));
            this.tabWidth = IndentManipulation.getTabWidth((Map)project.getOptions(true));
        }
    }
}

