/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath.BuildPathSupport;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.ui.DbUnitMessages;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class DbUnitContainerInitializer
extends ClasspathContainerInitializer {
    public static final String DBUNIT_CONTAINER_ID = "org.eclipse.datatools.enablement.jdt.dbunit.DBUNIT_CONTAINER";
    public static final String DBUNIT2 = "2.2";
    public static final String DBUNIT2_LIBS_DIR = "libs";
    public static final IPath DBUNIT2_PATH = new Path("org.eclipse.datatools.enablement.jdt.dbunit.DBUNIT_CONTAINER").append("libs").append("2.2");

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (DbUnitContainerInitializer.isValidDbUnitContainerPath(containerPath)) {
            IClasspathEntry entry = null;
            String version = containerPath.segment(1);
            if (DBUNIT2.equals(version)) {
                entry = BuildPathSupport.getDbUnit2LibraryEntry();
            }
            IClasspathEntry[] entries = entry != null ? new IClasspathEntry[]{entry} : new IClasspathEntry[]{};
            DbUnitContainer container = new DbUnitContainer(containerPath, entries);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    private static boolean isValidDbUnitContainerPath(IPath path) {
        return path != null && path.segmentCount() == 2 && DBUNIT_CONTAINER_ID.equals(path.segment(0));
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{containerSuggestion}, null);
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        String version;
        if (DbUnitContainerInitializer.isValidDbUnitContainerPath(containerPath) && DBUNIT2.equals(version = containerPath.segment(1))) {
            return DbUnitMessages.DbUnitContainerInitializer_description_dbunit2;
        }
        return DbUnitMessages.DbUnitContainerInitializer_description_initializer_unresolved;
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        return containerPath;
    }

    private static class DbUnitContainer
    implements IClasspathContainer {
        private final IClasspathEntry[] fEntries;
        private final IPath fPath;

        public DbUnitContainer(IPath path, IClasspathEntry[] entries) {
            this.fPath = path;
            this.fEntries = entries;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.fEntries;
        }

        public String getDescription() {
            return DbUnitMessages.DbUnitContainerInitializer_description_dbunit2;
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.fPath;
        }
    }
}

