/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.catalog.util.CatalogStatistics;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogColumn;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogPrivilege;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogView;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWCatalogMessages;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWIndex;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWTableSpace;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWIndexImpl;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Package;
import org.eclipse.datatools.enablement.ibm.util.ModelHelper;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.constraints.IncrementType;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsPackage;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogIndex
extends LUWIndexImpl
implements ICatalogObject,
IDatabaseObject {
    private static final String PROP_INDEX_MEMBERS = "PROP_INDEX_MEMBERS";
    private boolean memberLoaded = false;
    private boolean privilegeLoaded = false;
    private boolean statisticsLoaded = false;
    private boolean impactsLoaded = false;
    private boolean tablespaceLoaded = false;
    private IndexUniqueRule uniqueRule;
    private Collection impacts = new ArrayList();
    private Collection statistics = new ArrayList();

    public void refresh() {
        if (this.memberLoaded) {
            this.members.clear();
            this.memberLoaded = false;
        }
        this.privilegeLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getTable().getSchema().getDatabase();
    }

    public void refresh(int refreshType) {
        if (!false) {
            this.impacts.clear();
            this.impactsLoaded = false;
        }
        if ((1 & refreshType) == 1) {
            this.statistics.clear();
            this.statisticsLoaded = false;
        }
    }

    public EList getMembers() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getMembers();
        }
        if (!this.memberLoaded) {
            this.loadMembers();
        }
        return this.members;
    }

    public EList getIncludedMembers() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getIncludedMembers();
        }
        if (!this.memberLoaded) {
            this.loadMembers();
        }
        return this.includedMembers;
    }

    public EList getPrivileges() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getPrivileges();
        }
        if (!this.privilegeLoaded) {
            this.loadPrivileges();
        }
        return this.privileges;
    }

    public ICatalogObject[] getImpacted() {
        if (!this.impactsLoaded) {
            this.impacts = this.getImpactedObjects();
            this.impactsLoaded = true;
        }
        ICatalogObject[] objs = new ICatalogObject[this.impacts.size()];
        this.impacts.toArray(objs);
        return objs;
    }

    public Collection getStatistics() {
        if (!this.statisticsLoaded) {
            this.statistics = LUWCatalogIndex.getStatistics(this.getConnection(), (Index)this);
            this.statisticsLoaded = true;
        }
        return this.statistics;
    }

    public LUWTableSpace getTablespace() {
        if (!this.tablespaceLoaded) {
            this.loadTablespace();
        }
        return this.tablespace;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 13) {
            this.getMembers();
        } else if (id == 16) {
            this.getIncludedMembers();
        } else if (id == 7) {
            this.getPrivileges();
        }
        return super.eIsSet(eFeature);
    }

    private void loadMembers() {
        if (this.memberLoaded) {
            return;
        }
        this.memberLoaded = true;
        EList memberList = super.getMembers();
        EList includedMemberList = super.getIncludedMembers();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogIndex.loadMembers(this.getConnection(), memberList, includedMemberList, (Index)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadPrivileges() {
        if (this.privilegeLoaded) {
            return;
        }
        this.privilegeLoaded = true;
        EList privileges = super.getPrivileges();
        for (Privilege privilege : privileges) {
            privilege.setGrantor(null);
            privilege.setGrantee(null);
        }
        privileges.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogIndex.loadPrivileges(this.getConnection(), privileges, (Index)this, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadTablespace() {
        if (this.tablespaceLoaded) {
            return;
        }
        this.tablespaceLoaded = true;
        try {
            String version = this.getSchema().getDatabase().getVersion().substring(1);
            if ((double)Float.parseFloat(version) < 9.1) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        EList tablespaces = ((LUWDatabase)this.getCatalogDatabase()).getTablespaces();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogIndex.loadTablespace(this.getConnection(), tablespaces, (Index)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    protected static void loadMembers(Connection connection, EList members, EList includedMembers, Index index) throws SQLException {
        Schema schema = index.getSchema();
        ModelHelper.getDatabase((Schema)schema);
        String cfr_ignored_0 = String.valueOf(schema.getName()) + "." + index.getName();
        String query = "SELECT COLNAME, COLORDER, INDSCHEMA, INDNAME FROM SYSCAT.INDEXCOLUSE";
        query = String.valueOf(query) + " WHERE INDSCHEMA='" + LUWUtil.getIdentifier(index.getSchema().getName()) + "'" + " AND INDNAME='" + LUWUtil.getIdentifier(index.getName()) + "'";
        query = String.valueOf(query) + " ORDER BY";
        query = String.valueOf(query) + " COLSEQ";
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        MembersInfo info = null;
        try {
            while (r.next()) {
                String schemaName = r.getString("INDSCHEMA").trim();
                String indexName = r.getString("INDNAME").trim();
                if (info == null || !info.idxSchemaName.equals(schemaName) || !info.indexName.equals(indexName)) {
                    info = new MembersInfo();
                    info.idxSchemaName = schemaName;
                    info.indexName = indexName;
                }
                String colName = r.getString(1);
                String order = r.getString(2);
                info.addMember(colName, order);
            }
            if (info != null) {
                info.setMembers(index, (List<IndexMember>)members, (List<IndexMember>)includedMembers);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    public static void loadPrivileges(Connection connection, EList privilegeList, Index index, String granteeFilter) throws SQLException {
        Schema schema = index.getSchema();
        Database database = ModelHelper.getDatabase((Schema)schema);
        int options = ((LUWCatalogDatabase)database).getLoadOptions();
        if ((options & 0x800) == 2048) {
            return;
        }
        Statement s = connection.createStatement();
        String query = "SELECT GRANTOR,GRANTEE,GRANTEETYPE,CONTROLAUTH FROM SYSCAT.INDEXAUTH WHERE INDSCHEMA='" + LUWUtil.getIdentifier(schema.getName()) + "'" + " AND INDNAME='" + LUWUtil.getIdentifier(index.getName()) + "'";
        if (granteeFilter != null && !"".equals(granteeFilter)) {
            query = String.valueOf(query) + " AND " + granteeFilter;
        }
        ResultSet r = s.executeQuery(query);
        try {
            String userName = connection.getMetaData().getUserName();
            while (r.next()) {
                String grantorId = r.getString("GRANTOR").trim();
                AuthorizationIdentifier grantor = LUWCatalogDatabase.getAuthorizationId(database, grantorId, null);
                String granteeId = r.getString("GRANTEE").trim();
                AuthorizationIdentifier grantee = null;
                String granteeType = r.getString("GRANTEETYPE");
                grantee = "G".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "G") : ("R".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "R") : LUWCatalogDatabase.getAuthorizationId(database, granteeId, "U"));
                boolean isSystemGranted = granteeId.equalsIgnoreCase(userName);
                String alterAuth = r.getString("CONTROLAUTH");
                if (alterAuth.equals("N")) continue;
                LUWCatalogPrivilege privilege = new LUWCatalogPrivilege();
                privilege.setAction("CONTROL");
                privilegeList.add((Object)privilege);
                privilege.setGrantor(grantor);
                privilege.setGrantee(grantee);
                LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    public static void loadTablespace(Connection connection, EList tablespaceList, Index index) throws SQLException {
        LUWIndex luwindex = (LUWIndex)index;
        Statement s = connection.createStatement();
        String query = "SELECT T.TBSPACE FROM SYSIBM.SYSINDEXES I, SYSIBM.SYSTABLESPACES T WHERE I.NAME='" + LUWUtil.getIdentifier(luwindex.getName()) + "' AND I.CREATOR='" + luwindex.getTable().getSchema().getName().trim() + "' AND I.TBSPACEID=T.TBSPACEID";
        ResultSet r = s.executeQuery(query);
        try {
            block2: while (r.next()) {
                String tbspaceName = r.getString("TBSPACE");
                for (LUWTableSpace tbspace : tablespaceList) {
                    if (!tbspace.getName().equals(tbspaceName)) continue;
                    luwindex.setTablespace(tbspace);
                    tbspace.getIndexes().add((Object)luwindex);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    private DatabaseDefinition getDatabaseDefinition() {
        Database d = this.getSchema().getDatabase();
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(d);
    }

    private static Column getColumn(Index index, String columnName) {
        Column c;
        Table table = index.getTable();
        if (table instanceof LUWCatalogTable && (c = ((LUWCatalogTable)table).getColumn(columnName)) != null) {
            return c;
        }
        for (Column c2 : table.getColumns()) {
            if (!c2.getName().equals(columnName)) continue;
            return c2;
        }
        LUWCatalogColumn column = new LUWCatalogColumn();
        column.setName(columnName);
        column.setTable(table);
        Database database = table.getSchema().getDatabase();
        DatabaseDefinition def = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        CharacterStringDataType dataType = (CharacterStringDataType)def.getPredefinedDataType("Char");
        dataType.setLength(5);
        column.setContainedType((SQLDataType)dataType);
        return column;
    }

    private static IndexMember findIndexMember(Object[] list, String colName) {
        IndexMember member = null;
        int i = 0;
        while (i < list.length) {
            Column column = ((IndexMember)list[i]).getColumn();
            if (column.getName().equals(colName)) {
                member = (IndexMember)list[i];
                break;
            }
            ++i;
        }
        return member;
    }

    private Collection getImpactedObjects() {
        ArrayList impacts = new ArrayList();
        Connection connection = this.getConnection();
        impacts.addAll(LUWCatalogIndex.getImpactedTables(connection, (Index)this));
        impacts.addAll(LUWCatalogIndex.getImpactedConstraints(connection, (Index)this));
        impacts.addAll(LUWCatalogIndex.getImpactedPackages(connection, (Index)this));
        return impacts;
    }

    protected static Collection getImpactedTables(Connection connection, Index index) {
        ArrayList<Table> impacts = new ArrayList<Table>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT TABNAME,TABSCHEMA FROM SYSCAT.TABDEP where BTYPE='I' AND BNAME='" + LUWUtil.getIdentifier(index.getName()) + "'" + " AND BSCHEMA ='" + LUWUtil.getIdentifier(index.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String tabName = r.getString("TABNAME").trim();
                String schemaName = r.getString("TABSCHEMA").trim();
                Table t = LUWCatalogView.getTable(index.getTable(), schemaName, tabName);
                if (t == null) continue;
                impacts.add(t);
            }
            r.close();
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return impacts;
    }

    protected static Collection getImpactedConstraints(Connection connection, Index index) {
        ArrayList<TableConstraint> impacts = new ArrayList<TableConstraint>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT CONSTNAME,TABNAME,TABSCHEMA FROM SYSCAT.CONSTDEP WHERE BTYPE='I' AND BNAME='" + LUWUtil.getIdentifier(index.getName()) + "'" + " AND BSCHEMA='" + LUWUtil.getIdentifier(index.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String constName = r.getString("CONSTNAME").trim();
                String tabName = r.getString("TABNAME").trim();
                String schemaName = r.getString("TABSCHEMA").trim();
                TableConstraint constraint = LUWCatalogView.getTableConstraint(index.getTable(), schemaName, tabName, constName);
                if (constraint == null) continue;
                impacts.add(constraint);
            }
            r.close();
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return impacts;
    }

    protected static Collection getImpactedPackages(Connection connection, Index index) {
        ArrayList<DB2Package> impacts = new ArrayList<DB2Package>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT PKGNAME, PKGSCHEMA, HEX(UNIQUE_ID) AS UID FROM SYSCAT.PACKAGEDEP WHERE BTYPE = 'I' AND BNAME='" + LUWUtil.getIdentifier(index.getName()) + "'" + " AND BSCHEMA='" + LUWUtil.getIdentifier(index.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String pkgName = r.getString("PKGNAME").trim();
                String schemaName = r.getString("PKGSCHEMA").trim();
                String pkgUniqueID = r.getString("UID").trim();
                DB2Package pkg = LUWCatalogView.getDb2Package(index.getTable(), schemaName, pkgName, pkgUniqueID);
                if (pkg == null) continue;
                impacts.add(pkg);
            }
            r.close();
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return impacts;
    }

    public static Collection getStatistics(Connection connection, Index index) {
        ArrayList<CatalogStatistics> statistics = new ArrayList<CatalogStatistics>();
        try {
            DatabaseDefinition definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(index.getTable().getSchema().getDatabase());
            String version = definition.getVersion();
            float ver = 8.0f;
            try {
                ver = Float.parseFloat(version.substring(1));
            }
            catch (NumberFormatException numberFormatException) {}
            String query = "";
            query = ver < 9.0f ? "SELECT I.STATS_TIME,S.NLEAF, S.NLEVELS,S.FIRSTKEYCARD,S.FIRST2KEYCARD,S.FIRST3KEYCARD,S.FIRST4KEYCARD,S.FULLKEYCARD,S.CLUSTERRATIO,S.CLUSTERFACTOR,S.SEQUENTIAL_PAGES,S.DENSITY,S.PAGE_FETCH_PAIRS,S.NUMRIDS,S.NUMRIDS_DELETED,S.NUM_EMPTY_LEAFS,S.AVERAGE_RANDOM_FETCH_PAGES,S.AVERAGE_RANDOM_PAGES,S.AVERAGE_SEQUENCE_GAP,S.AVERAGE_SEQUENCE_FETCH_GAP,S.AVERAGE_SEQUENCE_PAGES,S.AVERAGE_SEQUENCE_FETCH_PAGES,-1 AS AVGPARTITION_CLUSTERRATIO, -1 AS AVGPARTITION_CLUSTERFACTOR, '' AS AVGPARTITION_PAGE_FETCH_PAIRS,-1 AS DATAPARTITION_CLUSTERFACTOR, -1 AS INDCARD FROM SYSSTAT.INDEXES S, SYSCAT.INDEXES I WHERE S.INDSCHEMA = I.INDSCHEMA AND S.INDNAME = I.INDNAME AND S.INDSCHEMA='" + LUWUtil.getIdentifier(index.getSchema().getName()) + "'" + " AND S.INDNAME='" + LUWUtil.getIdentifier(index.getName()) + "'" + " FOR FETCH ONLY" : "SELECT I.STATS_TIME,S.NLEAF, S.NLEVELS,S.FIRSTKEYCARD,S.FIRST2KEYCARD,S.FIRST3KEYCARD,S.FIRST4KEYCARD,S.FULLKEYCARD,S.CLUSTERRATIO,S.CLUSTERFACTOR,S.SEQUENTIAL_PAGES,S.DENSITY,S.PAGE_FETCH_PAIRS,S.NUMRIDS,S.NUMRIDS_DELETED,S.NUM_EMPTY_LEAFS,S.AVERAGE_RANDOM_FETCH_PAGES,S.AVERAGE_RANDOM_PAGES,S.AVERAGE_SEQUENCE_GAP,S.AVERAGE_SEQUENCE_FETCH_GAP,S.AVERAGE_SEQUENCE_PAGES,S.AVERAGE_SEQUENCE_FETCH_PAGES,S.AVGPARTITION_CLUSTERRATIO,S.AVGPARTITION_CLUSTERFACTOR,S.AVGPARTITION_PAGE_FETCH_PAIRS,S.DATAPARTITION_CLUSTERFACTOR,S.INDCARD FROM SYSSTAT.INDEXES S, SYSCAT.INDEXES I WHERE S.INDSCHEMA = I.INDSCHEMA AND S.INDNAME = I.INDNAME AND S.INDSCHEMA='" + LUWUtil.getIdentifier(index.getSchema().getName()) + "'" + " AND S.INDNAME='" + LUWUtil.getIdentifier(index.getName()) + "'" + " FOR FETCH ONLY";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                BigInteger indCard;
                float dataClusterFactor;
                String partFetchPair;
                float partClusterFactor;
                int partClusterRatio;
                float avgSequenceFetchPage;
                float avgSequencePage;
                float avgSequenceFetchGap;
                float avgSequenceGap;
                float avgRandomPages;
                float avgRandomFetchPages;
                BigInteger numEmptyLeafs;
                BigInteger numberRIDDeleted;
                BigInteger numberRID;
                String fetchPair;
                int density;
                int sequentialPages;
                float clusterFactor;
                int clusterRatio;
                BigInteger fullKeyCard;
                BigInteger first4KeyCard;
                BigInteger first3KeyCard;
                BigInteger firstKeyCard;
                int nLevel;
                int nLeaf;
                CatalogStatistics stats = null;
                Timestamp stats_time = r.getTimestamp("STATS_TIME");
                if (stats_time != null) {
                    stats = new CatalogStatistics("STATS_TIME", LUWCatalogMessages.STAT_TIME, LUWCatalogMessages.STAT_TIME_DES, stats_time, "");
                    statistics.add(stats);
                }
                if ((nLeaf = r.getInt("NLEAF")) != -1) {
                    stats = new CatalogStatistics("NLEAF", LUWCatalogMessages.STAT_NLEAF, LUWCatalogMessages.STAT_NLEAF_DES, nLeaf, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((nLevel = r.getInt("NLEVELS")) != -1) {
                    stats = new CatalogStatistics("NLEVELS", LUWCatalogMessages.STAT_NLEVELS, LUWCatalogMessages.STAT_NLEVELS_DES, nLevel, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((firstKeyCard = r.getBigDecimal("FIRSTKEYCARD").toBigInteger()).intValue() != -1) {
                    stats = new CatalogStatistics("FIRSTKEYCARD", LUWCatalogMessages.STAT_FIRST_KEYCARD, LUWCatalogMessages.STAT_FIRST_KEYCARD_DES, firstKeyCard, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                BigInteger first2KeyCard = r.getBigDecimal("FIRST2KEYCARD").toBigInteger();
                if (firstKeyCard.intValue() != -1) {
                    stats = new CatalogStatistics("FIRST2KEYCARD", LUWCatalogMessages.STAT_FIRST2_KEYCARD, LUWCatalogMessages.STAT_FIRST2_KEYCARD_DES, first2KeyCard, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((first3KeyCard = r.getBigDecimal("FIRST3KEYCARD").toBigInteger()).intValue() != -1) {
                    stats = new CatalogStatistics("FIRST3KEYCARD", LUWCatalogMessages.STAT_FIRST3_KEYCARD, LUWCatalogMessages.STAT_FIRST3_KEYCARD_DES, first3KeyCard, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((first4KeyCard = r.getBigDecimal("FIRST4KEYCARD").toBigInteger()).intValue() != -1) {
                    stats = new CatalogStatistics("FIRST4KEYCARD", LUWCatalogMessages.STAT_FIRST4_KEYCARD, LUWCatalogMessages.STAT_FIRST4_KEYCARD_DES, first4KeyCard, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((fullKeyCard = r.getBigDecimal("FULLKEYCARD").toBigInteger()).intValue() != -1) {
                    stats = new CatalogStatistics("FULLKEYCARD", LUWCatalogMessages.STAT_FULL_KEYCARD, LUWCatalogMessages.STAT_FULL_KEYCARD_DES, fullKeyCard, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((clusterRatio = r.getInt("CLUSTERRATIO")) != -1) {
                    stats = new CatalogStatistics("CLUSTERRATIO", LUWCatalogMessages.STAT_CLUSTER_RATIO, LUWCatalogMessages.STAT_CLUSTER_RATIO_DES, clusterRatio, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((clusterFactor = r.getFloat("CLUSTERFACTOR")) != -1.0f) {
                    stats = new CatalogStatistics("CLUSTERFACTOR", LUWCatalogMessages.STAT_CLUSTER_FACTOR, LUWCatalogMessages.STAT_CLUSTER_FACTOR_DES, clusterFactor, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((sequentialPages = r.getInt("SEQUENTIAL_PAGES")) != -1) {
                    stats = new CatalogStatistics("SEQUENTIAL_PAGES", LUWCatalogMessages.STAT_SEQUENTIAL_PAGES, LUWCatalogMessages.STAT_SEQUENTIAL_PAGES_DES, sequentialPages, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((density = r.getInt("DENSITY")) != -1) {
                    stats = new CatalogStatistics("DENSITY", LUWCatalogMessages.STAT_DENSITY, LUWCatalogMessages.STAT_DENSITY_DES, density, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((fetchPair = r.getString("PAGE_FETCH_PAIRS")) != null && !"".equals(fetchPair)) {
                    stats = new CatalogStatistics("PAGE_FETCH_PAIRS", LUWCatalogMessages.STAT_PAGE_FETCH_PAIRS, LUWCatalogMessages.STAT_PAGE_FETCH_PAIRS_DES, LUWUtil.getSingleQuotedString(fetchPair), "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((numberRID = r.getBigDecimal("NUMRIDS").toBigInteger()).intValue() != -1) {
                    stats = new CatalogStatistics("NUMRIDS", LUWCatalogMessages.STAT_NUMRIDS, LUWCatalogMessages.STAT_NUMRIDS_DES, numberRID, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((numberRIDDeleted = r.getBigDecimal("NUMRIDS_DELETED").toBigInteger()).intValue() != -1) {
                    stats = new CatalogStatistics("NUMRIDS_DELETED", LUWCatalogMessages.STAT_NUMRIDS_DELETED, LUWCatalogMessages.STAT_NUMRIDS_DELETED_DES, numberRIDDeleted, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((numEmptyLeafs = r.getBigDecimal("NUM_EMPTY_LEAFS").toBigInteger()).intValue() != -1) {
                    stats = new CatalogStatistics("NUM_EMPTY_LEAFS", LUWCatalogMessages.STAT_NUM_EMPTY_LEAFS, LUWCatalogMessages.STAT_NUM_EMPTY_LEAFS_DES, numEmptyLeafs, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((avgRandomFetchPages = r.getFloat("AVERAGE_RANDOM_FETCH_PAGES")) != -1.0f) {
                    stats = new CatalogStatistics("AVERAGE_RANDOM_FETCH_PAGES", LUWCatalogMessages.STAT_AVERAGE_RANDOM_FETCH_PAGES, LUWCatalogMessages.STAT_AVERAGE_RANDOM_FETCH_PAGES_DES, avgRandomFetchPages, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((avgRandomPages = r.getFloat("AVERAGE_RANDOM_PAGES")) != -1.0f) {
                    stats = new CatalogStatistics("AVERAGE_RANDOM_PAGES", LUWCatalogMessages.STAT_AVERAGE_RANDOM_PAGES, LUWCatalogMessages.STAT_AVERAGE_RANDOM_PAGES_DES, avgRandomPages, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((avgSequenceGap = r.getFloat("AVERAGE_SEQUENCE_GAP")) != -1.0f) {
                    stats = new CatalogStatistics("AVERAGE_SEQUENCE_GAP", LUWCatalogMessages.STAT_AVERAGE_SEQUENCE_GAP, LUWCatalogMessages.STAT_AVERAGE_SEQUENCE_GAP_DES, avgSequenceGap, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((avgSequenceFetchGap = r.getFloat("AVERAGE_SEQUENCE_FETCH_GAP")) != -1.0f) {
                    stats = new CatalogStatistics("AVERAGE_SEQUENCE_FETCH_GAP", LUWCatalogMessages.STAT_AVERAGE_SEQUENCE_FETCH_GAP, LUWCatalogMessages.STAT_AVERAGE_SEQUENCE_FETCH_GAP_DES, avgSequenceFetchGap, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((avgSequencePage = r.getFloat("AVERAGE_SEQUENCE_PAGES")) != -1.0f) {
                    stats = new CatalogStatistics("AVERAGE_SEQUENCE_PAGES", LUWCatalogMessages.STAT_AVERAGE_SEQUENCE_PAGES, LUWCatalogMessages.STAT_AVERAGE_SEQUENCE_PAGES_DES, avgSequencePage, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((avgSequenceFetchPage = r.getFloat("AVERAGE_SEQUENCE_FETCH_PAGES")) != -1.0f) {
                    stats = new CatalogStatistics("AVERAGE_SEQUENCE_FETCH_PAGES", LUWCatalogMessages.STAT_AVERAGE_SEQUENCE_FETCH_PAGES, LUWCatalogMessages.STAT_AVERAGE_SEQUENCE_FETCH_PAGES_DES, avgSequenceFetchPage, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((partClusterRatio = r.getInt("AVGPARTITION_CLUSTERRATIO")) != -1) {
                    stats = new CatalogStatistics("AVGPARTITION_CLUSTERRATIO", LUWCatalogMessages.STAT_AVERAGE_PARTITION_CLUSTERRATIO, LUWCatalogMessages.STAT_AVERAGE_PARTITION_CLUSTERRATIO_DES, partClusterRatio, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((partClusterFactor = r.getFloat("AVGPARTITION_CLUSTERFACTOR")) != -1.0f) {
                    stats = new CatalogStatistics("AVGPARTITION_CLUSTERFACTOR", LUWCatalogMessages.STAT_AVERAGE_PARTITION_CLUSTERFACTOR, LUWCatalogMessages.STAT_AVERAGE_PARTITION_CLUSTERFACTOR_DES, partClusterFactor, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((partFetchPair = r.getString("AVGPARTITION_PAGE_FETCH_PAIRS")) != null && !"".equals(partFetchPair)) {
                    stats = new CatalogStatistics("AVGPARTITION_PAGE_FETCH_PAIRS", LUWCatalogMessages.STAT_AVERAGE_PARTITION_PAGE_FETCH_PAIRS, LUWCatalogMessages.STAT_AVERAGE_PARTITION_PAGE_FETCH_PAIRS_DES, partFetchPair, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((dataClusterFactor = r.getFloat("DATAPARTITION_CLUSTERFACTOR")) != -1.0f) {
                    stats = new CatalogStatistics("DATAPARTITION_CLUSTERFACTOR", LUWCatalogMessages.STAT_DATAPARTITION_CLUSTERFACTOR, LUWCatalogMessages.STAT_DATAPARTITION_CLUSTERFACTOR_DES, dataClusterFactor, "SYSSTAT.INDEXES");
                    statistics.add(stats);
                }
                if ((indCard = r.getBigDecimal("INDCARD").toBigInteger()).intValue() == -1) continue;
                stats = new CatalogStatistics("INDCARD", LUWCatalogMessages.STAT_INDCARD, LUWCatalogMessages.STAT_INDCARD_DES, indCard, "SYSSTAT.INDEXES");
                statistics.add(stats);
            }
            r.close();
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return statistics;
    }

    protected void getPrivilegesWithFilter(String granteeFilter) throws SQLException {
        if (this.privilegeLoaded) {
            return;
        }
        EList privileges = super.getPrivileges();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogIndex.loadPrivileges(this.getConnection(), privileges, (Index)this, granteeFilter);
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    protected void setIndexUniqueRule(IndexUniqueRule rule) {
        this.uniqueRule = rule;
    }

    protected IndexUniqueRule getIndexUniqueRule() {
        return this.uniqueRule;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum IndexUniqueRule {
        DUPLICATE,
        UNIQUE,
        PRIMARYKEY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MembersInfo {
        String idxSchemaName;
        String indexName;
        List<MemberInfo> members = new ArrayList<MemberInfo>();

        private MembersInfo() {
        }

        public String getKey() {
            return String.valueOf(this.idxSchemaName) + "." + this.indexName;
        }

        public void addMember(String colName, String order) {
            this.members.add(new MemberInfo(colName, order));
        }

        public void setMembers(Index index, List<IndexMember> members, List<IndexMember> includedMembers) {
            Database database = index.getSchema().getDatabase();
            DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
            DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
            Object[] memberList = members.toArray();
            members.clear();
            Object[] includedMemberList = includedMembers.toArray();
            includedMembers.clear();
            for (MemberInfo minfo : this.members) {
                IndexMember member = LUWCatalogIndex.findIndexMember(memberList, minfo.colName);
                if (member == null && (member = LUWCatalogIndex.findIndexMember(includedMemberList, minfo.colName)) == null) {
                    member = (IndexMember)factory.create(SQLConstraintsPackage.eINSTANCE.getIndexMember());
                    Column col = LUWCatalogIndex.getColumn(index, minfo.colName);
                    member.setColumn(col);
                }
                if (minfo.order.equals("A")) {
                    member.setIncrementType(IncrementType.ASC_LITERAL);
                    members.add(member);
                    continue;
                }
                if (minfo.order.equals("D")) {
                    member.setIncrementType(IncrementType.DESC_LITERAL);
                    members.add(member);
                    continue;
                }
                if (!minfo.order.equals("I")) continue;
                includedMembers.add(member);
            }
        }

        private static class MemberInfo {
            String colName;
            String order;

            public MemberInfo(String colName, String order) {
                this.colName = colName;
                this.order = order;
            }
        }
    }
}

