/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IPropertySetChangeEvent;

public class PropertySetChangeEvent
implements IPropertySetChangeEvent {
    private IConnectionProfile mConnectionProfile;
    private String mPropertiesType;
    private Map mChangedProperties;

    private PropertySetChangeEvent(IConnectionProfile profile, String propertiesType) {
        this.mConnectionProfile = profile;
        this.mPropertiesType = propertiesType;
    }

    public PropertySetChangeEvent(IConnectionProfile profile, String propertiesType, String property, String oldValue, String newValue) {
        this(profile, propertiesType);
        this.mChangedProperties = new HashMap(1);
        this.mChangedProperties.put(property, new ChangedProperty(property, oldValue, newValue));
    }

    public PropertySetChangeEvent(IConnectionProfile profile, String propertiesType, Properties oldProperties, Properties newProperties) {
        this(profile, propertiesType);
        HashSet<Object> keys = new HashSet<Object>(newProperties.keySet());
        keys.addAll(oldProperties.keySet());
        this.mChangedProperties = new HashMap(keys.size());
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String oldValue = oldProperties.getProperty(key);
            String newValue = newProperties.getProperty(key);
            if ((oldValue != null || newValue == null) && (oldValue == null || oldValue.equals(newValue))) continue;
            this.mChangedProperties.put(key, new ChangedProperty(key, oldValue, newValue));
        }
        this.mChangedProperties = Collections.unmodifiableMap(this.mChangedProperties);
    }

    public Map getChangedProperties() {
        return this.mChangedProperties;
    }

    public IPropertySetChangeEvent.IChangedProperty getChangedProperty(String key) {
        if (this.mChangedProperties.containsKey(key)) {
            return (IPropertySetChangeEvent.IChangedProperty)this.mChangedProperties.get(key);
        }
        return null;
    }

    public IConnectionProfile getConnectionProfile() {
        return this.mConnectionProfile;
    }

    public String getPropertySetType() {
        return this.mPropertiesType;
    }

    private static class ChangedProperty
    implements IPropertySetChangeEvent.IChangedProperty {
        private String mKey;
        private String mNewValue;
        private String mOldValue;

        private ChangedProperty(String key, String oldValue, String newValue) {
            this.mKey = key;
            this.mNewValue = newValue;
            this.mOldValue = oldValue;
        }

        public String getNewValue() {
            return this.mNewValue;
        }

        public String getOldValue() {
            return this.mOldValue;
        }

        public String getID() {
            return this.mKey;
        }
    }
}

