/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity;

import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;

public class ProfileManager
implements IAdaptable {
    private static ProfileManager mManager = null;

    public static ProfileManager getInstance() {
        if (mManager == null) {
            mManager = new ProfileManager();
        }
        return mManager;
    }

    public IConnectionProfile[] getProfiles() {
        return InternalProfileManager.getInstance().getProfiles(false);
    }

    public ICategory getCategory(String catID) {
        return InternalProfileManager.getInstance().getCategory(catID);
    }

    public ICategory[] getRootCategories() {
        return InternalProfileManager.getInstance().getRootCategories();
    }

    public IConnectionProfile[] getProfilesByCategory(String catID) {
        return InternalProfileManager.getInstance().getProfilesByCategory(catID, false);
    }

    public IConnectionProfile getProfileByName(String name) {
        return InternalProfileManager.getInstance().getProfileByName(name, true);
    }

    public IConnectionProfile getProfileByInstanceID(String id) {
        return InternalProfileManager.getInstance().getProfileByInstanceID(id);
    }

    public IConnectionProfile[] getProfileByProviderID(String ID) {
        return InternalProfileManager.getInstance().getProfileByProviderID(ID, false);
    }

    public void createProfile(String name, String description, String providerID, Properties baseProperties) throws ConnectionProfileException {
        InternalProfileManager.getInstance().createProfile(name, description, providerID, baseProperties);
    }

    public void createProfile(String name, String description, String providerID, Properties baseProperties, String parentProfile) throws ConnectionProfileException {
        InternalProfileManager.getInstance().createProfile(name, description, providerID, baseProperties, parentProfile);
    }

    public void createProfile(String name, String description, String providerID, Properties baseProperties, String parentProfile, boolean autoConnect) throws ConnectionProfileException {
        InternalProfileManager.getInstance().createProfile(name, description, providerID, baseProperties, parentProfile, autoConnect);
    }

    public String duplicateProfile(IConnectionProfile profile) throws ConnectionProfileException {
        return InternalProfileManager.getInstance().duplicateProfile(profile);
    }

    public void addProfile(IConnectionProfile profile) throws ConnectionProfileException {
        InternalProfileManager.getInstance().addProfile(profile);
    }

    public void addProfile(IConnectionProfile profile, boolean replaceExisting) throws ConnectionProfileException {
        InternalProfileManager.getInstance().addProfile(profile, replaceExisting);
    }

    public void deleteProfile(IConnectionProfile profile) throws ConnectionProfileException {
        InternalProfileManager.getInstance().deleteProfile(profile);
    }

    public void modifyProfile(IConnectionProfile profile) throws ConnectionProfileException {
        InternalProfileManager.getInstance().modifyProfile(profile);
    }

    public void modifyProfile(IConnectionProfile profile, String newName, String newDesc) throws ConnectionProfileException {
        InternalProfileManager.getInstance().modifyProfile(profile, newName, newDesc);
    }

    public void modifyProfile(IConnectionProfile profile, String newName, String newDesc, Boolean autoConnect) throws ConnectionProfileException {
        InternalProfileManager.getInstance().modifyProfile(profile, newName, newDesc, autoConnect);
    }

    public void addProfileListener(IProfileListener listener) {
        InternalProfileManager.getInstance().addProfileListener(listener);
    }

    public void removeProfileListener(IProfileListener listener) {
        InternalProfileManager.getInstance().removeProfileListener(listener);
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

