/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.datatools.connectivity.ConnectionProfileConstants;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IPropertySetChangeEvent;
import org.eclipse.datatools.connectivity.IPropertySetListener;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPVersionPropertyPage;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class CPVersionPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IContextProvider {
    private static final int INDENT_TECH_VERSION = 20;
    private Button mUpdateVersionInfoButton;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());
    private IPropertySetListener mPropertySetListener = new IPropertySetListener(){

        public void propertySetChanged(IPropertySetChangeEvent event) {
            IPropertySetChangeEvent.IChangedProperty icp;
            if ("org.eclipse.datatools.connectivity.versionInfo".equals(event.getPropertySetType())) {
                CPVersionPropertyPage.this.getControl().getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        CPVersionPropertyPage.access$0(1.access$0(this.this$1));
                    }
                });
            } else if (IConnectionProfile.CONNECTION_PROFILE_PROPERTY_SET.equals(event.getPropertySetType()) && (icp = event.getChangedProperty("connectionState")) != null) {
                CPVersionPropertyPage.this.getControl().getDisplay().asyncExec(new Runnable(this, icp){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ IPropertySetChangeEvent.IChangedProperty val$icp;
                    {
                        this.this$1 = var1_1;
                        this.val$icp = iChangedProperty;
                    }

                    public void run() {
                        if (Boolean.valueOf(this.val$icp.getNewValue()).booleanValue()) {
                            CPVersionPropertyPage.access$0(1.access$0(this.this$1));
                            CPVersionPropertyPage.access$1(1.access$0(this.this$1)).setEnabled(false);
                        } else {
                            CPVersionPropertyPage.access$1(1.access$0(this.this$1)).setEnabled(true);
                        }
                    }
                });
            }
        }

        static /* synthetic */ CPVersionPropertyPage access$0(1 var0) {
            return var0.CPVersionPropertyPage.this;
        }
    };
    static /* synthetic */ Class class$0;

    public CPVersionPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        content.setLayout((Layout)layout);
        this.createControls(content);
        this.getConnectionProfile().addPropertySetListener(this.mPropertySetListener);
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getControl(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_PROFILE_VERSION_PROPERTIES", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
        return content;
    }

    public void dispose() {
        this.getConnectionProfile().removePropertySetListener(this.mPropertySetListener);
        super.dispose();
    }

    private void updateVersionInformation() {
        Composite content = (Composite)this.getControl();
        if (content == null || content.isDisposed()) {
            return;
        }
        this.deleteControls(content);
        this.createControls(content);
        content.layout(true);
        content.redraw();
    }

    private void createControls(Composite content) {
        IConnectionProfile profile = this.getConnectionProfile();
        this.setDescription(ConnectivityUIPlugin.getDefault().getResourceString("CPVersionPropertyPage.desc", new Object[]{profile.getName()}));
        Properties props = profile.getProperties("org.eclipse.datatools.connectivity.versionInfo");
        if (props.getProperty("server.name") == null) {
            Label label = new Label(content, 0);
            label.setText(ConnectivityUIPlugin.getDefault().getResourceString("CPVersionPropertyPage.label.versionUnavailable"));
            GridData data = new GridData(768);
            label.setLayoutData((Object)data);
        } else {
            Composite serverVersionContainer = new Composite(content, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            serverVersionContainer.setLayout((Layout)layout);
            GridData data = new GridData(768);
            serverVersionContainer.setLayoutData((Object)data);
            String serverName = props.getProperty("server.name");
            String serverVersion = props.getProperty("server.version");
            Label label = new Label(serverVersionContainer, 0);
            if (serverVersion == null) {
                label.setText(serverName);
            } else {
                label.setText(String.valueOf(serverName) + ':');
            }
            data = new GridData(32);
            label.setLayoutData((Object)data);
            label = new Label(serverVersionContainer, 0);
            if (serverVersion != null) {
                label.setText(serverVersion);
            }
            data = new GridData(32);
            label.setLayoutData((Object)data);
            ArrayList<String[]> techVersions = new ArrayList<String[]>();
            Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String key = (String)entry.getKey();
                if (key == null || !key.startsWith("technology.name.")) continue;
                String name = String.valueOf((String)entry.getValue()) + ':';
                String verKey = "technology.version." + key.substring(key.lastIndexOf(46) + 1);
                String version = props.getProperty(verKey);
                if (version == null || version.length() == 0) {
                    version = ConnectionProfileConstants.UNKNOWN_VERSION;
                }
                techVersions.add(new String[]{name, version});
            }
            if (techVersions.size() > 0) {
                label = new Label(content, 0);
                label.setText(ConnectivityUIPlugin.getDefault().getResourceString("CPVersionPropertyPage.label.techVersions"));
                data = new GridData();
                data.horizontalSpan = 2;
                label.setLayoutData((Object)data);
                Composite techVersionContainer = new Composite(content, 0);
                layout = new GridLayout(2, false);
                techVersionContainer.setLayout((Layout)layout);
                data = new GridData(768);
                data.horizontalIndent = 20;
                techVersionContainer.setLayoutData((Object)data);
                Iterator it2 = techVersions.iterator();
                while (it2.hasNext()) {
                    String[] pair = (String[])it2.next();
                    label = new Label(techVersionContainer, 0);
                    label.setText(pair[0]);
                    data = new GridData(32);
                    label.setLayoutData((Object)data);
                    label = new Label(techVersionContainer, 0);
                    label.setText(pair[1]);
                    data = new GridData(32);
                    label.setLayoutData((Object)data);
                }
            }
        }
        this.mUpdateVersionInfoButton = new Button(content, 8);
        this.mUpdateVersionInfoButton.setText(ConnectivityUIPlugin.getDefault().getResourceString("CPVersionPropertyPage.button.updateVersion"));
        this.mUpdateVersionInfoButton.setLayoutData((Object)new GridData(40));
        this.mUpdateVersionInfoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Display.getCurrent().syncExec(new Runnable(this){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        CPVersionPropertyPage.access$2(4.access$0(this.this$1)).connect(new IJobChangeListener(this){
                            final /* synthetic */ 5 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void aboutToRun(IJobChangeEvent event) {
                            }

                            public void awake(IJobChangeEvent event) {
                            }

                            public void done(IJobChangeEvent event) {
                                Composite content = (Composite)4.access$0(5.access$0(this.this$2)).getControl();
                                if (content == null || content.isDisposed()) {
                                    return;
                                }
                                Display.getDefault().syncExec(new Runnable(this, content){
                                    final /* synthetic */ 6 this$3;
                                    private final /* synthetic */ Composite val$content;
                                    {
                                        this.this$3 = var1_1;
                                        this.val$content = composite;
                                    }

                                    public void run() {
                                        CPVersionPropertyPage.access$3(4.access$0(5.access$0(6.access$0(this.this$3))), this.val$content);
                                        CPVersionPropertyPage.access$4(4.access$0(5.access$0(6.access$0(this.this$3))), this.val$content);
                                        this.val$content.layout(true);
                                        this.val$content.redraw();
                                    }
                                });
                            }

                            public void running(IJobChangeEvent event) {
                            }

                            public void scheduled(IJobChangeEvent event) {
                            }

                            public void sleeping(IJobChangeEvent event) {
                            }

                            static /* synthetic */ 5 access$0(6 var0) {
                                return var0.this$2;
                            }
                        });
                    }

                    static /* synthetic */ 4 access$0(5 var0) {
                        return var0.this$1;
                    }
                });
            }

            static /* synthetic */ CPVersionPropertyPage access$0(4 var0) {
                return var0.CPVersionPropertyPage.this;
            }
        });
        this.mUpdateVersionInfoButton.setEnabled(this.getConnectionProfile().getConnectionState() == 0);
    }

    private void deleteControls(Composite content) {
        Iterator<Control> it = Arrays.asList(content.getChildren()).iterator();
        while (it.hasNext()) {
            it.next().dispose();
        }
    }

    private IConnectionProfile getConnectionProfile() {
        IAdaptable element = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.IConnectionProfile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IConnectionProfile profile = (IConnectionProfile)element.getAdapter((Class)clazz);
        return profile;
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    static /* synthetic */ void access$0(CPVersionPropertyPage cPVersionPropertyPage) {
        cPVersionPropertyPage.updateVersionInformation();
    }

    static /* synthetic */ Button access$1(CPVersionPropertyPage cPVersionPropertyPage) {
        return cPVersionPropertyPage.mUpdateVersionInfoButton;
    }

    static /* synthetic */ IConnectionProfile access$2(CPVersionPropertyPage cPVersionPropertyPage) {
        return cPVersionPropertyPage.getConnectionProfile();
    }

    static /* synthetic */ void access$3(CPVersionPropertyPage cPVersionPropertyPage, Composite composite) {
        cPVersionPropertyPage.deleteControls(composite);
    }

    static /* synthetic */ void access$4(CPVersionPropertyPage cPVersionPropertyPage, Composite composite) {
        cPVersionPropertyPage.createControls(composite);
    }
}

