/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.IPropertySetChangeEvent;
import org.eclipse.datatools.connectivity.IPropertySetListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.ui.RefreshProfileJob;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class CPRepositoryContentProvider
implements ITreeContentProvider {
    private static final String PROP_SHOW_CATEGORIES = "showCategories";
    private static final String DSE_VIEW_CONTENT_EXTENSION_ID = "org.eclipse.datatools.connectivity.dsexplorer.content";
    private Viewer mViewer;
    private Set mRepositories = new HashSet();
    private boolean mShowCategories = true;
    private IPropertyChangeListener mPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (CPRepositoryContentProvider.PROP_SHOW_CATEGORIES.equals(event.getProperty())) {
                CPRepositoryContentProvider.this.setShowCategories((Boolean)event.getNewValue());
            }
        }
    };
    private IProfileListener mProfileListener = new IProfileListener(){

        public void profileAdded(IConnectionProfile profile) {
            if (this.isChildProfile(profile)) {
                profile.addPropertySetListener(CPRepositoryContentProvider.this.mPropertyListener);
                CPRepositoryContentProvider.this.refreshViewer(profile.getCategory(), true);
            }
        }

        public void profileDeleted(IConnectionProfile profile) {
            if (this.isChildProfile(profile)) {
                profile.removePropertySetListener(CPRepositoryContentProvider.this.mPropertyListener);
                CPRepositoryContentProvider.this.refreshViewer(profile.getCategory(), true);
            }
        }

        public void profileChanged(IConnectionProfile profile) {
            if (this.isChildProfile(profile)) {
                CPRepositoryContentProvider.this.refreshViewer(profile, false);
            }
        }

        private boolean isChildProfile(IConnectionProfile profile) {
            IManagedConnection imc;
            if (profile.getParentProfile() == null || profile.getConnectionState() == 1) {
                return false;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (imc = profile.getManagedConnection(clazz.getName())) != null && CPRepositoryContentProvider.this.mRepositories.contains(imc.getConnection());
        }
    };
    private IPropertySetListener mPropertyListener = new IPropertySetListener(){

        public void propertySetChanged(IPropertySetChangeEvent event) {
            CPRepositoryContentProvider.this.handleProfilePropertyChanged(event);
        }
    };
    static /* synthetic */ Class class$0;

    public CPRepositoryContentProvider() {
        ProfileManager.getInstance().addProfileListener(this.mProfileListener);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IConnectionProfileRepository) {
            if (!this.mRepositories.contains(parentElement)) {
                Iterator<IConnectionProfile> it = Arrays.asList(((IConnectionProfileRepository)parentElement).getProfiles()).iterator();
                while (it.hasNext()) {
                    it.next().addPropertySetListener(this.mPropertyListener);
                }
                this.mRepositories.add(parentElement);
            }
            if (this.mShowCategories) {
                ArrayList<ICategory> kids = new ArrayList<ICategory>();
                kids.addAll(Arrays.asList(((IConnectionProfileRepository)parentElement).getRootCategories()));
                return kids.toArray();
            }
            return ((IConnectionProfileRepository)parentElement).getProfiles();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IConnectionProfileRepository) {
            return ((IConnectionProfileRepository)element).getRepositoryProfile();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        ProfileManager.getInstance().removeProfileListener(this.mProfileListener);
        Iterator repIt = this.mRepositories.iterator();
        while (repIt.hasNext()) {
            Iterator<IConnectionProfile> it = Arrays.asList(((IConnectionProfileRepository)repIt.next()).getProfiles()).iterator();
            while (it.hasNext()) {
                it.next().removePropertySetListener(this.mPropertyListener);
            }
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.mViewer instanceof CommonViewer) {
            ((CommonViewer)this.mViewer).getNavigatorContentService().findStateModel(DSE_VIEW_CONTENT_EXTENSION_ID).removePropertyChangeListener(this.mPropertyChangeListener);
        }
        this.mViewer = viewer;
        if (this.mViewer instanceof CommonViewer) {
            IExtensionStateModel stateModel = ((CommonViewer)this.mViewer).getNavigatorContentService().findStateModel(DSE_VIEW_CONTENT_EXTENSION_ID);
            stateModel.addPropertyChangeListener(this.mPropertyChangeListener);
            this.setShowCategories(stateModel.getBooleanProperty(PROP_SHOW_CATEGORIES));
        }
    }

    public void setShowCategories(boolean showCategories) {
        if (showCategories != this.mShowCategories) {
            this.mShowCategories = showCategories;
        }
    }

    public boolean isShowCategories() {
        return this.mShowCategories;
    }

    protected void refreshViewer(Object object, boolean expand) {
        if (this.mViewer instanceof TreeViewer && object instanceof IConnectionProfile) {
            RefreshProfileJob.scheduleRefreshProfileJob((IConnectionProfile)object, (TreeViewer)this.mViewer);
        } else {
            Runnable runner = new Runnable(){

                public void run() {
                    ((CommonViewer)CPRepositoryContentProvider.this.mViewer).refresh();
                }
            };
            this.mViewer.getControl().getDisplay().syncExec(runner);
        }
    }

    protected void handleProfilePropertyChanged(IPropertySetChangeEvent event) {
        if (IConnectionProfile.CONNECTION_PROFILE_PROPERTY_SET.equals(event.getPropertySetType()) && event.getChangedProperty("connectionState") != null) {
            this.refreshViewer(event.getConnectionProfile(), false);
        }
    }
}

