/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.wizards;

import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPPropetyPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class ProfilePropertyPage
extends PropertyPage {
    private boolean mAffectsConnectionProperties;
    private ISchedulingRule mProfileRule;
    private boolean isReadOnly = false;
    static /* synthetic */ Class class$0;

    protected ProfilePropertyPage() {
        this(false);
    }

    protected ProfilePropertyPage(boolean affectsConnectionProperties) {
        this.mAffectsConnectionProperties = affectsConnectionProperties;
    }

    public void createControl(Composite parent, boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
        this.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        container.setLayout((Layout)gridLayout);
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createCustomContents(composite);
        return container;
    }

    protected void createCustomContents(Composite parent, boolean isReadOnly) {
    }

    protected void createCustomContents(Composite parent) {
        this.createCustomContents(parent, this.isReadOnly);
    }

    protected abstract Properties collectProperties();

    public IConnectionProfile getConnectionProfile() {
        IAdaptable element = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.IConnectionProfile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IConnectionProfile profile = (IConnectionProfile)element.getAdapter((Class)clazz);
        return profile;
    }

    protected String getPropertiesID() {
        return this.getConnectionProfile().getProviderId();
    }

    public boolean performOk() {
        IConnectionProfile profile = this.getConnectionProfile();
        Properties oldProps = profile.getProperties(this.getPropertiesID());
        Properties newProps = this.collectProperties();
        boolean changed = false;
        Iterator<Object> itr = newProps.keySet().iterator();
        while (!changed && itr.hasNext()) {
            Object key = itr.next();
            Object oldObj = oldProps.get(key);
            Object newObj = newProps.get(key);
            boolean bl = changed = newObj != null && !newObj.equals(oldObj) || newObj == null && oldObj != null;
        }
        if (changed) {
            profile.setProperties(this.getPropertiesID(), newProps);
            if (this.mAffectsConnectionProperties && profile.getConnectionState() != 0 && MessageDialog.openQuestion((Shell)this.getShell(), (String)ConnectivityUIPlugin.getDefault().getResourceString("ConnectionProfileDetailsPage.AskConfirmation"), (String)ConnectivityUIPlugin.getDefault().getResourceString("ConnectionProfileDetailsPage.AskReconnect")) && this.mProfileRule == null) {
                this.mProfileRule = CPPropetyPage.getProfileRule(profile);
                Job.getJobManager().beginRule(this.mProfileRule, null);
                profile.disconnect(null);
                profile.connect(null);
            }
        }
        return super.performOk();
    }

    public void dispose() {
        if (this.mProfileRule != null) {
            Job.getJobManager().endRule(this.mProfileRule);
            this.mProfileRule = null;
        }
        super.dispose();
    }
}

