/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.CategoryActionFilter;
import org.eclipse.datatools.connectivity.internal.ui.CategoryPropertySource;
import org.eclipse.datatools.connectivity.internal.ui.ConnectionProfileActionFilter;
import org.eclipse.datatools.connectivity.internal.ui.ConnectionProfilePropertySource;
import org.eclipse.datatools.connectivity.internal.ui.WorkbenchWindowPerspectiveActionFilter;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ConnectivityUIPlugin
extends AbstractUIPlugin {
    public static final int INTERNAL_ERROR = 10001;
    public static final String FILTER_PROPERTY_CONTEN_EXTENSION_ID = "org.eclipse.datatools.connectivity.contentextension.id";
    public static final String FILTER_PROPERTY_CONTEN_EXTENSION_STATE = "org.eclipse.datatools.connectivity.contentextension.state";
    public static final String SERVERS_VIEW_CONTENT_EXTENSION_ID = "org.eclipse.datatools.connectivity.dsexplorer.content";
    public static final String PROP_SHOW_CATEGORIES = "showCategories";
    public static final String SERVERS_VIEW_VIEWER_ID = "org.eclipse.datatools.connectivity.DataSourceExplorerNavigator";
    private static ConnectivityUIPlugin plugin;
    private ResourceBundle resourceBundle;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public ConnectivityUIPlugin() {
        plugin = this;
    }

    public static ConnectivityUIPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ConnectivityUIPlugin.addIConnectionProfileAdapter();
        ConnectivityUIPlugin.addICategoryAdapter();
        ConnectivityUIPlugin.addIWorkbenchWindowAdapter();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.datatools.connectivity.internal.ui.resources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public String getResourceString(String key) {
        try {
            ResourceBundle resBundle = this.getResourceBundle();
            if (resBundle == null) {
                return key;
            }
            return resBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public String getResourceString(String key, Object[] arguments) {
        MessageFormat f = new MessageFormat(this.getResourceString(key));
        return f.format(arguments);
    }

    private static void addIConnectionProfileAdapter() {
        IAdapterFactory pr = new IAdapterFactory(){

            public Class[] getAdapterList() {
                Class[] c = new Class[2];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                c[0] = clazz;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ui.IActionFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                c[1] = clazz2;
                return c;
            }

            public Object getAdapter(Object adaptableObject, Class adapterType) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapterType.isAssignableFrom(clazz)) {
                    IConnectionProfile icp = (IConnectionProfile)adaptableObject;
                    return new ConnectionProfilePropertySource(icp);
                }
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ui.IActionFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapterType.isAssignableFrom(clazz2)) {
                    return new ConnectionProfileActionFilter();
                }
                return null;
            }
        };
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.datatools.connectivity.IConnectionProfile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters(pr, (Class)clazz);
    }

    private static void addICategoryAdapter() {
        IAdapterFactory pr = new IAdapterFactory(){

            public Class[] getAdapterList() {
                Class[] c = new Class[2];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                c[0] = clazz;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ui.IActionFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                c[1] = clazz2;
                return c;
            }

            public Object getAdapter(Object adaptableObject, Class adapterType) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapterType.isAssignableFrom(clazz)) {
                    ICategory icp = (ICategory)adaptableObject;
                    return new CategoryPropertySource(icp);
                }
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ui.IActionFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapterType.isAssignableFrom(clazz2)) {
                    return new CategoryActionFilter();
                }
                return null;
            }
        };
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.datatools.connectivity.ICategory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters(pr, (Class)clazz);
    }

    private static void addIWorkbenchWindowAdapter() {
        IAdapterFactory pr = new IAdapterFactory(){

            public Class[] getAdapterList() {
                Class[] c = new Class[2];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                c[0] = clazz;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ui.IActionFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                c[1] = clazz2;
                return c;
            }

            public Object getAdapter(Object adaptableObject, Class adapterType) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ui.IActionFilter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapterType.isAssignableFrom(clazz)) {
                    return new WorkbenchWindowPerspectiveActionFilter();
                }
                return null;
            }
        };
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.ui.IWorkbenchWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters(pr, (Class)clazz);
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(String message) {
        this.log(this.createErrorStatus(message));
    }

    public void log(Throwable e) {
        this.log(this.createErrorStatus(e));
    }

    public IStatus createErrorStatus(String message) {
        return new Status(4, this.getBundle().getSymbolicName(), 10001, message, null);
    }

    public IStatus createErrorStatus(Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 10001, this.getResourceString("plugin.internal_error"), e);
    }
}

