/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.RepositoriesDropList;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizardPage;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewConnectionProfileWizardPage
extends BaseWizardPage
implements IContextProvider {
    private Text mCPName;
    private Text mCPDesc;
    private Button mLocalRepository;
    private RepositoriesDropList mRepositories;
    private String mCPNameStr;
    private String mCPDescStr;
    private boolean mCPAutoConnectValue = false;
    private boolean mCPAutoConnectOnFinishValue = false;
    private boolean _showAutoConnect = true;
    private static final String EMPTY_STRING = "";
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());
    static /* synthetic */ Class class$0;

    public NewConnectionProfileWizardPage() {
        this("NewConnectionProfileWizardPage");
    }

    public NewConnectionProfileWizardPage(String name) {
        super(name);
        this.setTitle(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.title"));
        this.setDescription(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.desc"));
    }

    public void createControl(Composite parent) {
        String providerID = ((NewConnectionProfileWizard)this.getWizard()).getProfileProviderID();
        IConnectionProfileProvider provider = ConnectionProfileManager.getInstance().getProvider(providerID);
        this._showAutoConnect = provider.needsMaintainConnection();
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        new Label(composite, 0).setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.cp_name"));
        this.mCPName = new Text(composite, 2048);
        this.mCPName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConnectionProfileWizardPage.this.handleModify();
            }
        });
        this.mCPName.setLayoutData((Object)new GridData(768));
        new Label(composite, 0).setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.cp_desc"));
        this.mCPDesc = new Text(composite, 2048);
        this.mCPDesc.setLayoutData((Object)new GridData(768));
        this.mLocalRepository = new Button(composite, 32);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.mLocalRepository.setLayoutData((Object)gd);
        this.mLocalRepository.setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.localRepository"));
        this.mLocalRepository.setSelection(true);
        this.mLocalRepository.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NewConnectionProfileWizardPage.this.handleLocalRepositoryChecked();
            }
        });
        Label label = new Label(composite, 0);
        label.setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.chooseRepository"));
        this.mRepositories = new RepositoriesDropList(this.getWizard() instanceof NewConnectionProfileWizard ? (ConnectionProfileProvider)ConnectionProfileManager.getInstance().getProvider(((NewConnectionProfileWizard)this.getWizard()).getProfileProviderID()) : null, composite);
        this.mRepositories.getCombo().setLayoutData((Object)new GridData(768));
        this.mRepositories.setInput(ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory"));
        this.mRepositories.getCombo().setEnabled(!this.mLocalRepository.getSelection());
        this.mRepositories.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewConnectionProfileWizardPage.this.validate();
            }
        });
        if (this.mRepositories.hasRepositories()) {
            if (this.getWizard() instanceof NewConnectionProfileWizard) {
                IConnectionProfileProvider icpp = ConnectionProfileManager.getInstance().getProvider(((NewConnectionProfileWizard)this.getWizard()).getProfileProviderID());
                Map map = icpp.getConnectionFactories();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (map.containsKey(clazz.getName())) {
                    this.mLocalRepository.setEnabled(false);
                    this.mLocalRepository.setVisible(false);
                    label.setVisible(false);
                    this.mRepositories.getCombo().setVisible(false);
                } else {
                    IConnectionProfile parentProfile = ProfileManager.getInstance().getProfileByName(((NewConnectionProfileWizard)this.getWizard()).getParentProfile());
                    if (parentProfile == null) {
                        this.mRepositories.getCombo().select(0);
                    } else {
                        this.mRepositories.setSelection((ISelection)new StructuredSelection((Object)parentProfile), true);
                        if (this.mRepositories.getSelection().isEmpty()) {
                            this.mRepositories.getCombo().select(0);
                        } else {
                            this.mLocalRepository.setSelection(false);
                            this.handleLocalRepositoryChecked();
                        }
                    }
                }
            } else {
                this.mRepositories.getCombo().select(0);
            }
        } else {
            this.mLocalRepository.setEnabled(false);
            this.mLocalRepository.setVisible(false);
            label.setVisible(false);
            this.mRepositories.getCombo().setVisible(false);
        }
        label = new Label(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        if (this.mCPNameStr != null) {
            this.mCPName.setText(this.mCPNameStr);
        }
        if (this.mCPDescStr != null) {
            this.mCPDesc.setText(this.mCPDescStr);
        }
        this.setControl((Control)composite);
        this.validate();
        this.setErrorMessage(null);
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getControl(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_NEW_CONNECTION_PROFILE_PAGE", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
    }

    private void handleModify() {
        this.validate();
    }

    private void handleLocalRepositoryChecked() {
        this.mRepositories.getCombo().setEnabled(!this.mLocalRepository.getSelection());
        this.validate();
    }

    private void validate() {
        String errorMessage = null;
        String cpName = this.mCPName.getText();
        IConnectionProfile foundProfile = null;
        String updatedPath = cpName;
        if (!this.mLocalRepository.getSelection() && !this.mRepositories.getSelection().isEmpty()) {
            updatedPath = String.valueOf(this.mRepositories.getCombo().getText()) + InternalProfileManager.PROFILE_PATH_SEPARATOR + cpName;
        }
        foundProfile = ProfileManager.getInstance().getProfileByFullPath(updatedPath);
        if (cpName == null || cpName.trim().length() == 0) {
            errorMessage = ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.Status.NoName");
        } else if (foundProfile != null) {
            errorMessage = ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.Status.DuplicateName");
        } else if (!this.mLocalRepository.getSelection() && this.mRepositories.getSelection().isEmpty()) {
            errorMessage = ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.Status.NoRepository");
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mCPName.setFocus();
        }
    }

    public String getProfileName() {
        return this.mCPName == null || this.mCPName.isDisposed() ? this.mCPNameStr : this.mCPName.getText();
    }

    public void setProfileName(String name) {
        this.mCPNameStr = name;
        if (this.mCPName != null && !this.mCPName.isDisposed()) {
            if (name == null) {
                name = EMPTY_STRING;
            }
            this.mCPName.setText(name);
        }
    }

    public String getProfileDescription() {
        return this.mCPDesc == null || this.mCPDesc.isDisposed() ? this.mCPDescStr : this.mCPDesc.getText();
    }

    public void setProfileDescription(String desc) {
        this.mCPDescStr = desc;
        if (this.mCPDesc != null && !this.mCPDesc.isDisposed()) {
            if (desc == null) {
                desc = EMPTY_STRING;
            }
            this.mCPDesc.setText(desc);
        }
    }

    public boolean getAutoConnect() {
        return this.mCPAutoConnectValue;
    }

    public boolean getAutoConnectOnFinish() {
        return this.mCPAutoConnectOnFinishValue;
    }

    public void setAutoConnect(boolean selection) {
        this.mCPAutoConnectValue = selection;
    }

    public void setAutoConnectOnFinish(boolean selection) {
        this.mCPAutoConnectOnFinishValue = selection;
    }

    public List getSummaryData() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.summary_cp_name"), this.getProfileName()});
        data.add(new String[]{ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.summary_cp_desc"), this.getProfileDescription()});
        if (this._showAutoConnect) {
            data.add(new String[]{ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.summary_autoconnect"), this.getAutoConnect() ? ConnectivityUIPlugin.getDefault().getResourceString("Boolean.true") : ConnectivityUIPlugin.getDefault().getResourceString("Boolean.false")});
            data.add(new String[]{ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.summary_autoconnect_on_finish"), this.getAutoConnectOnFinish() ? ConnectivityUIPlugin.getDefault().getResourceString("Boolean.true") : ConnectivityUIPlugin.getDefault().getResourceString("Boolean.false")});
        }
        return data;
    }

    public IConnectionProfile getRepository() {
        if (this.mLocalRepository.getSelection()) {
            return null;
        }
        return (IConnectionProfile)((IStructuredSelection)this.mRepositories.getSelection()).getFirstElement();
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }
}

