/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.navigator;

import com.ibm.icu.text.MessageFormat;
import java.util.Properties;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.internal.ui.CCOverLayIconUtility;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.LocalRepositoryNode;
import org.eclipse.datatools.connectivity.internal.ui.SharedImages;
import org.eclipse.datatools.connectivity.ui.ProfileImageRegistry;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class ConnectionProfileLabelProvider
extends LabelProvider
implements ICommonLabelProvider {
    private static String STATUSBAR_CONNECTED = "StatusBar.Connected";
    private static String STATUSBAR_OFFLINE = "StatusBar.WorkingOffline";
    private static String STATUSBAR_DISCONNECTED = "StatusBar.Disconnected";
    private static String STATUSBAR_MSG = "StatusBar.ConnectedMessage";

    public Image getImage(Object element) {
        Image image;
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (!(element instanceof ICategory)) break block8;
                        image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                        break block9;
                    }
                    if (!(element instanceof LocalRepositoryNode)) break block10;
                    image = SharedImages.get("org.eclipse.datatools.connectivity.ui.local_repository.gif");
                    break block9;
                }
                if (!(element instanceof IConnectionProfile)) break block11;
                IConnectionProfile profile = (IConnectionProfile)element;
                image = ProfileImageRegistry.getInstance().getProfileImage(profile.getProvider());
                switch (profile.getConnectionState()) {
                    case 1: {
                        ImageRegistry registry = ConnectivityUIPlugin.getDefault().getImageRegistry();
                        image = registry.get(profile.getName().concat(SharedImages.IMAGE_RUNNING));
                        if (image == null) {
                            image = CCOverLayIconUtility.getDefault().addOverlayIcon(ProfileImageRegistry.getInstance().getProfileImage(profile.getProvider()), CCOverLayIconUtility.RUNNING);
                            registry.put(profile.getName().concat(SharedImages.IMAGE_RUNNING), image);
                            break;
                        }
                        break block9;
                    }
                    case 2: {
                        ImageRegistry registry = ConnectivityUIPlugin.getDefault().getImageRegistry();
                        image = registry.get(profile.getName().concat(SharedImages.IMAGE_OFFLINE));
                        if (image != null) break block9;
                        image = CCOverLayIconUtility.getDefault().addOverlayIcon(ProfileImageRegistry.getInstance().getProfileImage(profile.getProvider()), CCOverLayIconUtility.OFFLINE);
                        registry.put(profile.getName().concat(SharedImages.IMAGE_OFFLINE), image);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block9;
            }
            image = null;
        }
        return image;
    }

    public String getText(Object element) {
        String text = null;
        if (element instanceof ProfileManager) {
            text = ConnectivityUIPlugin.getDefault().getResourceString("DSE.View.Tooltip");
        } else if (element instanceof ICategory) {
            text = ((ICategory)element).getName();
        } else if (element instanceof LocalRepositoryNode) {
            text = ConnectivityUIPlugin.getDefault().getResourceString("CommonLabelProviderBase.label.localRepository");
        } else if (element instanceof IConnectionProfile) {
            IConnectionProfile profile = (IConnectionProfile)element;
            StringBuffer sb = new StringBuffer(profile.getName());
            if (profile.getConnectionState() != 0) {
                Properties props = profile.getProperties("org.eclipse.datatools.connectivity.versionInfo");
                String serverName = props.getProperty("server.name");
                Version serverVersion = Version.valueOf((String)props.getProperty("server.version"));
                if (serverName != null && serverName.length() > 0) {
                    String versionStr = null;
                    versionStr = serverVersion.compareTo((Object)Version.NULL_VERSION) == 0 ? MessageFormat.format((String)ConnectivityUIPlugin.getDefault().getResourceString("CommonLabelProviderBase.label.version.versionless"), (Object[])new String[]{sb.toString(), serverName}) : MessageFormat.format((String)ConnectivityUIPlugin.getDefault().getResourceString("CommonLabelProviderBase.label.version"), (Object[])new String[]{profile.getName(), serverName, serverVersion.toString()});
                    sb = new StringBuffer(versionStr);
                }
            }
            text = sb.toString();
        } else {
            text = super.getText(element);
        }
        if (text != null && text.trim().length() > 0) {
            text = TextProcessor.process((String)text);
        }
        return text;
    }

    public void dispose() {
        super.dispose();
    }

    public void init(IExtensionStateModel aStateModel, ITreeContentProvider aContentProvider) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object element) {
        String desc;
        if (element instanceof ICategory) {
            desc = ((ICategory)element).getName();
        } else if (element instanceof IConnectionProfile) {
            String connectedState;
            IConnectionProfile profile = (IConnectionProfile)element;
            Properties props = profile.getBaseProperties();
            String serverName = props.getProperty("server.name");
            Version serverVersion = Version.valueOf((String)props.getProperty("server.version"));
            desc = serverName != null && serverName.length() > 0 || serverVersion != Version.NULL_VERSION ? MessageFormat.format((String)ConnectivityUIPlugin.getDefault().getResourceString("CommonLabelProviderBase.label.version"), (Object[])new String[]{profile.getName(), serverName, serverVersion.toString()}) : profile.getName();
            switch (profile.getConnectionState()) {
                case 1: {
                    connectedState = ConnectivityUIPlugin.getDefault().getResourceString(STATUSBAR_CONNECTED);
                    break;
                }
                case 2: {
                    connectedState = ConnectivityUIPlugin.getDefault().getResourceString(STATUSBAR_OFFLINE);
                    break;
                }
                default: {
                    connectedState = ConnectivityUIPlugin.getDefault().getResourceString(STATUSBAR_DISCONNECTED);
                }
            }
            desc = ConnectivityUIPlugin.getDefault().getResourceString(STATUSBAR_MSG, new String[]{desc, connectedState});
        } else {
            desc = null;
        }
        if (desc != null && desc.trim().length() > 0) {
            desc = TextProcessor.process((String)desc);
        }
        return desc;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }
}

