/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.actions;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileRenameProcessor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public class RenameAction
extends Action
implements IActionDelegate {
    private Shell mParentShell;
    private IConnectionProfile mProfile;

    public RenameAction() {
        Display display = Display.getCurrent();
        this.mParentShell = display.getActiveShell();
    }

    public void run() {
        IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.trim().length() == 0) {
                    return ConnectivityUIPlugin.getDefault().getResourceString("rename.dialog.errmsg.invalid");
                }
                if (RenameAction.this.nameExisting(newText)) {
                    return ConnectivityUIPlugin.getDefault().getResourceString("rename.dialog.errmsg.existing");
                }
                return null;
            }
        };
        InputDialog d = new InputDialog(this.mParentShell, ConnectivityUIPlugin.getDefault().getResourceString("rename.dialog.title"), ConnectivityUIPlugin.getDefault().getResourceString("rename.dialog.message"), this.mProfile.getName(), inputValidator);
        if (d.open() != 0) {
            return;
        }
        try {
            this.refactor(this.mProfile, d.getValue());
        }
        catch (CoreException e) {
            ExceptionHandler.showException(this.mParentShell, ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), e.getMessage(), e);
        }
    }

    private void refactor(IConnectionProfile profile, String newName) throws CoreException {
        PerformRefactoringOperation refOperation = new PerformRefactoringOperation((Refactoring)new RenameRefactoring((RenameProcessor)new ConnectionProfileRenameProcessor(profile, newName)), 6);
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)refOperation, null);
        }
        catch (OperationCanceledException oce) {
            throw new OperationCanceledException();
        }
        catch (CoreException ce) {
            throw ce;
        }
    }

    public void run(IAction action) {
        this.run();
    }

    private boolean nameExisting(String newName) {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfiles();
        for (int i = 0; i < profiles.length; ++i) {
            if (!profiles[i].getName().equals(newName)) continue;
            return true;
        }
        return false;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mProfile = null;
        if (selection instanceof IStructuredSelection) {
            Object selectedResource;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            action.setEnabled(false);
            if (structuredSelection.size() == 1 && (selectedResource = structuredSelection.getFirstElement()) instanceof ConnectionProfile) {
                IConnectionProfileRepository repo = ((ConnectionProfile)selectedResource).getRepository();
                action.setEnabled(repo == null || !repo.isReadOnly());
                this.mProfile = (IConnectionProfile)selectedResource;
            }
        }
    }
}

