/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.internal.ui.wizards.IMediator;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ISkippable;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ISummaryDataSource;
import org.eclipse.datatools.connectivity.internal.ui.wizards.IWizardAction;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public abstract class BaseWizard
extends Wizard
implements ISummaryDataSource,
IMediator {
    public IWizardPage getNextPage(IWizardPage page) {
        IWizardAction wizActions = null;
        IWizardPage nextPage = null;
        ISkippable nextPG = null;
        if (page instanceof IWizardAction && !(wizActions = (IWizardAction)page).onWizardNext()) {
            return page;
        }
        nextPage = super.getNextPage(page);
        while (nextPage != null && nextPage instanceof ISkippable && (nextPG = (ISkippable)nextPage).getSkippable()) {
            nextPage = super.getNextPage(nextPage);
        }
        if (nextPage != null && nextPage instanceof IWizardAction) {
            wizActions = (IWizardAction)nextPage;
            wizActions.onSetActive();
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage prevPage = null;
        ISkippable prevPG = null;
        prevPage = super.getPreviousPage(page);
        while (prevPage != null && prevPage instanceof ISkippable && (prevPG = (ISkippable)prevPage).getSkippable()) {
            prevPage = super.getPreviousPage(prevPage);
        }
        return prevPage;
    }

    public IWizardPage getStartingPage() {
        IWizardAction wizActions = null;
        IWizardPage[] pages = this.getPages();
        IWizardPage page = null;
        ISkippable pg = null;
        if (pages.length == 0) {
            return page;
        }
        for (int i = 0; i < pages.length && (page = pages[i]) instanceof ISkippable && (pg = (ISkippable)page).getSkippable(); ++i) {
        }
        if (page != null && page instanceof IWizardAction) {
            wizActions = (IWizardAction)page;
            wizActions.onSetActive();
        }
        return page;
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        for (int i = 0; i < pages.length; ++i) {
            if (pages[i].isPageComplete() || pages[i] instanceof ISkippable && ((ISkippable)pages[i]).getSkippable()) continue;
            return false;
        }
        return true;
    }

    public List getSummaryData() {
        ArrayList data = new ArrayList();
        IWizardPage[] pages = this.getPages();
        for (int i = 0; i < pages.length; ++i) {
            ISkippable page;
            if (!(pages[i] instanceof ISummaryDataSource) || pages[i] instanceof ISkippable && (page = (ISkippable)pages[i]).getSkippable()) continue;
            data.addAll(((ISummaryDataSource)pages[i]).getSummaryData());
        }
        return data;
    }

    public void mediatePage(IWizardPage wizardPage) {
    }
}

