/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui;

import java.net.URL;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class ProfileImageRegistry {
    private static final String IMG_OBJ_SERVER_DEFAULT = "org.eclipse.datatools.connectivity.ui.server_default_obj.gif";
    private static final String IMG_DESC_SERVER_DEFAULT = "icons/full/obj16/server_obj.gif";
    private static ProfileImageRegistry sInstance = new ProfileImageRegistry();
    private ImageRegistry mImageRegistry = new ImageRegistry();

    public static ProfileImageRegistry getInstance() {
        return sInstance;
    }

    public Image getProfileImage(IConnectionProfileProvider provider) {
        Image image = this.mImageRegistry.get(provider.getId());
        if (image == null) {
            URL iconURL = provider.getIconURL();
            if (iconURL != null) {
                ImageDescriptor imageDesc = ImageDescriptor.createFromURL((URL)iconURL);
                this.mImageRegistry.put(provider.getId(), imageDesc);
                image = this.mImageRegistry.get(provider.getId());
            }
            if (image == null) {
                image = this.mImageRegistry.get(IMG_OBJ_SERVER_DEFAULT);
            }
        }
        return image;
    }

    private ProfileImageRegistry() {
        this.mImageRegistry.put(IMG_OBJ_SERVER_DEFAULT, ImageDescriptor.createFromURL((URL)ConnectivityUIPlugin.getDefault().getBundle().getEntry(IMG_DESC_SERVER_DEFAULT)));
    }
}

