/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import java.util.Vector;
import org.eclipse.datatools.connectivity.internal.ui.DriverImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageIcon
extends CompositeImageDescriptor {
    private Image baseImage_;
    private Point sizeOfImage_;
    private Vector imageKey_;
    private DriverImages driverImage_;
    private static final int TOP_LEFT = 0;
    private static final int TOP_RIGHT = 1;
    private static final int BOTTOM_LEFT = 2;
    private static final int BOTTOM_RIGHT = 3;

    public OverlayImageIcon(Image baseImage, DriverImages demoImage, Vector imageKey) {
        this.baseImage_ = baseImage;
        this.driverImage_ = demoImage;
        this.imageKey_ = imageKey;
        this.sizeOfImage_ = new Point(baseImage.getBounds().width, baseImage.getBounds().height);
    }

    protected void drawCompositeImage(int arg0, int arg1) {
        this.drawImage(this.baseImage_.getImageData(), 0, 0);
        int[] locations = this.organizeImages();
        block6: for (int i = 0; i < this.imageKey_.size(); ++i) {
            ImageData imageData = this.driverImage_.getImageData((String)this.imageKey_.get(i));
            switch (locations[i]) {
                case 0: {
                    this.drawImage(imageData, 0, 0);
                    continue block6;
                }
                case 1: {
                    this.drawImage(imageData, this.sizeOfImage_.x - imageData.width, 0);
                    continue block6;
                }
                case 2: {
                    this.drawImage(imageData, 0, this.sizeOfImage_.y - imageData.height);
                    continue block6;
                }
                case 3: {
                    this.drawImage(imageData, this.sizeOfImage_.x - imageData.width, this.sizeOfImage_.y - imageData.height);
                }
            }
        }
    }

    private int[] organizeImages() {
        int[] locations = new int[this.imageKey_.size()];
        for (int i = 0; i < this.imageKey_.size(); ++i) {
            String imageKeyValue = (String)this.imageKey_.get(i);
            if (imageKeyValue.equals(DriverImages.ERROR_KEY)) {
                locations[i] = 0;
            }
            if (!imageKeyValue.equals(DriverImages.WARNING_KEY)) continue;
            locations[i] = 1;
        }
        return locations;
    }

    protected Point getSize() {
        return this.sizeOfImage_;
    }

    public Image getImage() {
        return this.createImage();
    }
}

