/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.wizards;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizardPage;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class ConnectionProfileDetailsPage
extends BaseWizardPage
implements IContextProvider {
    protected Button btnPing;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());

    public ConnectionProfileDetailsPage(String name) {
        super(name);
    }

    public ConnectionProfileDetailsPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        container.setLayout((Layout)gridLayout);
        this.setControl((Control)container);
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createCustomControl(composite);
        this.btnPing = new Button(container, 0);
        this.btnPing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionProfileDetailsPage.this.testConnection();
            }
        });
        this.btnPing.setLayoutData((Object)new GridData(128));
        this.btnPing.setText(ConnectivityUIPlugin.getDefault().getResourceString("ConnectionProfileDetailsPage.Button.TestConnection"));
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getControl(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_PROFILE_DETAILS_PROPERTY_PAGE", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public abstract void createCustomControl(Composite var1);

    protected void testConnection() {
        IWizard wiz = this.getWizard();
        if (wiz instanceof NewConnectionProfileWizard) {
            NewConnectionProfileWizard wizard = (NewConnectionProfileWizard)wiz;
            ConnectionProfile profile = new ConnectionProfile(wizard.getProfileName(), wizard.getProfileDescription(), wizard.getProfileProviderID(), wizard.getParentProfile(), wizard.getProfileIsAutoConnect());
            if (this.getErrorMessage() != null) {
                MessageDialog.openError((Shell)this.getWizard().getContainer().getShell(), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"), (String)this.getErrorMessage());
                return;
            }
            profile.setBaseProperties(wizard.getProfileProperties());
            final PingJob pingJob = new PingJob(this.getShell(), (IConnectionProfile)profile);
            pingJob.schedule();
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        pingJob.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }
}

