/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPCategoryWizardNode;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardNode;
import org.eclipse.datatools.connectivity.internal.ui.wizards.CPWizardSelectionPage;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCPWizardCategoryFilter;
import org.eclipse.datatools.connectivity.internal.ui.wizards.NewCategoryWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ProfileWizardProvider;
import org.eclipse.datatools.connectivity.ui.wizards.ICPWizard;
import org.eclipse.datatools.connectivity.ui.wizards.IWizardCategoryProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class AddProfileViewAction
extends Action
implements IViewActionDelegate {
    private String categoryID;
    private IConnectionProfile parentProfile;
    private int returnCode;
    private IConnectionProfile addedProfile;

    public AddProfileViewAction() {
        this.setText(ConnectivityUIPlugin.getDefault().getResourceString("ServersView.action.newCP"));
    }

    public AddProfileViewAction(ICategory category) {
        this(category.getId());
    }

    public AddProfileViewAction(String categoryID) {
        this.categoryID = categoryID;
    }

    public void init(IViewPart viewpart) {
    }

    public void run() {
        Object wizard = this.getDefaultWizard(new String(), this.categoryID);
        NewCPWizardCategoryFilter viewerFilter = new NewCPWizardCategoryFilter(this.categoryID);
        if (wizard == null) {
            wizard = new NewCPWizard(viewerFilter, this.parentProfile);
        }
        WizardDialog wizardDialog = new WizardDialog(ConnectivityUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), wizard);
        wizardDialog.setBlockOnOpen(true);
        InternalProfileListener listener = new InternalProfileListener();
        ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
        this.returnCode = wizardDialog.open();
        this.addedProfile = listener.cachedProfile;
        ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setCategory(ICategory category) {
        this.setCategory(category == null ? null : category.getId());
    }

    public void setCategory(String categoryID) {
        this.categoryID = categoryID;
    }

    public void setParentProfile(IConnectionProfile profile) {
        this.parentProfile = profile;
    }

    public IConnectionProfile getParentProfile() {
        return this.parentProfile;
    }

    public int getWizardReturnCode() {
        return this.returnCode;
    }

    public IConnectionProfile getAddedProfile() {
        return this.addedProfile;
    }

    private IWizard getDefaultWizard(String parentCategoryID, String categoryID) {
        IWizard wizard;
        List wizardNodes = new CPWizardSelectionPage(new String()).getCatagoryItems(parentCategoryID);
        if (categoryID != null) {
            NewCPWizardCategoryFilter filter = new NewCPWizardCategoryFilter(categoryID);
            Iterator it = wizardNodes.iterator();
            while (it.hasNext()) {
                if (filter.select(null, null, it.next())) continue;
                it.remove();
            }
        }
        if (wizardNodes == null || wizardNodes.size() == 0) {
            return null;
        }
        if (wizardNodes.size() > 1) {
            return null;
        }
        CPWizardNode wizardNode = (CPWizardNode)wizardNodes.get(0);
        if (wizardNode instanceof CPCategoryWizardNode) {
            wizard = this.getDefaultWizard(((CPCategoryWizardNode)wizardNode).getProvider().getCategory(), null);
            if (wizard == null && (wizard = wizardNode.getWizard()) instanceof NewCategoryWizard) {
                ((NewCategoryWizard)wizard).initWizardCategory((IWizardCategoryProvider)wizardNode.getProvider());
            }
        } else {
            wizard = wizardNode.getWizard();
            if (wizard instanceof ICPWizard) {
                ((ICPWizard)wizard).initProviderID(((ProfileWizardProvider)wizardNode.getProvider()).getProfile());
                ((ICPWizard)wizard).setParentProfile(this.parentProfile);
            }
        }
        return wizard;
    }

    private class InternalProfileListener
    implements IProfileListener {
        protected IConnectionProfile cachedProfile;

        private InternalProfileListener() {
        }

        public void profileAdded(IConnectionProfile profile) {
            this.cachedProfile = profile;
        }

        public void profileChanged(IConnectionProfile profile) {
        }

        public void profileDeleted(IConnectionProfile profile) {
        }
    }
}

