/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.actions;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorContentService;

public class ShowCategoryAction
implements IViewActionDelegate {
    IViewPart view = null;
    Object currentInput = ResourcesPlugin.getWorkspace().getRoot();
    boolean currentState = true;

    public void init(IViewPart view) {
        this.view = view;
        if (view instanceof CommonNavigator) {
            IExtensionStateModel stateModel = ((CommonNavigator)view).getNavigatorContentService().findStateModel("org.eclipse.datatools.connectivity.dsexplorer.content");
            stateModel.setBooleanProperty("showCategories", this.currentState);
        }
    }

    public void run(IAction action) {
        this.currentState = action.isChecked();
        this.changeShowCategorySetting(this.currentState);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
        action.setChecked(this.currentState);
    }

    private void changeShowCategorySetting(boolean flag) {
        if (this.view instanceof CommonNavigator) {
            CommonNavigator commonNav = (CommonNavigator)this.view;
            if (this.currentInput != null && (this.currentInput instanceof ICategory || this.currentInput instanceof ProfileManager || this.currentInput instanceof IWorkspaceRoot || this.currentInput instanceof IConnectionProfile)) {
                INavigatorContentService ncs = commonNav.getNavigatorContentService();
                IExtensionStateModel stateModel = ncs.findStateModel("org.eclipse.datatools.connectivity.dsexplorer.content");
                stateModel.setBooleanProperty("showCategories", flag);
                commonNav.getCommonViewer().refresh();
                if (flag) {
                    commonNav.getCommonViewer().expandToLevel(2);
                }
            }
        }
    }
}

