/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IPropertySetChangeEvent;
import org.eclipse.datatools.connectivity.IPropertySetListener;
import org.eclipse.datatools.connectivity.ProfileConnectionManager;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.ui.actions.AddProfileViewAction;
import org.eclipse.datatools.connectivity.ui.actions.ConnectAction;
import org.eclipse.datatools.connectivity.ui.actions.DisconnectAction;
import org.eclipse.datatools.connectivity.ui.dse.DSEPlugin;
import org.eclipse.datatools.connectivity.ui.dse.dialogs.filters.DownToProfilesOnlyFilter;
import org.eclipse.datatools.connectivity.ui.dse.dialogs.filters.ProfileCategoryFilter;
import org.eclipse.datatools.connectivity.ui.dse.views.ConnectionProfileContentProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;

public class ProfileSelectionDialogPage
extends DialogPage
implements IPropertySetListener {
    private static final int MIN_VIEWER_ELEMENTS = 4;
    public static final String TITLE = null;
    public static final ImageDescriptor ICON_DESC = null;
    protected Object mInitialSelection;
    private ICategory mCategory;
    protected String mMissingEndpointReferenceString = DSEPlugin.getDefault().getResourceString("ProfileSelectionDialogPage.validation.error");
    private CommonViewer mViewer;
    private ViewerFilter mFilter;
    private ActionGroup mConnectActions;
    private Button mConnect;
    private Button mNew;
    private Button mSelectAll;
    private Button mDeselectAll;
    private boolean mShowNew = true;
    private boolean mShowConnect = true;
    private boolean mShowSelectButtons = true;
    private boolean mLimitToProfiles = true;
    private boolean inConnect = false;
    private boolean doneConnect = false;
    private boolean failedConnection = false;

    public ProfileSelectionDialogPage() {
        this(TITLE, ICON_DESC);
    }

    public ProfileSelectionDialogPage(String title) {
        this(title, ICON_DESC);
    }

    public ProfileSelectionDialogPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(Object selection, Class endpointType, ViewerFilter filter, ICategory category) {
        this.mInitialSelection = selection;
        this.mFilter = filter;
        this.mCategory = category;
        this.initControls();
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        content.setLayoutData((Object)new GridData(1808));
        this.doCreateControl(content);
        this.initControls();
        this.setControl((Control)content);
    }

    protected void doCreateControl(Composite content) {
        this.doCreateControl(content, false);
    }

    protected void doCreateControl(Composite content, boolean flag) {
        this.doCreateControl(content, flag, true);
    }

    protected void doCreateControl(Composite content, boolean flag, boolean multiSelect) {
        GridData gridData;
        CommonViewer mCommonViewer;
        INavigatorContentService navigatorService = null;
        int styles = 2816;
        styles = multiSelect ? 2 | styles : 4 | styles;
        this.mViewer = mCommonViewer = new CommonViewer("org.eclipse.datatools.connectivity.DataSourceExplorerNavigator", content, styles);
        navigatorService = mCommonViewer.getNavigatorContentService();
        Set rootExtensions = navigatorService.findRootContentExtensions((Object)ProfileManager.getInstance());
        Iterator iterator = rootExtensions.iterator();
        while (iterator.hasNext()) {
            INavigatorContentExtension extension = (INavigatorContentExtension)iterator.next();
            ITreeContentProvider provider = extension.getContentProvider();
            if (!(extension.getContentProvider() instanceof ConnectionProfileContentProvider)) continue;
            ((ConnectionProfileContentProvider)provider).setShowCategories(false);
        }
        ProfileManager input = ProfileManager.getInstance();
        CommonViewer tViewer = this.mViewer;
        final ProfileManager mInput = input;
        Display display = DSEPlugin.getDefault().getWorkbench().getDisplay();
        display.syncExec(new Runnable((TreeViewer)tViewer){
            private final /* synthetic */ TreeViewer val$tViewer;
            {
                this.val$tViewer = val$tViewer;
            }

            public void run() {
                if (mInput != null) {
                    this.val$tViewer.setInput(mInput);
                }
            }
        });
        this.mConnectActions = new ConnectActions();
        this.hookContextMenu(this.mConnectActions);
        if (this.mFilter != null) {
            this.mViewer.addFilter(this.mFilter);
        }
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 1;
        data.verticalSpan = 4;
        data.heightHint = this.mViewer.getTree().getItemHeight() * 4;
        this.mViewer.getControl().setLayoutData((Object)data);
        if (this.mShowConnect) {
            this.mConnect = new Button(content, 8);
            this.mConnect.setText(DSEPlugin.getDefault().getResourceString("DSE.Connect.label"));
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 128;
            this.mConnect.setLayoutData((Object)gridData);
            this.mConnect.setEnabled(false);
            this.mConnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ProfileSelectionDialogPage.this.failedConnection = false;
                    ProfileSelectionDialogPage.this.handleConnect();
                }
            });
        }
        if (this.mShowNew) {
            this.mNew = new Button(content, 8);
            this.mNew.setText(DSEPlugin.getDefault().getResourceString("ServersView.action.newCP"));
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 128;
            this.mNew.setLayoutData((Object)gridData);
            this.mNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ProfileSelectionDialogPage.this.handleNew();
                }
            });
        }
        if (this.mShowSelectButtons) {
            this.mSelectAll = new Button(content, 8);
            this.mSelectAll.setText(DSEPlugin.getDefault().getResourceString("DSE.SelectAll.label"));
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 128;
            this.mSelectAll.setLayoutData((Object)gridData);
            this.mSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ProfileSelectionDialogPage.this.selectAll();
                }
            });
            this.mDeselectAll = new Button(content, 8);
            this.mDeselectAll.setText(DSEPlugin.getDefault().getResourceString("DSE.DeselectAll.label"));
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 128;
            this.mDeselectAll.setLayoutData((Object)gridData);
            this.mDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ProfileSelectionDialogPage.this.unselectAll();
                }
            });
        }
        this.mViewer.setSorter(new ViewerSorter());
    }

    protected void initControls() {
        if (this.mViewer == null) {
            return;
        }
        if (this.mInitialSelection != null) {
            this.mViewer.setSelection((ISelection)new StructuredSelection(this.mInitialSelection));
            this.mViewer.getTree().showSelection();
            if (this.mViewer.getTree().getItemCount() == 1 && this.mShowConnect) {
                this.handleConnect();
            }
        } else {
            this.validate();
        }
        this.setErrorMessage(null);
        boolean hasFilter = false;
        if (this.mFilter != null) {
            hasFilter = true;
            this.mViewer.removeFilter(this.mFilter);
            this.mViewer.addFilter(this.mFilter);
        }
        if (this.mCategory != null) {
            hasFilter = true;
            ProfileCategoryFilter categoryFilter = new ProfileCategoryFilter();
            categoryFilter.setSelectedCategory(this.mCategory.getId());
            this.mViewer.addFilter((ViewerFilter)categoryFilter);
        }
        if (this.mLimitToProfiles) {
            hasFilter = true;
            DownToProfilesOnlyFilter mProfileFilter = new DownToProfilesOnlyFilter();
            this.mViewer.addFilter((ViewerFilter)mProfileFilter);
        }
        if (hasFilter) {
            this.mViewer.refresh();
        }
    }

    public void validate() {
        IStructuredSelection selection = (IStructuredSelection)this.mViewer.getSelection();
        String error = null;
        if (selection == null || selection.isEmpty()) {
            error = this.mMissingEndpointReferenceString;
            if (this.mConnect != null) {
                this.mConnect.setEnabled(false);
            }
        } else {
            boolean isProfileDisConnected;
            Object obj = selection.getFirstElement();
            boolean isProfile = obj instanceof IConnectionProfile;
            boolean bl = isProfileDisConnected = isProfile && ((IConnectionProfile)obj).getConnectionState() == 0;
            if (isProfileDisConnected) {
                if (this.mConnect != null) {
                    this.mConnect.setEnabled(true);
                }
                if (this.mSelectAll != null) {
                    this.mSelectAll.setEnabled(false);
                }
            } else {
                if (this.mConnect != null) {
                    this.mConnect.setEnabled(false);
                }
                if (this.mSelectAll != null) {
                    this.mSelectAll.setEnabled(true);
                }
            }
            if (obj instanceof IConnectionProfile) {
                ((IConnectionProfile)obj).removePropertySetListener((IPropertySetListener)this);
                ((IConnectionProfile)obj).addPropertySetListener((IPropertySetListener)this);
            }
        }
        this.setErrorMessage(error);
    }

    public TreeViewer getNavigatorViewer() {
        return this.mViewer;
    }

    public void dispose() {
        Iterator<IConnectionProfile> it = Arrays.asList(ProfileManager.getInstance().getProfiles()).iterator();
        while (it.hasNext()) {
            it.next().removePropertySetListener((IPropertySetListener)this);
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnect() {
        this.inConnect = true;
        this.doneConnect = false;
        if (this.failedConnection) {
            return;
        }
        final IStructuredSelection selection = (IStructuredSelection)this.mViewer.getSelection();
        final IConnectionProfile profile = (IConnectionProfile)selection.getFirstElement();
        if (profile != null) {
            Display.getCurrent().readAndDispatch();
            ProfileConnectionManager.getProfileConnectionManagerInstance().manageProfileConnection(profile, "com.sybase.ebd.eai.wsmf.providers.IWSMFProvider", (Object)this);
            if (profile.getConnectionState() != 1) {
                try {
                    IRunnableWithProgress op = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            IStatus status = profile.connect();
                            switch (status.getSeverity()) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    break;
                                }
                                case 4: {
                                    ProfileSelectionDialogPage.this.failedConnection = true;
                                    profile.disconnect();
                                }
                            }
                            if (Display.getCurrent() != null) {
                                Display.getCurrent().readAndDispatch();
                            }
                            ProfileSelectionDialogPage.this.mConnect.setEnabled(((IConnectionProfile)selection.getFirstElement()).getConnectionState() != 1);
                            ProfileSelectionDialogPage.this.inConnect = false;
                            ProfileSelectionDialogPage.this.doneConnect = true;
                            if (ProfileSelectionDialogPage.this.mViewer != null && !ProfileSelectionDialogPage.this.mViewer.getTree().isDisposed()) {
                                ProfileSelectionDialogPage.this.mViewer.getTree().setFocus();
                            }
                        }
                    };
                    new ProgressMonitorDialog(this.getControl().getShell()).run(true, false, op);
                }
                catch (InvocationTargetException e) {
                }
                catch (InterruptedException e) {
                    this.failedConnection = true;
                    profile.disconnect();
                }
            }
        }
    }

    public void handleNew() {
        IStructuredSelection selection = (IStructuredSelection)this.mViewer.getSelection();
        AddProfileViewAction newAction = new AddProfileViewAction(this.mCategory);
        newAction.selectionChanged(null, (ISelection)selection);
        if (this.mCategory != null) {
            newAction.setCategory(this.mCategory);
        }
        newAction.run(null);
        this.mViewer.refresh();
    }

    public void propertySetChanged(IPropertySetChangeEvent event) {
        if (event.getChangedProperty("connectionState") != null) {
            final IConnectionProfile profile = event.getConnectionProfile();
            Runnable torun = new Runnable(){

                public void run() {
                    if (profile != null && profile.getConnectionState() != 1) {
                        if (ProfileSelectionDialogPage.this.mConnect != null && !ProfileSelectionDialogPage.this.mConnect.isDisposed() && !ProfileSelectionDialogPage.this.mConnect.isEnabled()) {
                            ProfileSelectionDialogPage.this.mConnect.setEnabled(true);
                        }
                    } else if (ProfileSelectionDialogPage.this.mConnect != null && !ProfileSelectionDialogPage.this.mConnect.isDisposed() && ProfileSelectionDialogPage.this.mConnect.isEnabled()) {
                        ProfileSelectionDialogPage.this.mConnect.setEnabled(false);
                    }
                }
            };
            Display.getDefault().asyncExec(torun);
        }
    }

    public void setShowNew(boolean flag) {
        this.mShowNew = flag;
    }

    public boolean getShowNew() {
        return this.mShowNew;
    }

    public void setShowConnect(boolean flag) {
        this.mShowConnect = flag;
    }

    public boolean getShowConnect() {
        return this.mShowConnect;
    }

    public void setShowSelectButtons(boolean flag) {
        this.mShowSelectButtons = flag;
    }

    public boolean getShowSelectButtons() {
        return this.mShowSelectButtons;
    }

    public void setLimitToProfiles(boolean flag) {
        this.mLimitToProfiles = flag;
    }

    public boolean getLimitToProfiles() {
        return this.mLimitToProfiles;
    }

    public boolean getInConnect() {
        return this.inConnect;
    }

    public boolean getDoneConnect() {
        return this.doneConnect;
    }

    public void createControl(Composite parent, boolean flag) {
        this.createControl(parent, flag, true);
    }

    public void createControl(Composite parent, boolean flag, boolean multiSelect) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        content.setLayoutData((Object)new GridData(1808));
        this.doCreateControl(content, flag, multiSelect);
        this.setControl((Control)content);
        this.initControls();
    }

    public void setInput(Object object) {
        if (this.getNavigatorViewer() != null) {
            this.getNavigatorViewer().setInput(object);
        }
    }

    public void select(IConnectionProfile profile) {
        if (profile != null) {
            this.mViewer.setSelection((ISelection)new StructuredSelection((Object)profile), true);
        }
    }

    public void selectAll() {
        TreeViewer viewer = this.getNavigatorViewer();
        viewer.getTree().selectAll();
        this.validate();
    }

    public void unselectAll() {
        TreeViewer viewer = this.getNavigatorViewer();
        viewer.getTree().deselectAll();
    }

    public static String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    public IConnectionProfile[] getSelectedProfiles() {
        return new IConnectionProfile[0];
    }

    public IConnectionProfile[] getSelectedProfiles(boolean selectAllOnStartup) {
        return new IConnectionProfile[0];
    }

    public boolean canConnect() {
        if (this.mConnect != null) {
            return this.mConnect.isEnabled();
        }
        return false;
    }

    public boolean canNew() {
        if (this.mNew != null) {
            return this.mNew.isEnabled();
        }
        return false;
    }

    public void setEnabled(boolean flag) {
        if (this.getNavigatorViewer() != null) {
            this.getNavigatorViewer().getTree().setEnabled(flag);
            if (flag) {
                this.getNavigatorViewer().getTree().setBackground(this.getNavigatorViewer().getTree().getDisplay().getSystemColor(25));
            } else {
                this.getNavigatorViewer().getTree().setBackground(this.getNavigatorViewer().getTree().getDisplay().getSystemColor(34));
            }
        }
    }

    public boolean performOk() {
        return true;
    }

    protected void hookContextMenu(ActionGroup actionGroup) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                IStructuredSelection selection = (IStructuredSelection)ProfileSelectionDialogPage.this.mViewer.getSelection();
                ProfileSelectionDialogPage.this.mViewer.setSelection((ISelection)selection);
                ActionContext context = new ActionContext((ISelection)selection);
                ProfileSelectionDialogPage.this.mConnectActions.setContext(context);
                ProfileSelectionDialogPage.this.mConnectActions.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.mViewer.getControl());
        this.mViewer.getControl().setMenu(menu);
    }

    class ConnectActions
    extends ActionGroup {
        IAction connectAction;
        IAction disconnectAction;

        ConnectActions() {
            this.connectAction = new InternalConnectAction((ISelectionProvider)ProfileSelectionDialogPage.this.mViewer);
            this.disconnectAction = new InternalDisconnectAction((ISelectionProvider)ProfileSelectionDialogPage.this.mViewer);
        }

        public void fillContextMenu(IMenuManager menu) {
            Object obj;
            ActionContext context = this.getContext();
            IStructuredSelection selection = (IStructuredSelection)context.getSelection();
            if (!selection.isEmpty() && (obj = selection.getFirstElement()) instanceof IConnectionProfile && ProfileSelectionDialogPage.this.mShowConnect) {
                menu.add(this.connectAction);
                menu.add(this.disconnectAction);
            }
        }

        class InternalConnectAction
        extends SelectionProviderAction {
            IConnectionProfile connectionProfile;

            public InternalConnectAction(ISelectionProvider provider) {
                super(provider, DSEPlugin.getDefault().getResourceString("DSE.Connect.label"));
            }

            public void run() {
                ProfileSelectionDialogPage.this.failedConnection = false;
                ConnectAction connectAction = new ConnectAction(ProfileSelectionDialogPage.this.mViewer.getTree().getShell());
                connectAction.selectionChanged((IAction)this, this.getSelection());
                connectAction.run((IAction)this);
            }

            public void selectionChanged(IStructuredSelection selection) {
                Object obj;
                if (!selection.isEmpty() && (obj = selection.getFirstElement()) instanceof IConnectionProfile) {
                    this.connectionProfile = (IConnectionProfile)obj;
                    this.setEnabled(this.connectionProfile.getConnectionState() != 1);
                }
            }
        }

        class InternalDisconnectAction
        extends SelectionProviderAction {
            IConnectionProfile connectionProfile;

            public InternalDisconnectAction(ISelectionProvider provider) {
                super(provider, DSEPlugin.getDefault().getResourceString("DSE.Disconnect.label"));
            }

            public void run() {
                DisconnectAction disconnectAction = new DisconnectAction();
                disconnectAction.selectionChanged((IAction)this, this.getSelection());
                disconnectAction.run((IAction)this);
            }

            public void selectionChanged(IStructuredSelection selection) {
                Object obj;
                if (!selection.isEmpty() && (obj = selection.getFirstElement()) instanceof IConnectionProfile) {
                    this.connectionProfile = (IConnectionProfile)obj;
                    this.setEnabled(this.connectionProfile.getConnectionState() != 0);
                }
            }
        }
    }
}

