/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.dialogs;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.datatools.connectivity.ui.dse.DSEPlugin;
import org.eclipse.datatools.connectivity.ui.dse.dialogs.ProfileSelectionComposite;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ProfileSelectionDialog
extends TitleAreaDialog
implements IContextProvider {
    private String _profile;
    private String _category;
    private boolean _limitToProfiles = true;
    private boolean mShowNew = true;
    private boolean mShowConnect = true;
    private boolean mShowSelectButtons = false;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(DSEPlugin.getDefault().getBundle().getSymbolicName());
    private ProfileSelectionComposite composite = null;

    public ProfileSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getShell(), (String)HelpUtil.getContextId((String)"PROFILE_SELECTION_DIALOG", (String)DSEPlugin.getDefault().getBundle().getSymbolicName()));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DSEPlugin.getDefault().getResourceString("ProfileSelectionDialog.Dialog.Title"));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(DSEPlugin.getDefault().getResourceString("ProfileSelectionDialog.Title"));
        this.setMessage(DSEPlugin.getDefault().getResourceString("ProfileSelectionDialog.Message"));
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        container.setLayout((Layout)gridLayout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite = new ProfileSelectionComposite(container, 0, this._category, this._limitToProfiles, this.mShowNew, this.mShowConnect, this.mShowSelectButtons);
        this.composite.setCPName(this._profile);
        this.fillInDefaultValues();
        if (!this.mShowConnect) {
            this.composite.getPage().getNavigatorViewer().expandAll();
        }
        return container;
    }

    protected ProfileSelectionComposite getComposite() {
        return this.composite;
    }

    public void fillInDefaultValues() {
        this.getComposite().fillInDefaultValues();
        this.initListeners();
        this.validate();
    }

    private void initListeners() {
        this.getComposite().addChangeListener(new MyChangeListener());
    }

    public String getCPName() {
        return this._profile;
    }

    public void setCPName(String input) {
        this._profile = input;
    }

    public String getCategoryName() {
        return this._category;
    }

    public void setCategoryName(String input) {
        this._category = input;
    }

    public void setLimitToProfiles(boolean flag) {
        this._limitToProfiles = flag;
    }

    public boolean getLimitToProfiles() {
        return this._limitToProfiles;
    }

    public void setShowNew(boolean flag) {
        this.mShowNew = flag;
    }

    public boolean getShowNew() {
        return this.mShowNew;
    }

    public void setShowConnect(boolean flag) {
        this.mShowConnect = flag;
    }

    public boolean getShowConnect() {
        return this.mShowConnect;
    }

    public void setShowSelectButtons(boolean flag) {
        this.mShowSelectButtons = flag;
    }

    public boolean getShowSelectButtons() {
        return this.mShowSelectButtons;
    }

    protected void validate() {
        Runnable torun = new Runnable(){

            public void run() {
                Button btn;
                boolean hasProfile = false;
                if (ProfileSelectionDialog.this._profile != null && ProfileSelectionDialog.this._profile.trim().length() > 0) {
                    hasProfile = true;
                }
                if ((btn = ProfileSelectionDialog.this.getButton(0)) != null && hasProfile) {
                    btn.setEnabled(true);
                } else if (btn != null) {
                    btn.setEnabled(false);
                }
            }
        };
        Display.getDefault().asyncExec(torun);
    }

    public boolean close() {
        this.getComposite().dispose();
        return super.close();
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    private class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        public void stateChanged(ChangeEvent arg0) {
            ProfileSelectionDialog.this._profile = ProfileSelectionDialog.this.getComposite().getCPName();
        }
    }
}

